
--
-- Copyright (C) 2018  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--

with gl;  use gl;
with ada.finalization;
with unchecked_deallocation;



package frameobj is -- for textured frame of rectangular region

-- frameobj:  only ONE face is drawn
-- ...either NO, WE, SO, EA according to the integer iwhich = 1..4

type frame is tagged private;

procedure setrect( rect: frame;
xc,yc,zc, xr,yr,zr, ww : float;
iwhich: integer
);

procedure draw( rect: frame; vertbuff, uvbuff, elembuff : gluint );
procedure ldraw( rect: frame; vertbuff, uvbuff, normbuff, elembuff : gluint );

private

ncorners : constant integer := 16;
nvert : constant integer := 3*ncorners;
nuv   : constant integer := 2*nvert/3;
nelm  : constant integer := nvert/2;

type varray is array(1..nvert) of float;
type vap is access varray;

type tarray is array(1..nuv) of float;
type tap is access tarray;

type earray is array(1..nelm) of glushort;
type eap is access earray;

type frame is new ada.finalization.controlled with record
	vert, norm : vap;
	txuv : tap;
	elem : eap;
end record;


procedure initialize(rect: in out frame);
procedure finalize(rect: in out frame);

end frameobj;

