package jp.naist.se.stigmata.reader;

/*
 * $Id: ClassFileArchive.java 140 2007-06-28 10:48:47Z tama3 $
 */

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;

/**
 * abstract presentation of class file archive's location.
 *
 * @author Haruaki TAMADA
 * @version $Revision: 140 $ $Date: 2007-06-28 19:48:47 +0900 (Thu, 28 Jun 2007) $
 */
public interface ClassFileArchive extends Iterable<ClassFileEntry>{
    public URL getLocation();

    public InputStream getInputStream(ClassFileEntry entry) throws IOException;

    public Iterator<ClassFileEntry> iterator();

    public boolean hasEntry(String className);

    public ClassFileEntry getEntry(String className) throws ClassNotFoundException;

    public String getName();
}
