package jp.naist.se.stigmata.format.xml;

/*
 * $Id: BirthmarkServiceListXmlFormat.java 174 2007-08-28 05:59:27Z tama3 $
 */

import java.io.PrintWriter;

import jp.naist.se.stigmata.format.AbstractBirthmarkServiceListFormat;
import jp.naist.se.stigmata.spi.BirthmarkSpi;

/**
 * 
 * 
 *
 * @author Haruaki TAMADA
 * @version $Revision: 174 $ $Date: 2007-08-28 14:59:27 +0900 (Tue, 28 Aug 2007) $
 */
public class BirthmarkServiceListXmlFormat extends AbstractBirthmarkServiceListFormat{
    public void printResult(PrintWriter out, BirthmarkSpi[] spilist){
        out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.println("<birthmark>");
        out.println("  <birthmark-services>");
        for(BirthmarkSpi spi: spilist){
            out.println("    <birthmark-service>");
            out.printf("      <type>%s</type>%n", spi.getType());
            out.printf("      <display-name>%s</display-name>%n", spi.getDisplayType());
            out.printf("      <description>%s</description>%n", spi.getDescription());
            out.printf("      <class-name>%s</class-name>%n", spi.getClass().getName());
            out.printf("      <extractor>%s</extractor>%n", spi.getExtractorClassName());
            out.printf("      <comparator>%s</comparator>%n", spi.getComparatorClassName());
            out.println("    </birthmark-service>");
        }
        out.println("  </birthmark-services>");
        out.println("</birthmark>");

        out.flush();
    }
}
