/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.command;

import java.sql.*;

import net.argius.logging.*;
import net.argius.stew.*;

/**
 * sԂvR}hB
 * 
 * sԂ́A
 * <code>Statement#executeQuery(String)</code> ܂ <code>Statement#executeUpdate(String)</code>
 * ̑O̎Ԃ<code>System.currentTimemillis()</code>Ŏ擾ŌvB
 */
public final class Time extends Command {

    private static final Logger log = LoggerFactory.getLogger(Time.class);

    @Override
    public void execute(Connection conn, Parameter parameter) throws CommandException {
        if (parameter.isEmpty(2)) {
            throw new UsageException(getUsage());
        }
        int argsIndex = 2;
        final String p1 = parameter.get(argsIndex);
        final int times;
        if (Character.isDigit(p1.charAt(0))) {
            int number;
            try {
                number = Integer.parseInt(p1);
                if (number < 1) {
                    throw new UsageException(getUsage());
                }
                ++argsIndex;
            } catch (NumberFormatException ex) {
                log.warn(ex);
                number = 1;
            }
            times = number;
        } else {
            times = 1;
        }
        final String sql = parameter.getAll(argsIndex);
        try {
            if (times > 1) {
                tryManyTimes(conn, sql, times);
            } else {
                tryOnce(conn, sql);
            }
        } catch (SQLException ex) {
            throw new CommandException(ex);
        }
    }

    /**
     * SQLsB
     * @param conn RlNV
     * @param sql SQL
     * @throws SQLException
     */
    private void tryOnce(Connection conn, String sql) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("tryOnce");
        }
        Statement stmt = prepareStatement(conn, sql);
        try {
            final long beginningTime;
            final long endTime;
            if (isSelect(sql)) {
                beginningTime = System.currentTimeMillis();
                ResultSet rs = executeQuery(stmt, sql);
                try {
                    endTime = System.currentTimeMillis();
                } finally {
                    rs.close();
                }
            } else {
                beginningTime = System.currentTimeMillis();
                stmt.executeUpdate(sql);
                endTime = System.currentTimeMillis();
            }
            if (log.isDebugEnabled()) {
                log.debug("beginning: " + beginningTime);
                log.debug("      end: " + endTime);
            }
            outputMessage("Time.once", (endTime - beginningTime) / 1000f);
        } finally {
            stmt.close();
        }
    }

    /**
     * SQL𕡐sB
     * @param conn RlNV
     * @param sql SQL
     * @param times s
     * @throws SQLException
     */
    private void tryManyTimes(Connection conn, String sql, int times) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("tryManyTimes");
        }
        final boolean isSelect = isSelect(sql);
        Statement stmt = prepareStatement(conn, sql);
        try {
            long total = 0;
            long maximum = 0;
            long minimun = Long.MAX_VALUE;
            for (int i = 0; i < times; i++) {
                final long beginningTime;
                final long endTime;
                if (log.isTraceEnabled()) {
                    log.trace("beginning: " + i);
                }
                if (isSelect) {
                    beginningTime = System.currentTimeMillis();
                    ResultSet rs = executeQuery(stmt, sql);
                    try {
                        endTime = System.currentTimeMillis();
                    } finally {
                        rs.close();
                    }
                } else {
                    beginningTime = System.currentTimeMillis();
                    stmt.executeUpdate(sql);
                    endTime = System.currentTimeMillis();
                }
                if (log.isTraceEnabled()) {
                    log.trace("      end: " + i);
                }
                final long result = endTime - beginningTime;
                total += result;
                maximum = Math.max(result, maximum);
                minimun = Math.min(result, minimun);
            }
            outputMessage("Time.summary",
                          total / 1000f,
                          total / 1000f / times,
                          maximum / 1000f,
                          minimun / 1000f);
        } finally {
            stmt.close();
        }
    }

}
