/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.io;

import java.io.*;
import java.math.*;
import java.util.*;

/**
 * x[X̃VACUB
 * f[^̒/𕶎ōsB
 */
public final class StringBasedSerializer {

    private StringBasedSerializer() {
        // empty
    }

    /**
     * IuWFNg𒼗񉻂B
     * @param object IuWFNg 
     * @return vf
     * @throws IOException
     */
    public static Element serialize(Object object) throws IOException {
        String name;
        String value;
        if (object == null) {
            name = Element.NULL;
            value = null;
        } else if (object instanceof String) {
            name = Element.STRING;
            value = (String)object;
        } else if (object instanceof Boolean) {
            name = Element.BOOLEAN;
            value = object.toString();
        } else if (object instanceof Byte) {
            name = Element.BYTE;
            value = object.toString();
        } else if (object instanceof Short) {
            name = Element.SHORT;
            value = object.toString();
        } else if (object instanceof Integer) {
            name = Element.INT;
            value = object.toString();
        } else if (object instanceof Long) {
            name = Element.LONG;
            value = object.toString();
        } else if (object instanceof Float) {
            name = Element.FLOAT;
            value = object.toString();
        } else if (object instanceof Double) {
            name = Element.DOUBLE;
            value = object.toString();
        } else if (object instanceof BigDecimal) {
            name = Element.DECIMAL;
            value = object.toString();
        } else if (object instanceof Date) {
            name = Element.TIME;
            Date date = (Date)object;
            value = Long.toString(date.getTime());
        } else {
            name = Element.OBJECT;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            try {
                oos.writeObject(object);
                value = toHexString(bos.toByteArray());
            } finally {
                oos.close();
            }
        }
        return new Element(name, value);
    }

    /**
     * 񉻂ꂽIuWFNg𕜌B
     * @param element vf
     * @return ꂽIuWFNg
     * @throws IOException
     */
    public static Object deserialize(Element element) throws IOException {
        return deserialize(element.getType(), element.getValue());
    }

    /**
     * 񉻂ꂽIuWFNg𕜌B
     * @param name vf
     * @param value l
     * @return ꂽIuWFNg
     * @throws IOException 
     */
    public static Object deserialize(String name, String value) throws IOException {
        Object o;
        if (name.equals(Element.NULL)) {
            o = null;
        } else if (name.equals(Element.STRING)) {
            o = value;
        } else if (name.equals(Element.BOOLEAN)) {
            o = Boolean.valueOf(value);
        } else if (name.equals(Element.BYTE)) {
            o = Byte.valueOf(value);
        } else if (name.equals(Element.SHORT)) {
            o = Short.valueOf(value);
        } else if (name.equals(Element.INT)) {
            o = Integer.valueOf(value);
        } else if (name.equals(Element.LONG)) {
            o = Long.valueOf(value);
        } else if (name.equals(Element.FLOAT)) {
            o = Float.valueOf(value);
        } else if (name.equals(Element.DOUBLE)) {
            o = Double.valueOf(value);
        } else if (name.equals(Element.DECIMAL)) {
            o = new BigDecimal(value);
        } else if (name.equals(Element.TIME)) {
            o = new Date(Long.parseLong(value));
        } else if (name.equals(Element.OBJECT)) {
            ByteArrayInputStream bis = new ByteArrayInputStream(toBytes(value));
            ObjectInputStream ois = new ObjectInputStream(bis);
            try {
                o = ois.readObject();
            } catch (ClassNotFoundException ex) {
                IOException ioe = new IOException(ex.getMessage());
                ioe.initCause(ex);
                throw ioe;
            } finally {
                ois.close();
            }
        } else {
            throw new IOException("unknown element : " + name);
        }
        return o;
    }

    /**
     * oCgz16iɕϊB
     * @param bytes oCgz
     * @return oCgz16i
     */
    private static String toHexString(byte[] bytes) {
        StringBuilder buffer = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            buffer.append(String.format("%02X", b & 0xFF));
        }
        return buffer.toString();
    }

    /**
     * 16ioCgzɕϊB
     * @param hexString 16i
     * @return oCgz
     */
    private static byte[] toBytes(String hexString) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int i = 0; i < hexString.length(); i += 2) {
            String s = hexString.substring(i, i + 2);
            bos.write(Integer.parseInt(s, 16));
        }
        return bos.toByteArray();
    }

    /**
     * vfB
     */
    public static final class Element {

        /**
         * <code>NULL</code>
         */
        public static final String NULL = "null";
        /**
         * <code>STRING</code>
         */
        public static final String STRING = "string";
        /**
         * <code>BOOLEAN</code>
         */
        public static final String BOOLEAN = "boolean";
        /**
         * <code>BYTE</code>
         */
        public static final String BYTE = "byte";
        /**
         * <code>SHORT</code>
         */
        public static final String SHORT = "short";
        /**
         * <code>INT</code>
         */
        public static final String INT = "int";
        /**
         * <code>LONG</code>
         */
        public static final String LONG = "long";
        /**
         * <code>FLOAT</code>
         */
        public static final String FLOAT = "float";
        /**
         * <code>DOUBLE</code>
         */
        public static final String DOUBLE = "double";
        /**
         * <code>DECIMAL</code>
         */
        public static final String DECIMAL = "decimal";
        /**
         * <code>TIME</code>
         */
        public static final String TIME = "time";
        /**
         * <code>OBJECT</code>
         */
        public static final String OBJECT = "object";

        private final String type;
        private final String value;

        /**
         * Element̐B
         * @param type
         * @param value
         */
        Element(String type, String value) {
            this.type = (type == null) ? NULL : type;
            this.value = value;
        }

        /**
         * vf^Cv̎擾B
         * @return vf^Cv
         */
        public String getType() {
            return type;
        }

        /**
         * value̎擾B
         * @return value
         */
        public String getValue() {
            return value;
        }

        /**
         * ̗vfNULLǂ𒲂ׂB
         * @return ̗vfNULLǂ
         */
        public boolean isNull() {
            return (type == NULL || value == null);
        }

        @Override
        public String toString() {
            return type + ":" + value;
        }

    }

}
