/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.logging;

import java.io.*;
import java.util.logging.*;
import java.util.logging.Logger;

/**
 * Logging API ̃bp[B
 * @see java.util.logging
 */
public final class LoggingApiWrapper extends BasicLogger {

    private final Logger logger;
    private final String targetClassName;

    /**
     * RXgN^B
     * @param targetClassName ΏۃNX
     */
    public LoggingApiWrapper(String targetClassName) {
        this.logger = Logger.getLogger(targetClassName);
        this.targetClassName = targetClassName;
    }

    @Override
    protected void printMessage(String levelString, Object object) {
        int lineNumber = getLineNumber(targetClassName);
        String lineNumberInfo = (lineNumber > 0) ? ":" + lineNumber : "";
        logger.log(Level.FINEST, String.format("(%s) [%s%s] %s",
                                               levelString,
                                               targetClassName,
                                               lineNumberInfo,
                                               object));
    }

    @Override
    protected void printStackTrace(Throwable th) {
        StringWriter buffer = new StringWriter();
        PrintWriter out = new PrintWriter(buffer);
        out.println();
        th.printStackTrace(out);
        logger.log(Level.FINEST, buffer.toString());
    }

}
