/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import net.argius.stew.ui.window.ActionUtility;
import net.argius.stew.ui.window.Resource;
import net.argius.stew.ui.window.ResultSetTableModel;
import net.argius.stew.ui.window.WindowOutputProcessor;

final class ResultSetTable
extends JTable {
    private static final TableCellRenderer nullRenderer = new NullValueRenderer();
    private ColumnHeaderCellRenderer columnHeaderRenderer;
    private RowHeader rowHeader;
    volatile KeyEvent lastKeyEvent;

    ResultSetTable() {
        JTableHeader jTableHeader = this.getTableHeader();
        TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
        final RowHeader rowHeader = new RowHeader(this);
        this.columnHeaderRenderer = new ColumnHeaderCellRenderer(tableCellRenderer);
        this.rowHeader = rowHeader;
        this.setColumnSelectionAllowed(true);
        this.setAutoResizeMode(0);
        jTableHeader.setDefaultRenderer(this.columnHeaderRenderer);
        jTableHeader.setReorderingAllowed(false);
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
            private int dragStartColumn;

            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    this.changeSelection(mouseEvent);
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    this.changeSelection(mouseEvent);
                }
            }

            private void changeSelection(MouseEvent mouseEvent) {
                boolean bl;
                Point point = mouseEvent.getPoint();
                int n = mouseEvent.getID();
                boolean bl2 = n == 501;
                boolean bl3 = bl = n == 506;
                if (bl2 || bl) {
                    int n2;
                    int n3;
                    int n4;
                    if (!mouseEvent.isControlDown() && !mouseEvent.isShiftDown()) {
                        ResultSetTable.this.clearSelection();
                    }
                    if ((n4 = ResultSetTable.this.columnAtPoint(point)) < 0 || ResultSetTable.this.getColumnCount() <= n4) {
                        return;
                    }
                    if (bl2) {
                        if (mouseEvent.isShiftDown()) {
                            n3 = this.dragStartColumn;
                            n2 = n4;
                        } else {
                            this.dragStartColumn = n4;
                            n3 = n4;
                            n2 = n4;
                        }
                    } else if (bl) {
                        n3 = this.dragStartColumn;
                        n2 = n4;
                    } else {
                        return;
                    }
                    ResultSetTable.this.selectColumn(n3, n2);
                    ResultSetTable.this.requestFocus();
                }
            }
        };
        jTableHeader.addMouseListener(mouseInputAdapter);
        jTableHeader.addMouseMotionListener(mouseInputAdapter);
        MouseInputAdapter mouseInputAdapter2 = new MouseInputAdapter(){
            private int dragStartRow;

            public void mousePressed(MouseEvent mouseEvent) {
                this.changeSelection(mouseEvent);
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                this.changeSelection(mouseEvent);
            }

            private void changeSelection(MouseEvent mouseEvent) {
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    boolean bl;
                    int n = mouseEvent.getID();
                    boolean bl2 = n == 501;
                    boolean bl3 = bl = n == 506;
                    if (bl2 || bl) {
                        int n2;
                        int n3;
                        int n4;
                        if (point.y >= rowHeader.getBounds().height) {
                            return;
                        }
                        if (!mouseEvent.isControlDown() && !mouseEvent.isShiftDown()) {
                            ResultSetTable.this.clearSelection();
                        }
                        if ((n4 = ResultSetTable.this.rowAtPoint(point)) < 0 || ResultSetTable.this.getRowCount() < n4) {
                            return;
                        }
                        if (bl2) {
                            if (mouseEvent.isShiftDown()) {
                                n3 = this.dragStartRow;
                                n2 = n4;
                            } else {
                                this.dragStartRow = n4;
                                n3 = n4;
                                n2 = n4;
                            }
                        } else if (bl) {
                            n3 = this.dragStartRow;
                            n2 = n4;
                        } else {
                            return;
                        }
                        ResultSetTable.this.addRowSelectionInterval(n3, n2);
                        ResultSetTable.this.addColumnSelectionInterval(ResultSetTable.this.getColumnCount() - 1, 0);
                        ResultSetTable.this.requestFocus();
                        JViewport jViewport = (JViewport)ResultSetTable.this.getParent();
                        Point point2 = jViewport.getViewPosition();
                        point2.y = ((JViewport)rowHeader.getParent()).getViewPosition().y;
                        jViewport.setViewPosition(point2);
                    }
                }
            }
        };
        rowHeader.addMouseListener(mouseInputAdapter2);
        rowHeader.addMouseMotionListener(mouseInputAdapter2);
        InputMap inputMap = this.getInputMap();
        int n = Resource.getMenuShortcutKeyMask();
        inputMap.put(KeyStroke.getKeyStroke(88, n), "cut");
        inputMap.put(KeyStroke.getKeyStroke(67, n), "copy");
        inputMap.put(KeyStroke.getKeyStroke(86, n), "paste");
        inputMap.put(KeyStroke.getKeyStroke(65, n), "selectAll");
        this.bindJumpTo("jump-to-home", 36, false);
        this.bindJumpTo("jump-to-end", 35, false);
        this.bindJumpTo("jump-to-top", 38, false);
        this.bindJumpTo("jump-to-bottom", 40, false);
        this.bindJumpTo("jump-to-leftmost", 37, false);
        this.bindJumpTo("jump-to-rightmost", 39, false);
        this.bindJumpTo("select-to-home", 36, true);
        this.bindJumpTo("select-to-end", 35, true);
        this.bindJumpTo("select-to-top", 38, true);
        this.bindJumpTo("select-to-bottom", 40, true);
        this.bindJumpTo("select-to-leftmost", 37, true);
        this.bindJumpTo("select-to-rightmost", 39, true);
        this.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
                ResultSetTable.this.lastKeyEvent = keyEvent;
            }

            public void keyReleased(KeyEvent keyEvent) {
                ResultSetTable.this.lastKeyEvent = keyEvent;
            }

            public void keyPressed(KeyEvent keyEvent) {
                ResultSetTable.this.lastKeyEvent = keyEvent;
            }
        });
        ActionUtility.getInstance(this).bindAction((Action)new AbstractAction("doNothing"){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        }, KeyStroke.getKeyStroke(27, 0));
    }

    public void editingStopped(ChangeEvent changeEvent) {
        try {
            super.editingStopped(changeEvent);
        }
        catch (Exception exception) {
            WindowOutputProcessor.showErrorDialog(this.getParent(), exception);
        }
    }

    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        boolean bl = super.editCellAt(n, n2, eventObject);
        if (bl && this.editorComp instanceof JTextField && this.lastKeyEvent != null && this.lastKeyEvent.getKeyCode() != 113) {
            JTextField jTextField = (JTextField)this.editorComp;
            this.initializeEditorComponent(jTextField);
            jTextField.requestFocus();
            jTextField.selectAll();
        }
        return bl;
    }

    public TableCellEditor getCellEditor() {
        TableCellEditor tableCellEditor = super.getCellEditor();
        if (tableCellEditor instanceof DefaultCellEditor) {
            DefaultCellEditor defaultCellEditor = (DefaultCellEditor)tableCellEditor;
            this.initializeEditorComponent(defaultCellEditor.getComponent());
        }
        return tableCellEditor;
    }

    private void initializeEditorComponent(Component component) {
        Color color = Color.ORANGE;
        if (component != null && component.getBackground() != color) {
            if (!component.isEnabled()) {
                component.setEnabled(true);
            }
            component.setFont(this.getFont());
            component.setBackground(color);
            if (component instanceof JTextComponent) {
                JTextComponent jTextComponent = (JTextComponent)component;
                ActionUtility.setUndoAction(jTextComponent);
                component.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent focusEvent) {
                        ResultSetTable.this.editingCanceled(new ChangeEvent(focusEvent.getSource()));
                    }
                });
            }
        }
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        Object object = this.getValueAt(n, n2);
        if (object == null) {
            return nullRenderer;
        }
        return super.getCellRenderer(n, n2);
    }

    public void updateUI() {
        super.updateUI();
        ResultSetTable.adjustRowHeight(this);
    }

    static void adjustRowHeight(JTable jTable) {
        JLabel jLabel = new JLabel("0");
        int n = ((Component)jLabel).getPreferredSize().height;
        if (n > 0) {
            jTable.setRowHeight(n);
        }
    }

    protected void configureEnclosingScrollPane() {
        Container container;
        super.configureEnclosingScrollPane();
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            jScrollPane.setRowHeaderView(this.rowHeader);
        }
    }

    public void setModel(TableModel tableModel) {
        tableModel.addTableModelListener(this.rowHeader);
        super.setModel(tableModel);
    }

    void selectColumn(int n, int n2) {
        if (this.getRowCount() > 0) {
            this.addColumnSelectionInterval(n, n2);
            this.addRowSelectionInterval(this.getRowCount() - 1, 0);
        }
    }

    RowHeader getRowHeader() {
        return this.rowHeader;
    }

    ResultSetTableModel getResultSetTableModel() {
        return (ResultSetTableModel)this.getModel();
    }

    boolean isShowColumnNumber() {
        return this.columnHeaderRenderer.showColumnNumber;
    }

    void setShowColumnNumber(boolean bl) {
        boolean bl2 = this.columnHeaderRenderer.showColumnNumber;
        this.columnHeaderRenderer.showColumnNumber = bl;
        this.firePropertyChange("showNumber", bl2, bl);
    }

    void repaintRowHeader(String string) {
        if (this.rowHeader != null) {
            this.rowHeader.propertyChange(new PropertyChangeEvent(this, string, null, null));
        }
    }

    private void bindJumpTo(String string, int n, boolean bl) {
        AbstractAction abstractAction;
        final boolean bl2 = bl;
        final CellCursor cellCursor = new CellCursor(this);
        int n2 = Resource.getMenuShortcutKeyMask();
        if (string.endsWith("-to-home")) {
            abstractAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ResultSetTable.this.changeSelection(0, 0, false, bl2);
                }
            };
        } else if (string.endsWith("-to-end")) {
            abstractAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ResultSetTable.this.getRowCount();
                    int n2 = ResultSetTable.this.getColumnCount();
                    ResultSetTable.this.changeSelection(n - 1, n2 - 1, false, bl2);
                }
            };
        } else if (string.endsWith("-to-top")) {
            abstractAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ResultSetTable.this.changeSelection(0, cellCursor.getColumnPosition(), false, bl2);
                }
            };
        } else if (string.endsWith("-to-bottom")) {
            abstractAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ResultSetTable.this.getRowCount();
                    ResultSetTable.this.changeSelection(n - 1, cellCursor.getColumnPosition(), false, bl2);
                }
            };
        } else if (string.endsWith("-to-leftmost")) {
            abstractAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ResultSetTable.this.changeSelection(cellCursor.getRowPosition(), 0, false, bl2);
                }
            };
        } else if (string.endsWith("-to-rightmost")) {
            abstractAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ResultSetTable.this.getColumnCount();
                    ResultSetTable.this.changeSelection(cellCursor.getRowPosition(), n - 1, false, bl2);
                }
            };
        } else {
            throw new AssertionError((Object)("unknown key: " + string));
        }
        this.getActionMap().put(string, abstractAction);
        this.getInputMap().put(KeyStroke.getKeyStroke(n, n2 | (bl ? 64 : 0)), string);
    }

    private static final class RowHeader
    extends JTable
    implements PropertyChangeListener {
        private static final int DEFAULT_WIDTH = 40;
        private DefaultTableModel model = new DefaultTableModel(0, 1){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        private TableCellRenderer renderer;

        RowHeader(JTable jTable) {
            final ResultSetTable resultSetTable = (ResultSetTable)jTable;
            this.renderer = new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    assert (resultSetTable.getModel() instanceof ResultSetTableModel);
                    boolean bl3 = resultSetTable.getResultSetTableModel().isLinkedRow(n);
                    JLabel jLabel = new JLabel(String.format("%s ", bl3 ? Integer.valueOf(n + 1) : "+"));
                    jLabel.setHorizontalAlignment(4);
                    jLabel.setFont(jTable.getFont());
                    jLabel.setOpaque(true);
                    return jLabel;
                }
            };
            this.setModel(this.model);
            this.setWidth(jTable);
            this.setFocusable(false);
            jTable.addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JTable jTable = (JTable)propertyChangeEvent.getSource();
            if (jTable == null) {
                return;
            }
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("enabled")) {
                boolean bl = jTable.isEnabled();
                this.setVisible(bl);
                if (bl) {
                    this.setWidth(jTable);
                    this.resetViewPosition(jTable);
                }
            } else if (string.equals("font")) {
                this.setFont(jTable.getFont());
            } else if (string.equals("rowHeight")) {
                this.setRowHeight(jTable.getRowHeight());
            } else if (string.equals("model")) {
                this.model.setRowCount(jTable.getRowCount());
            } else if (string.equals("unlinkedRowStatus")) {
                this.repaint();
            } else if (string.equals("ancestor")) {
                // empty if block
            }
            this.validate();
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            Object object = tableModelEvent.getSource();
            if (this.model != null && object != null) {
                this.model.setRowCount(((TableModel)object).getRowCount());
            }
            super.tableChanged(tableModelEvent);
        }

        public void updateUI() {
            super.updateUI();
            ResultSetTable.adjustRowHeight(this);
        }

        void setWidth(JTable jTable) {
            int n = jTable.getRowCount();
            this.model.setRowCount(n);
            JLabel jLabel = new JLabel(String.valueOf((long)n * 1000L));
            Dimension dimension = this.getSize();
            dimension.width = Math.max(jLabel.getPreferredSize().width, 40);
            this.setPreferredScrollableViewportSize(dimension);
        }

        private void resetViewPosition(JTable jTable) {
            Container container = jTable.getParent();
            Container container2 = this.getParent();
            if (container instanceof JViewport && container2 instanceof JViewport) {
                JViewport jViewport = (JViewport)container;
                JViewport jViewport2 = (JViewport)container2;
                jViewport2.setViewPosition(jViewport.getViewPosition());
            }
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            return this.renderer;
        }
    }

    private static final class ColumnHeaderCellRenderer
    implements TableCellRenderer {
        TableCellRenderer renderer;
        boolean showColumnNumber;

        ColumnHeaderCellRenderer(TableCellRenderer tableCellRenderer) {
            this.renderer = tableCellRenderer;
            this.showColumnNumber = false;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2 = this.showColumnNumber ? String.format("%d %s", n2 + 1, object) : object;
            return this.renderer.getTableCellRendererComponent(jTable, object2, bl, bl2, n, n2);
        }
    }

    private static final class NullValueRenderer
    extends DefaultTableCellRenderer {
        NullValueRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, "NULL", bl, bl2, n, n2);
            component.setForeground(new Color(63, 63, 192, 192));
            Font font = component.getFont();
            component.setFont(font.deriveFont((float)font.getSize() * 0.8f));
            return component;
        }
    }

    private static final class CellCursor {
        private JTable table;

        CellCursor(JTable jTable) {
            this.table = jTable;
        }

        int getColumnPosition() {
            int[] nArray = this.table.getSelectedColumns();
            if (nArray == null || nArray.length == 0) {
                return -1;
            }
            ListSelectionModel listSelectionModel = this.table.getColumnModel().getSelectionModel();
            return nArray[0] == listSelectionModel.getAnchorSelectionIndex() ? nArray[nArray.length - 1] : nArray[0];
        }

        int getRowPosition() {
            int[] nArray = this.table.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return -1;
            }
            ListSelectionModel listSelectionModel = this.table.getSelectionModel();
            return nArray[0] == listSelectionModel.getAnchorSelectionIndex() ? nArray[nArray.length - 1] : nArray[0];
        }
    }
}

