/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassFinder {
    private String rootPath;
    private ClassLoader classLoader;
    private boolean failMode;

    public ClassFinder(String string) {
        this.rootPath = ClassFinder.normalizePath(string);
        this.classLoader = ClassLoader.getSystemClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setFailMode(boolean bl) {
        this.failMode = bl;
    }

    public final void find(File file) {
        block10: {
            try {
                String string = file.getName();
                if (file.isDirectory()) {
                    File[] fileArray = file.listFiles();
                    for (int i = 0; i < fileArray.length; ++i) {
                        this.find(fileArray[i]);
                    }
                    break block10;
                }
                if (string.matches("(?i).+\\.class")) {
                    try {
                        this.filter(this.resolveClass(file.getCanonicalPath()));
                        break block10;
                    }
                    catch (Throwable throwable) {
                        if (this.failMode) {
                            this.fail(file, throwable);
                            break block10;
                        }
                        throw new RuntimeException(throwable);
                    }
                }
                if (string.matches("(?i).+\\.(jar|zip)")) {
                    this.find(new ZipFile(file));
                }
            }
            catch (IOException iOException) {
                if (this.failMode) {
                    this.fail(file, iOException);
                }
                throw new RuntimeException(iOException);
            }
        }
    }

    public final void find(ZipFile zipFile) {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string = zipEntry.getName();
            if (!string.matches("(?i).+\\.class")) continue;
            try {
                this.filter(this.resolveClass(string));
            }
            catch (Throwable throwable) {
                if (this.failMode) {
                    this.fail(string, throwable);
                    continue;
                }
                throw new RuntimeException(throwable);
            }
        }
    }

    public void filter(Class<?> clazz) {
    }

    public void fail(Object object, Throwable throwable) {
    }

    protected final Class<?> resolveClass(String string) throws Throwable {
        String string2 = ClassFinder.normalizePath(string);
        if (string2.startsWith(this.rootPath)) {
            string2 = string2.substring(this.rootPath.length() + 1);
        }
        string2 = string2.replaceFirst("\\.class$", "").replace('/', '.');
        return Class.forName(string2, false, this.classLoader);
    }

    private static String normalizePath(String string) {
        return string.replaceAll("\\\\", "/");
    }
}

