/*
 * ********************************************************************
 * SQLC Release 1.1.0
 * ********************************************************************
 */

import java.io.*;
import java.util.*;
import java.sql.*;

import clib.com.*;
import clib.bean.*;

/**
 * sqlc
 *
 * @version   Release 1.1.0
 * @since     JDK1.1
 * @author    dynaworks
 */
public class sqlc
{
    final static String LOGO = "SQLC Release Release 1.1.0";

    // *********************************
    // R}hCIvV
    // *********************************
    final static String OPTION_CONNECT_STR       = "CONN";
    final static String OPTION_DRIVER_STR        = "DRV";
    final static String OPTION_PROPERTIES_STR    = "PROP";

    final static String OPTION_USER_NAME_STR     = "USER";
    final static String OPTION_PASS_WORD_STR     = "PASS";
    final static String OPTION_URL_STR           = "URL";
    final static String OPTION_CONNECT_INFO_STR  = "CONN";

    /** WJDBC-DRIVER           */
    final static String DEFAULT_DRIVER_NAME  = "sun.jdbc.odbc.JdbcOdbcDriver";
    final static String DEFAULT_CONNECTION_STRING = "jdbc:odbc:LocalServer";
    final static String DEFAULT_OPTION_PROPERTIES_STR    = "sqlc.properties";

    static String comm_name     = null;
    static String conn_name     = "";
    static ConnBeanMan conn_man = ConnBeanMan.getInstance();
    static CommBeanMan comm_man = CommBeanMan.getInstance();

    static Properties  prop = new Properties();

    // hCo
    static DriverLoader drvman = new DriverLoader();

    static public void  main(String[] argv)
    {
        CommBean        comm = null;

        try
        {
            // ********************************************************
            // 
            // ********************************************************
            // ftHgbZbV\z
            comm_name = "";
            comm = new CommBean( comm_name, System.in, System.out );
            comm.startup();
            comm_man.putCtx(comm);
            comm.println( LOGO );

            // **********************************
            // R}hC
            // **********************************
            CommandLineOptions opts = new CommandLineOptions(argv,'-',':');

            // **********************************
            // vpeBt@C̓Ǎ
            // **********************************
            try
            {
                String prop_file_name = opts.getOptionString(OPTION_PROPERTIES_STR);
                if( prop_file_name == null || prop_file_name.length() <= 0 )
                {
                    prop_file_name = DEFAULT_OPTION_PROPERTIES_STR;
                }
                FileInputStream fis = new FileInputStream(new File(prop_file_name));
                prop.load(fis);
                fis.close();
//              prop.list(System.err);
                
            }
            catch(Exception e)
            {
//              comm.out().println( "ERR: Property File Load" );
//              e.printStackTrace();
            }
            // **********************************
            // DBڑ𓾂
            // **********************************
            // JDBChCo̐ݒ
            initializeJDBCDriver(opts,comm);
            // DBڑݒ
            conn_name = initializeConnection( opts, comm );

            // ********************************************************
            // R}h̎s
            // ********************************************************
            ExecuteCtx ctx = new ExecuteCtx(comm_name,conn_name);
            CommandSession cmnd = new CommandSession();
            cmnd.execute(ctx);
        }
        catch( Exception e )
        {
            System.out.println(e);
            e.printStackTrace();
        }
        // ************************************************************
        // ㏈
        // ************************************************************
        finally
        {
            conn_man.shutdown();
            comm.println( "Good Bye!!" );
        }
        return;
    }

    static void initializeJDBCDriver(CommandLineOptions opts,CommBean comm) throws ClassNotFoundException
    {
        String driver_name;
        StringTokenizer st;
        boolean         fLoad;
        // vpeBt@C̏
        fLoad = false;
        driver_name = prop.getProperty(OPTION_DRIVER_STR,"");
        for(st = new StringTokenizer(driver_name,",");st.hasMoreTokens();)
        {
            String drv_elem = st.nextToken();
            if( drv_elem != null && !(drv_elem.length() <= 0) )
            {
                drvman.add(drv_elem);
                fLoad = true;
            }
        }

        driver_name = opts.getOptionString(OPTION_DRIVER_STR);
        if( fLoad == false )
        {
            if( driver_name == null || driver_name.length() <= 0 ) 
            {
                try
                {
                    comm.print("JDBCDriver [" + DEFAULT_DRIVER_NAME + "]: ");
                    comm.flush();
                    driver_name = comm.readLine();
                    if( driver_name.length() <= 0 ) driver_name = DEFAULT_DRIVER_NAME;
                }
                catch(Exception e)
                {
                    e.printStackTrace();
                }
            }
        }

        if( driver_name != null && driver_name.length() > 0 )
        for(st = new StringTokenizer(driver_name,",");st.hasMoreTokens();)
        {
            String drv_elem = st.nextToken();
            if( drv_elem != null && !(drv_elem.length() <= 0) )
                drvman.add(drv_elem);
        }
        drvman.cload(comm);
    }

    static String initializeConnection(CommandLineOptions opts,CommBean comm) throws IOException, SQLException
    {
        ConnBean  conn = new ConnBean();
        String    user_name = "",pass_word = "",connect_info = "",url = "";
        // vpeBt@C̏
        {
            user_name = prop.getProperty(OPTION_USER_NAME_STR,"");
            pass_word = prop.getProperty(OPTION_PASS_WORD_STR,"");
            url = prop.getProperty(OPTION_URL_STR,"");
        }
        // ڑ
        connect_info = opts.getOptionString(OPTION_CONNECT_STR);

        if( !(connect_info == null || connect_info.length()<=0) )
        {
            conn = new ConnBean("",connect_info);
        }
        else
        {
            if( url == null || url.length()<=0 )
            {
                comm.print("ConnectionString [" + DEFAULT_CONNECTION_STRING + "]: ");
                comm.flush();
                url = comm.readLine();
                if( url.length() <= 0 ) url = DEFAULT_CONNECTION_STRING;
            }
            if( user_name == null || user_name.length()<=0 )
            {
                comm.print("UserName: ");
                comm.flush();
                user_name = comm.readLine();
            }
            if( pass_word == null || pass_word.length()<=0 )
            {
                comm.print("PassWord: ");
                comm.flush();
                pass_word = comm.readLine();
            }
            conn = new ConnBean(user_name+"@"+connect_info,url,user_name,pass_word);
        }

        // DBڑJn
        conn.startup(comm);
        conn_man.putCtx(conn);
        return conn.getName();
    }
}
