/*
 * ********************************************************************
 * SQLC Release 1.1.0
 * ********************************************************************
 */
package clib.com;

import java.io.*;
import java.util.*;

import clib.bean.*;

/**
 * DriverLoader
 *
 * @since     JDK1.1
 * @author    dynaworks
 */
public class DriverLoader
{
    /** ǍΏJDBC-DRIVERXg */
    private Vector drivers = null;
    /** ǍJDBC-DRIVERXg   */
    private Vector loaded_drivers = null;

    /**
     * \z
     */
    public DriverLoader()
    {
        drivers = new Vector();
        loaded_drivers = new Vector();
    }

    /**
     * ǍΏJDBC-DRIVER̒ǉ
     * @param driver_name JDBC-DRIVER
     */
    public void add(String driver_name)
    {
        if( !drivers.contains(driver_name) )
            drivers.addElement(driver_name);
    }

    /**
     * JDBC-DRIVER̓Ǎ
     * @param comm Comm
     */
    public void cload(CommBean comm) throws ClassNotFoundException
    {
        String driver_name;
        String err_driver_list = "";
        int loaded_cnt = 0;

        for(Enumeration i=drivers.elements();i.hasMoreElements();)
        {
            driver_name = (String)i.nextElement();
            if( !loaded_drivers.contains(driver_name) )
            {
                try
                {
                    Class.forName(driver_name);
                    comm.out().println( "Load JDBC-Driver \"" + driver_name + "\"" );
                    loaded_drivers.addElement(driver_name);
                    loaded_cnt++;
                }
                catch(ClassNotFoundException e)
                {
                    comm.out().println( "ERR: JDBC-Driver \"" + driver_name + "\" NotFound" );
                    err_driver_list = err_driver_list + driver_name + ",";
                }
            }
        }
        if( loaded_cnt == 0 && err_driver_list.length() > 0 )
        {
            throw new ClassNotFoundException(err_driver_list);
        }
    }
}
