/*
 * ********************************************************************
 * SQLC Release 1.1.0
 * ********************************************************************
 */
package clib.cmd;

import java.sql.*;
import java.text.*;

import clib.com.*;
import clib.bean.*;
import clib.cmd.base.*;

/**
 * SQL
 *
 * @since     JDK1.1
 * @author    dynaworks
 */
public class SQL extends CommandBase
{
    static DecimalFormat sqlprompt = new DecimalFormat("##0> ");

    /**
     * R}hs
     */
    public boolean execute(ExecuteCtx ctx)
    {
        ResultSet    rs      = null;
        String       command_line;
        ConnBean conn = ctx.conn();
        CommBean comm = ctx.comm();
        String sql = null;
        int    i,j;
        try
        {
            String   text;
            int      cols;
            int      res;
            sql = getCommandString();

            if( sql.indexOf(";") < 0 )
            {
                i = 1;
                while( true )
                {
                    i++;
                    StringBuffer buf = new StringBuffer(sqlprompt.format(i));
                    j = buf.length();
                    for(;j<6;j++) buf = buf.insert(0, ' ');
                    command_line = CommandRequest.readLine(comm,buf.toString());
                    if( command_line == null ) break;
                    if( command_line.length() <= 0 ) continue;
                    if(command_line.indexOf(";") >= 0) break;
                    sql = sql + " " + command_line;
                }
                sql = sql + " " + command_line;
            }
            if( sql.indexOf(";") >= 0 )
                sql = sql.substring(0,sql.indexOf(";"));

            conn.getStatement().clearWarnings();
            if( sql.toUpperCase().startsWith("SELECT") )
            {
                ResultSetMetaData rsmd = null;

                rs = conn.getStatement().executeQuery(sql);
                rsmd = rs.getMetaData();
                cols = rsmd.getColumnCount();
                for(i=1;i<=cols;i++)
                {
                    text = rsmd.getColumnName(i);
                    if( i != 1 ) ctx.comm().print(",");
                    if( text != null ) ctx.comm().print(text);
//                  if( text != null ) ctx.reco().print(text);
                }
                ctx.comm().println();

                res = 0;
                while( rs.next() )
                {
                    res = res + 1;
                    for(i=1;i<=cols;i++)
                    {
                        text = rs.getString(i);
                        if( i != 1 ) ctx.comm().print(",");
                        if( text != null ) ctx.comm().print(text);
                    }
                    ctx.comm().println();
                }
                ctx.comm().println( "select " + res + " rows." );
            }
            else
            {
                res = conn.getStatement().executeUpdate( sql );
                ctx.comm().println( "update " + res + " rows." );
            }
        }
        catch( SQLException e )
        {
            System.err.println(e);
        }
        finally
        {
            try
            {
                if( rs != null ) rs.close();  rs = null;
            }
            catch( Exception e )
            {
                System.out.println(e);
                e.printStackTrace();
            }
        }
        return true;
    }
}
