/*
 * ********************************************************************
 * SQLC Release 1.1.0
 * ********************************************************************
 */
package clib.cmd;

import java.io.*;

import clib.com.*;
import clib.bean.*;
import clib.cmd.base.*;

/**
 * ExecF
 *
 * @since     JDK1.1
 * @author    dynaworks
 */
public class ExecF extends CommandBase
{
    /**
     * R}hs
     */
    public boolean execute(ExecuteCtx ctx)
    {
        CommBean comm = new CommBean(ctx.comm());
        InputStream is = null;

        try
        {
            String  fname = "";
            String  command = "";
            command = getCommandString();
            if( command.startsWith("@") )
                fname = command.substring(1);
            else if( command.startsWith("@@") )
                fname = command.substring(2);

            String comm_name = ctx.getCommName() + "/" + fname;
            is = new FileInputStream(new File(fname));
            comm.setInputStream(is);
            comm.setName(comm_name);
            comm.setEcho(true);
            comm.startup();
            CommBeanMan.getInstance().putCtx(comm);
            ctx.pushComm(this);
            ctx.setCommName(comm_name);
            CommandSession cmnd = new CommandSession();
            cmnd.execute(ctx);
        }
        catch( Exception e )
        {
            System.err.println(e);
        }
        finally
        {
            ctx.popComm(this);
            CommBeanMan.getInstance().removeCtx(comm.getName());
            try {if( is != null ) is.close();} catch(IOException e){}
        }
        return true;
    }
}
