package clib.com;

import java.util.*;

/**
 * CommandLineOptions
 *
 * @since     JDK1.1
 * @author    dynaworks
 */
public class CommandLineOptions
{
    /** R}hC */
    private String[] argv;
    /** IvV */
    private Hashtable opth;
    private Vector    optv;
    /** XCb` */
    private char optCH;
    /** l؂蕶 */
    private char sepCH;

    /**
     * \z
     * @param argv  R}hC
     * @param optCH XCb`
     * @param sepCH l؂蕶
     */
    public CommandLineOptions(String[] argv,char optCH,char sepCH)
    {
        this.argv = argv;
        this.optCH = optCH;
        this.sepCH = sepCH;
        int  cap = (argv.length <= 0 ) ? 1:argv.length;
        
        opth = new Hashtable(cap);
        optv = new Vector(cap);
        parsCommandLineOptions();
    }

    /**
     * 
     */
    private void parsCommandLineOptions()
    {
        String option_name;
        String option_value;
        for(int i=0;i<argv.length;i++)
        {
            option_name = argv[i];
            option_value = "";
            if( option_name.charAt(0) == optCH )
            {
                option_name = option_name.substring(1);
                int idx = option_name.indexOf(sepCH);
                if( idx >= 0 )
                {
                    option_value = option_name.substring(idx+1);
                    option_name  = option_name.substring(0,idx);
                }
            }
            opth.put(option_name,option_value);
            optv.addElement(option_name);
        }
    }

    /**
     * R}hC擾
     * @param name p[^
     * @return     p[^̒l
     */
    public String getOptionString(String name)
    {
        return (String)opth.get(name);
    }

    /**
     * R}hC擾
     * @param idx p[^ԍ
     * @return     p[^̒l
     */
    public String getOptionString(int idx)
    {
        return (String)optv.elementAt(idx);
    }

}
