package clib.bean;

import java.io.*;
import java.util.*;

/**
 * bZbVǗ
 *
 * @since     JDK1.1
 * @author    dynaworks
 */
public class CommBeanMan
{
    private Hashtable    ctxs;
    private String       current_id;
    static private CommBeanMan   obj = new CommBeanMan();

    /*******************************************************************
     * \z
     ******************************************************************/
    private CommBeanMan()
    {
        ctxs = new Hashtable();
        current_id = null;
    }

    /*******************************************************************
     * 擾
     * @return   bZbVǗ
     ******************************************************************/
    static public CommBeanMan getInstance()
    {
        return obj;
    }

    /*******************************************************************
     * bZbV̐ݒ
     * @param name      ZbV
     * @param cin       ͏
     * @param cout      o͏
     ******************************************************************/
    public void openCtx(String name,InputStream cin, OutputStream cout, String encoding)
    {
        CommBean comm = new CommBean(name,cin,cout);
        comm.setInputEncode(encoding);
        comm.setOutputEncode(encoding);

        comm.startup();
        addCtx(comm);
        setCurrentId(comm.getName());
    }
    public void openCtx(String name,InputStream cin, OutputStream cout)
    {
        CommBean comm = new CommBean(name,cin,cout);

        comm.startup();
        addCtx(comm);
        setCurrentId(comm.getName());
    }

    public void setCurrentId(String current_id)
    {
        this.current_id = current_id;
    }

    public String getCurrentId()
    {
        return current_id;
    }

    public CommBean getCurrent()
    {
        return getCtx(current_id);
    }

    /*******************************************************************
     * bZbV̐ݒ
     * @param name      ZbV
     * @param cin       ͏
     * @param cout      o͏
     ******************************************************************/
    public void closeCtx(String name)
    {
        removeCtx(name);
    }

    /*******************************************************************
     * bZbV̐ݒ
     * @param   ctx   bZbV
     ******************************************************************/
    public void addCtx(CommBean ctx)
    {
        ctxs.put(ctx.getName(),ctx);
    }
    /*******************************************************************
     * bZbV̎擾
     * @param   name  bZbV
     * @return  bZbV
     ******************************************************************/
    public CommBean getCtx(String name)
    {
        return (CommBean)ctxs.get(name);
    }

    /*******************************************************************
     * bZbV̍폜
     * @param   name  bZbV
     * @return  bZbV
     ******************************************************************/
    public CommBean removeCtx(String name)
    {
        return (CommBean)ctxs.remove(name);
    }

    /*******************************************************************
     * SbZbV̍폜
     ******************************************************************/
    public void clearCtx()
    {
        ctxs.clear();
        return;
    }
}
