/*
 * Decompiled with CFR 0.152.
 */
package clib.bean;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class CommBean {
    protected String name;
    protected InputStream cin;
    protected OutputStream cout;
    protected OutputStream cerr;
    protected boolean echo = false;
    protected BufferedReader cbr;
    protected PrintWriter cpw;
    protected String in_enc;
    protected String out_enc;

    public CommBean() {
    }

    public CommBean(String name) {
        this();
        this.setName(name);
    }

    public CommBean(String name, InputStream cin, OutputStream cout, OutputStream cerr) {
        this(name);
        this.setInputStream(cin);
        this.setOutputStream(cout);
        this.setErrorOutputStream(cerr);
    }

    public CommBean(String name, InputStream cin, OutputStream cout) {
        this(name, cin, cout, null);
    }

    public void setInputEncode(String in_enc) {
        this.in_enc = in_enc;
    }

    public String getInputEncode() {
        return this.in_enc;
    }

    public void setOutputEncode(String out_enc) {
        this.out_enc = out_enc;
    }

    public String getOutputEncode() {
        return this.out_enc;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setInputStream(InputStream cin) {
        this.cin = cin;
    }

    public InputStream getInputStream() {
        return this.cin;
    }

    public void setOutputStream(OutputStream cout) {
        this.cout = cout;
    }

    public OutputStream getOutputStream() {
        return this.cout;
    }

    public void setErrorOutputStream(OutputStream cerr) {
        this.cerr = cerr;
    }

    public OutputStream getErrorOutputStream() {
        return this.cerr;
    }

    public BufferedReader in() {
        return this.cbr;
    }

    public PrintWriter out() {
        return this.cpw;
    }

    public void setEcho(boolean echo) {
        this.echo = echo;
    }

    public boolean getEcho() {
        return this.echo;
    }

    public String readLine() throws IOException {
        String retp = this.in().readLine();
        if (this.echo && retp != null) {
            this.println(retp);
        }
        return retp;
    }

    public void println() {
        this.out().println();
    }

    public void println(String value) {
        this.out().println(value);
    }

    public void print(String value) {
        this.out().print(value);
    }

    public void info(String value) {
        this.out().println("INF: " + value);
    }

    public void error(String value) {
        this.out().println("ERR: " + value);
    }

    public void flush() {
        this.out().flush();
    }

    public void startup() {
        try {
            if (this.cpw == null) {
                this.cpw = this.out_enc == null || this.out_enc.length() <= 0 ? new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.cout)), true) : new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.cout, this.out_enc)), true);
            }
            if (this.cbr == null) {
                this.cbr = this.in_enc == null || this.in_enc.length() <= 0 ? new BufferedReader(new InputStreamReader(this.cin)) : new BufferedReader(new InputStreamReader(this.cin, this.in_enc));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void shutdown() {
    }
}

