/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.fetch.impl.sk_jp;

import com.ozacc.mail.fetch.impl.sk_jp.MultipartUtility;
import com.ozacc.mail.fetch.impl.sk_jp.PartHandler;
import java.io.IOException;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;

public class PlainPartExtractor
implements PartHandler {
    private String text = null;

    public boolean processPart(Part part, ContentType context) throws MessagingException, IOException {
        if (!part.isMimeType("text/plain")) {
            return true;
        }
        if (this.text == null) {
            this.text = (String)MultipartUtility.getContent(part);
        } else {
            String disposition = part.getDisposition();
            if (disposition == null || disposition.equalsIgnoreCase("inline")) {
                this.text = String.valueOf(this.text) + "\r\n\r\n-- inline --\r\n\r\n" + (String)MultipartUtility.getContent(part);
            }
        }
        return true;
    }

    public String getText() {
        return this.text;
    }

    public static void main(String[] args) throws Exception {
        MimeMessage msg = new MimeMessage(Session.getDefaultInstance((Properties)System.getProperties(), null), System.in);
        PlainPartExtractor h = new PlainPartExtractor();
        MultipartUtility.process((Part)msg, h);
        System.out.println("This is the detected text/plain parts.");
        System.out.println(h.getText());
    }
}

