<?php
/**
 * A simple description for this script
 *
 * PHP Version 5.2.4 or Upper version
 *
 * @package    Hangul Parser
 * @author     Hidehito NOZAWA aka Suin <xoops.suinyeze.com>
 * @copyright  2008 Hidehito NOZAWA
 * @license    http://www.gnu.org/licenses/gpl-2.0.html GNU GPL v2.0
 *
 */

class HangulRealConvertTable
{
	static public function getInitialTable()
	{
		return array(
			'ㄱ', 'ㄲ', 'ㄴ', 'ㄷ', 'ㄸ',
			'ㄹ', 'ㅁ', 'ㅂ', 'ㅃ', 'ㅅ',
			'ㅆ', 'ㅇ', 'ㅈ', 'ㅉ', 'ㅊ',
			'ㅋ', 'ㅌ', 'ㅍ', 'ㅎ',
		);
	}

	static public function getMiddleTable()
	{
		return array(
			'ㅏ', 'ㅐ', 'ㅑ',
			'ㅒ', 'ㅓ', 'ㅔ',
			'ㅕ', 'ㅖ', 'ㅗ',
			'ㅘ', 'ㅚ', 'ㅙ',
			'ㅛ', 'ㅜ', 'ㅝ',
			'ㅞ', 'ㅟ', 'ㅠ',
			'ㅡ', 'ㅢ', 'ㅣ',
		);
	}

	static public function getFinalTalbe()
	{
		$table = array(
			null,    'ㄱ',    'ㄲ',    'ㄱ.ㅅ',
			'ㄴ',    'ㄴ.ㅈ', 'ㄴ.ㅎ', 'ㄷ',
			'ㄹ',    'ㄹ.ㄱ', 'ㄹ.ㅁ', 'ㄹ.ㅂ',
			'ㄹ.ㅅ', 'ㄹ.ㅌ', 'ㄹ.ㅍ', 'ㄹ.ㅎ',
			'ㅁ',    'ㅂ',    'ㅂ.ㅅ', 'ㅅ',
			'ㅆ',    'ㅇ',    'ㅈ',    'ㅊ',
			'ㅋ',    'ㅌ',    'ㅍ',    'ㅎ',
		);

		foreach ( $table as $k => $v )
		{
			$table[$k] = explode('.', $v);
		}

		return $table;
	}
}

?>
