/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.sql;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import jdbcacsess.JdbcacsessException;
import jdbcacsess.gui.JDialogPrepareParameter;
import jdbcacsess.gui.JFrameMain;
import jdbcacsess.sql.ColumnInfoResult;
import jdbcacsess.sql.ExecuteSqCallable;
import jdbcacsess.sql.ExecuteSqResultSetOnly;
import jdbcacsess.sql.ExecuteSqStatement;
import jdbcacsess.sql.PrepareExecute;
import jdbcacsess.sql.QueryExecuteListener;
import jdbcacsess.sql.QueryExecuteStatus;
import jdbcacsess.sql.SqlAnalyze;
import jdbcacsess.sql.SqlMappingInfo;
import jdbcacsess.sql.SqlStatementCatgoly;
import jdbcacsess.sql.column.GetColumnResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ExecuteSqlFactory {
    private int cnt;
    private ArrayList<QueryExecuteListener> listeners;
    private Object source;
    ArrayList<ColumnInfoResult> selectColmunInfos;
    private SqlMappingInfo sqlMappingInfo;
    private boolean binaryDatalimit;

    static ExecuteSqlFactory getFactory(Object source, SqlAnalyze sqlAnalyze, Connection connection) {
        if (sqlAnalyze.getSqlStatementCatgoly() == SqlStatementCatgoly.SELECT) {
            return new ExecuteSqStatement(source, sqlAnalyze, connection);
        }
        if (sqlAnalyze.getSqlStatementCatgoly() == SqlStatementCatgoly.CALL) {
            return new ExecuteSqCallable(source, sqlAnalyze, connection);
        }
        return null;
    }

    static ExecuteSqlFactory getFactory(Object source, ResultSet rs) {
        return new ExecuteSqResultSetOnly(source, rs);
    }

    ExecuteSqlFactory(Object source) {
        this.source = source;
        this.binaryDatalimit = false;
        this.listeners = new ArrayList();
        this.sqlMappingInfo = new SqlMappingInfo();
    }

    void addQueryExecuteListener(QueryExecuteListener listener) {
        this.listeners.add(listener);
    }

    SqlMappingInfo getSqlMappingInfo() {
        return this.sqlMappingInfo;
    }

    abstract SqlAnalyze getSqlAnalyze();

    int getCnt() {
        return this.cnt;
    }

    boolean isBinaryDatalimit() {
        return this.binaryDatalimit;
    }

    void setBinaryDatalimit(boolean binaryDatalimit) {
        this.binaryDatalimit = binaryDatalimit;
    }

    boolean notifyOfInitAndResultHeader() throws Exception {
        SqlAnalyze sqlAnalyze = this.getSqlAnalyze();
        this.selectColmunInfos = new ArrayList();
        boolean rtn = this.initMethod();
        if (!rtn) {
            return rtn;
        }
        boolean selectUpdatable = false;
        if (sqlAnalyze != null) {
            selectUpdatable = sqlAnalyze.isSelectUpdatable(this.selectColmunInfos);
        }
        for (QueryExecuteListener listener : this.listeners) {
            listener.init();
        }
        for (QueryExecuteListener listener : this.listeners) {
            listener.setResultHeader(this.selectColmunInfos, sqlAnalyze, selectUpdatable);
        }
        return rtn;
    }

    abstract boolean initMethod() throws SQLException, Exception;

    boolean notifyOfResultDetail() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SQLException, IOException {
        if (!this.hasNext()) {
            return false;
        }
        ArrayList<Object> rowData = this.getResultDetail();
        ++this.cnt;
        for (QueryExecuteListener listener : this.listeners) {
            listener.setResultDetail(rowData);
        }
        return true;
    }

    abstract boolean hasNext() throws SQLException;

    abstract ArrayList<Object> getResultDetail() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SQLException, IOException;

    void notifyOfStatus(boolean runner, boolean err) {
        QueryExecuteStatus qes = new QueryExecuteStatus(this.source, this.cnt, runner, err);
        for (QueryExecuteListener listener : this.listeners) {
            listener.status(qes);
        }
    }

    void notifyOfErrorException(Exception e) {
        e.printStackTrace();
        for (QueryExecuteListener listener : this.listeners) {
            listener.errorException(e);
        }
    }

    void notifyOfCompleteQuery(boolean endOfData, boolean err) {
        this.endMethod();
        QueryExecuteStatus qes = new QueryExecuteStatus(this.source, this.cnt, endOfData, err);
        for (QueryExecuteListener listener : this.listeners) {
            listener.completeQuery(qes);
        }
    }

    abstract void endMethod();

    boolean solveParameter(PrepareExecute prepareExecute) throws JdbcacsessException {
        JDialogPrepareParameter jdpp;
        return !prepareExecute.isHavingInputParameter() || (jdpp = new JDialogPrepareParameter(prepareExecute)).isExecuteAns();
    }

    void getHeaderFromResultSet(ResultSet resultSet, ArrayList<ColumnInfoResult> header) throws Exception {
        int col = resultSet.getMetaData().getColumnCount();
        ResultSetMetaData rsm = resultSet.getMetaData();
        int i = 1;
        while (i <= col) {
            ColumnInfoResult colInfo = new ColumnInfoResult(i, rsm.getColumnName(i), rsm.getColumnType(i), rsm.getColumnTypeName(i), rsm.isNullable(i), rsm.getColumnClassName(i), rsm.getPrecision(i), rsm.getScale(i));
            this.getSqlMappingInfo().search(colInfo, this.binaryDatalimit);
            header.add(colInfo);
            ++i;
        }
    }

    void getDetailFromResultSet(ResultSet resultSet, ArrayList<Object> rowData) throws SQLException {
        int i = 1;
        while (i <= resultSet.getMetaData().getColumnCount()) {
            if (JFrameMain.debugMode && this.getCnt() == 0) {
                JFrameMain.getInstanceJPanelResultSetMetaData().setData(resultSet);
            }
            try {
                if (resultSet.getMetaData().getColumnType(i) == 2005 || this.selectColmunInfos.get(i - 1).getColumnClass() == Reader.class) {
                    Clob clob = resultSet.getClob(i);
                    if (!this.isAddNull(resultSet, rowData, clob)) {
                        rowData.add(clob.getSubString(1L, (int)clob.length()));
                    }
                } else {
                    GetColumnResultSet gcrs = this.selectColmunInfos.get((int)(i - 1)).getColumnResultSet;
                    if (gcrs != null) {
                        rowData.add(gcrs.getData(resultSet, i));
                    } else {
                        Object obj;
                        Method method = this.selectColmunInfos.get((int)(i - 1)).methodOfResultSet;
                        if (method != null) {
                            obj = method.invoke((Object)resultSet, i);
                            if (!this.isAddNull(resultSet, rowData, obj)) {
                                rowData.add(obj);
                            }
                        } else {
                            obj = resultSet.getObject(i);
                            if (!this.isAddNull(resultSet, rowData, obj)) {
                                rowData.add(obj);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                rowData.add(new JdbcacsessException(e));
            }
            ++i;
        }
    }

    private boolean isAddNull(ResultSet resultSet, ArrayList<Object> rowData, Object data) throws SQLException {
        if (resultSet.wasNull() || data == null) {
            rowData.add(null);
            return true;
        }
        return false;
    }
}

