/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables.details;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.debug.internal.ui.views.variables.details.DetailMessages;
import org.eclipse.debug.internal.ui.views.variables.details.DetailPaneManager;
import org.eclipse.debug.internal.ui.views.variables.details.IDetailPaneContainer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;

public class AvailableDetailPanesAction
extends Action
implements IMenuCreator {
    private Menu fMenu;
    private Set fAvailableIDs;
    private IDetailPaneContainer fDetailPaneContainer;

    public AvailableDetailPanesAction(IDetailPaneContainer detailPaneContainer) {
        this.fDetailPaneContainer = detailPaneContainer;
        this.setText(DetailMessages.AvailableDetailPanesAction_0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.variables_select_detail_pane_action_context");
        this.setEnabled(false);
        this.setMenuCreator(this);
        this.init();
    }

    public void run() {
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fAvailableIDs.clear();
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    protected void addActionToMenu(Menu parent, IAction action) {
        ActionContributionItem item = new ActionContributionItem(action);
        item.fill(parent, -1);
    }

    public Menu getMenu(Menu parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        Iterator iter = this.fAvailableIDs.iterator();
        int i = 0;
        while (iter.hasNext()) {
            String typeName;
            String currentID = (String)iter.next();
            StringBuffer name = new StringBuffer();
            if (++i < 9) {
                name.append('&');
                name.append(i);
                name.append(' ');
            }
            if ((typeName = DetailPaneManager.getDefault().getNameFromID(currentID)) != null && typeName.length() > 0) {
                name.append(typeName);
            } else {
                name.append(currentID);
            }
            SetDetailPaneAction action = new SetDetailPaneAction(name.toString(), currentID, this.fAvailableIDs);
            if (currentID.equals(this.fDetailPaneContainer.getCurrentPaneID())) {
                action.setChecked(true);
            }
            this.addActionToMenu(this.fMenu, (IAction)action);
        }
        return this.fMenu;
    }

    public void init() {
        this.fAvailableIDs = DetailPaneManager.getDefault().getAvailablePaneIDs(this.fDetailPaneContainer.getCurrentSelection());
        if (this.fAvailableIDs.size() > 1) {
            this.setEnabled(true);
        }
    }

    private class SetDetailPaneAction
    extends Action {
        private String fPaneID;
        private Set fPossiblePaneIDs;

        public SetDetailPaneAction(String name, String paneID, Set possiblePaneIDs) {
            super(name, 8);
            this.fPaneID = paneID;
            this.fPossiblePaneIDs = possiblePaneIDs;
        }

        public void run() {
            if (this.isChecked() && !AvailableDetailPanesAction.this.fDetailPaneContainer.getCurrentPaneID().equals(this.fPaneID)) {
                DetailPaneManager.getDefault().setPreferredDetailPane(this.fPossiblePaneIDs, this.fPaneID);
                AvailableDetailPanesAction.this.fDetailPaneContainer.refreshDetailPaneContents();
            }
        }
    }
}

