/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import com.ibm.icu.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.api.tools.internal.builder.ReferenceExtractor;
import org.eclipse.pde.api.tools.internal.model.AbstractApiTypeRoot;
import org.eclipse.pde.api.tools.internal.model.ApiField;
import org.eclipse.pde.api.tools.internal.model.ApiMember;
import org.eclipse.pde.api.tools.internal.model.ApiMethod;
import org.eclipse.pde.api.tools.internal.model.Messages;
import org.eclipse.pde.api.tools.internal.model.MethodKey;
import org.eclipse.pde.api.tools.internal.model.TypeStructureBuilder;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiField;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMethod;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.eclipse.pde.api.tools.internal.util.Signatures;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class ApiType
extends ApiMember
implements IApiType {
    private String fSuperclassName;
    private String[] fSuperInterfaceNames;
    private String fEnclosingTypeName;
    private String fSimpleName;
    private static final IApiMethod[] EMPTY_METHODS = new IApiMethod[0];
    private static final IApiField[] EMPTY_FIELDS = new IApiField[0];
    private static final IApiType[] EMPTY_TYPES = new IApiType[0];
    private static final String NO_ENCLOSING_METHOD = "";
    private Map fFields;
    private LinkedHashMap fMethods;
    private Map fMemberTypes;
    private IReferenceTypeDescriptor fHandle;
    private IApiType fSuperclass;
    private IApiType[] fSuperInterfaces;
    private IApiTypeRoot fStorage;
    private String fEnclosingMethodSignature = null;
    private String fEnclosingMethodName = null;
    private boolean fAnonymous = false;
    private boolean fLocal = false;
    private boolean fMemberType = false;
    private IApiType fEnclosingType = null;
    private IApiMethod fEnclosingMethod = null;

    public ApiType(IApiElement parent, String name, String signature, String genericSig, int flags, String enclosingName, IApiTypeRoot storage) {
        super(parent, name, signature, genericSig, 2, flags);
        this.fEnclosingTypeName = enclosingName;
        this.fStorage = storage;
    }

    public List extractReferences(int referenceMask, IProgressMonitor monitor) throws CoreException {
        HashSet references = new HashSet();
        ReferenceExtractor extractor = new ReferenceExtractor(this, references, referenceMask);
        ClassReader reader = new ClassReader(((AbstractApiTypeRoot)this.fStorage).getContents());
        reader.accept((ClassVisitor)extractor, 4);
        return new LinkedList(references);
    }

    public IApiField getField(String name) {
        if (this.fFields != null) {
            return (IApiField)this.fFields.get(name);
        }
        return null;
    }

    public IApiField[] getFields() {
        if (this.fFields != null) {
            return this.fFields.values().toArray(new IApiField[this.fFields.size()]);
        }
        return EMPTY_FIELDS;
    }

    public String getPackageName() {
        return this.getName().substring(0, this.getName().lastIndexOf(46));
    }

    public ApiMethod addMethod(String name, String signature, String genericSig, int modifiers, String[] exceptions) {
        if (this.fMethods == null) {
            this.fMethods = new LinkedHashMap();
        }
        ApiMethod method = new ApiMethod(this, name, signature, genericSig, modifiers, exceptions);
        this.fMethods.put(new MethodKey(this.getName(), name, signature, true), method);
        return method;
    }

    public ApiField addField(String name, String signature, String genericSig, int modifiers, Object value) {
        if (this.fFields == null) {
            this.fFields = new HashMap();
        }
        ApiField field = new ApiField(this, name, signature, genericSig, modifiers, value);
        this.fFields.put(name, field);
        return field;
    }

    public IApiMethod getMethod(String name, String signature) {
        if (this.fMethods != null) {
            return (IApiMethod)this.fMethods.get(new MethodKey(this.getName(), name, signature, true));
        }
        return null;
    }

    public IApiMethod[] getMethods() {
        if (this.fMethods != null) {
            return this.fMethods.values().toArray(new IApiMethod[this.fMethods.size()]);
        }
        return EMPTY_METHODS;
    }

    public String[] getSuperInterfaceNames() {
        return this.fSuperInterfaceNames;
    }

    public void setSuperInterfaceNames(String[] names) {
        this.fSuperInterfaceNames = names;
    }

    public IApiType[] getSuperInterfaces() throws CoreException {
        String[] names = this.getSuperInterfaceNames();
        if (names == null) {
            return EMPTY_TYPES;
        }
        if (this.fSuperInterfaces == null) {
            IApiType[] interfaces = new IApiType[names.length];
            int i = 0;
            while (i < interfaces.length) {
                interfaces[i] = this.resolveType(names[i]);
                if (interfaces[i] == null) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", 122, MessageFormat.format((String)Messages.ApiType_0, (Object[])new String[]{names[i], this.getName()}), null));
                }
                ++i;
            }
            this.fSuperInterfaces = interfaces;
        }
        return this.fSuperInterfaces;
    }

    public IApiType getSuperclass() throws CoreException {
        String name = this.getSuperclassName();
        if (name == null) {
            return null;
        }
        if (this.fSuperclass == null) {
            this.fSuperclass = this.resolveType(name);
            if (this.fSuperclass == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", 122, MessageFormat.format((String)Messages.ApiType_1, (Object[])new String[]{name, this.getName()}), null));
            }
        }
        return this.fSuperclass;
    }

    private IApiType resolveType(String qName) throws CoreException {
        if (this.getApiComponent() == null) {
            this.requiresApiComponent();
        }
        String packageName = Signatures.getPackageName(qName);
        IApiComponent[] components = this.getApiComponent().getBaseline().resolvePackage(this.getApiComponent(), packageName);
        IApiTypeRoot result = Util.getClassFile(components, qName);
        if (result != null) {
            return result.getStructure();
        }
        return null;
    }

    private void requiresApiComponent() throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", Messages.ApiType_2));
    }

    public String getSuperclassName() {
        return this.fSuperclassName;
    }

    public void setSuperclassName(String superName) {
        this.fSuperclassName = superName;
    }

    public void setSimpleName(String simpleName) {
        this.fSimpleName = simpleName;
    }

    public boolean isAnnotation() {
        return (this.getModifiers() & 0x2000) != 0;
    }

    public boolean isAnonymous() {
        return this.fAnonymous;
    }

    public boolean isLocal() {
        return this.fLocal;
    }

    public IApiTypeRoot getTypeRoot() {
        return this.fStorage;
    }

    public void setAnonymous() {
        this.fAnonymous = true;
    }

    public void setMemberType() {
        this.fMemberType = true;
    }

    public void setLocal() {
        this.fLocal = true;
    }

    public void setEnclosingMethodInfo(String name, String signature) {
        this.fEnclosingMethodName = name != null ? name : NO_ENCLOSING_METHOD;
        this.fEnclosingMethodSignature = signature != null ? signature : NO_ENCLOSING_METHOD;
    }

    public IApiMethod getEnclosingMethod() {
        if (this.fEnclosingMethod == null) {
            try {
                IApiType enclosingType = this.getEnclosingType();
                if (this.fEnclosingMethodName != null) {
                    if (this.fEnclosingMethodName != NO_ENCLOSING_METHOD) {
                        this.fEnclosingMethod = enclosingType.getMethod(this.fEnclosingMethodName, this.fEnclosingMethodSignature);
                    }
                } else {
                    TypeStructureBuilder.setEnclosingMethod(enclosingType, this);
                    if (this.fEnclosingMethodName != null) {
                        this.fEnclosingMethod = enclosingType.getMethod(this.fEnclosingMethodName, this.fEnclosingMethodSignature);
                    } else {
                        this.fEnclosingMethodName = NO_ENCLOSING_METHOD;
                    }
                }
            }
            catch (CoreException coreException) {}
        }
        return this.fEnclosingMethod;
    }

    public boolean isClass() {
        return (this.getModifiers() & 0x6200) == 0;
    }

    public boolean isEnum() {
        return (this.getModifiers() & 0x4000) != 0;
    }

    public boolean isInterface() {
        return (this.getModifiers() & 0x200) != 0;
    }

    public boolean isMemberType() {
        return this.fMemberType;
    }

    public IMemberDescriptor getHandle() {
        if (this.fHandle == null) {
            this.fHandle = Util.getType(this.getName());
        }
        return this.fHandle;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IApiType) {
            IApiType type = (IApiType)obj;
            if (this.getApiComponent() == null) {
                return type.getApiComponent() == null && this.getName().equals(type.getName());
            }
            return this.getApiComponent().equals(type.getApiComponent()) && this.getName().equals(type.getName());
        }
        return false;
    }

    public int hashCode() {
        IApiComponent component = this.getApiComponent();
        if (component == null) {
            return this.getName().hashCode();
        }
        return component.hashCode() + this.getName().hashCode();
    }

    public void addMemberType(String name, int modifiers) {
        if (this.fMemberTypes == null) {
            this.fMemberTypes = new HashMap();
        }
        int index = name.lastIndexOf(36);
        String simpleName = name.substring(index + 1);
        this.fMemberTypes.put(simpleName, null);
    }

    public IApiType getMemberType(String simpleName) throws CoreException {
        if (this.fMemberTypes == null) {
            return null;
        }
        if (this.getApiComponent() == null) {
            this.requiresApiComponent();
        }
        if (this.fMemberTypes.containsKey(simpleName)) {
            IApiTypeRoot file = (IApiTypeRoot)this.fMemberTypes.get(simpleName);
            if (file == null) {
                StringBuffer qName = new StringBuffer();
                qName.append(this.getName());
                qName.append('$');
                qName.append(simpleName);
                file = this.getApiComponent().findTypeRoot(qName.toString());
                if (file == null) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", MessageFormat.format((String)Messages.ApiType_3, (Object[])new String[]{simpleName, this.getName()})));
                }
                this.fMemberTypes.put(simpleName, file);
            }
            return file.getStructure();
        }
        return null;
    }

    public IApiType[] getMemberTypes() throws CoreException {
        if (this.fMemberTypes == null) {
            return EMPTY_TYPES;
        }
        IApiType[] members = new IApiType[this.fMemberTypes.size()];
        Iterator iterator = this.fMemberTypes.keySet().iterator();
        int index = 0;
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            members[index] = this.getMemberType(name);
            ++index;
        }
        return members;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Type : access(").append(this.getModifiers()).append(") ").append(this.getName());
        if (this.getSuperclassName() != null) {
            buffer.append(" superclass: ").append(this.getSuperclassName());
        }
        if (this.getSuperInterfaceNames() != null) {
            buffer.append(" interfaces : ");
            if (this.getSuperInterfaceNames().length > 0) {
                int i = 0;
                while (i < this.getSuperInterfaceNames().length) {
                    if (i > 0) {
                        buffer.append(',');
                    }
                    buffer.append(this.getSuperInterfaceNames()[i]);
                    ++i;
                }
            } else {
                buffer.append("none");
            }
        }
        buffer.append(';').append(Util.LINE_DELIMITER);
        if (this.getGenericSignature() != null) {
            buffer.append(" Signature : ").append(this.getGenericSignature()).append(Util.LINE_DELIMITER);
        }
        buffer.append(Util.LINE_DELIMITER).append("Methods : ").append(Util.LINE_DELIMITER);
        IApiMethod[] methods = this.getMethods();
        int i = 0;
        while (i < methods.length) {
            buffer.append(methods[i]);
            ++i;
        }
        buffer.append(Util.LINE_DELIMITER).append("Fields : ").append(Util.LINE_DELIMITER);
        IApiField[] fields = this.getFields();
        int i2 = 0;
        while (i2 < fields.length) {
            buffer.append(fields[i2]);
            ++i2;
        }
        return String.valueOf(buffer);
    }

    public String getSimpleName() {
        if (this.isAnonymous()) {
            return null;
        }
        if (this.isLocal() || this.isMemberType()) {
            return this.fSimpleName;
        }
        String name = this.getName();
        int index = name.lastIndexOf(46);
        if (index != -1) {
            return name.substring(index + 1);
        }
        return name;
    }

    public IApiType getEnclosingType() throws CoreException {
        IApiTypeRoot root;
        if (this.fEnclosingType != null) {
            return this.fEnclosingType;
        }
        if (this.fEnclosingTypeName != null && (root = this.getApiComponent().findTypeRoot(this.processEnclosingTypeName())) != null) {
            this.fEnclosingType = root.getStructure();
        }
        return this.fEnclosingType;
    }

    private String processEnclosingTypeName() {
        int idx;
        if ((this.isLocal() || this.isAnonymous()) && Character.isDigit(this.fEnclosingTypeName.charAt((idx = this.fEnclosingTypeName.lastIndexOf(36)) + 1))) {
            return this.fEnclosingTypeName.substring(0, idx);
        }
        return this.fEnclosingTypeName;
    }
}

