/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.net;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class CommonsNetPlugin
extends Plugin {
    public static final String ID_PLUGIN = "org.eclipse.mylyn.commons.net";
    private static CommonsNetPlugin INSTANCE;
    private static final int MAX_CONCURRENT_REQUESTS = 100;
    private static IProxyService proxyService;
    private static ExecutorService service;
    private ServiceTracker tracker;

    public static CommonsNetPlugin getDefault() {
        return INSTANCE;
    }

    public static synchronized ExecutorService getExecutorService() {
        if (service == null) {
            service = new ThreadPoolExecutor(1, 100, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        }
        return service;
    }

    public static synchronized IProxyService getProxyService() {
        if (proxyService == null && INSTANCE != null && CommonsNetPlugin.INSTANCE.tracker != null) {
            return (IProxyService)CommonsNetPlugin.INSTANCE.tracker.getService();
        }
        return proxyService;
    }

    public static void log(int error, String message, Throwable e) {
        if (CommonsNetPlugin.getDefault() != null) {
            CommonsNetPlugin.getDefault().getLog().log((IStatus)new Status(4, ID_PLUGIN, error, message, e));
        }
    }

    public static synchronized void setProxyService(IProxyService proxyService) {
        CommonsNetPlugin.proxyService = proxyService;
    }

    public CommonsNetPlugin() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.tracker = new ServiceTracker(this.getBundle().getBundleContext(), IProxyService.class.getName(), null);
        this.tracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.tracker.close();
        this.tracker = null;
        if (service != null) {
            service.shutdown();
            service = null;
        }
        super.stop(context);
    }
}

