/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.provisional.commons.ui.DatePicker;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.internal.tasks.ui.ScheduleTaskMenuContributor;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class ScheduleDatePicker
extends Composite {
    private Text scheduledDateText;
    private Button pickButton;
    private final List<SelectionListener> pickerListeners = new LinkedList<SelectionListener>();
    private final String initialText = DatePicker.LABEL_CHOOSE;
    private final List<IRepositoryElement> tasks;
    private final ScheduleTaskMenuContributor contributor;
    private DateRange scheduledDate;
    private final boolean isFloating = false;
    private ImageHyperlink clearControl;

    public ScheduleDatePicker(Composite parent, AbstractTask task, int style) {
        super(parent, style);
        if (task != null && task.getScheduledForDate() != null) {
            this.scheduledDate = task.getScheduledForDate();
        }
        this.initialize((style & 0x800000) > 0 ? 0x800000 : 0);
        this.contributor = new ScheduleTaskMenuContributor(){

            protected DateRange getScheduledForDate(AbstractTask singleTaskSelection) {
                return ScheduleDatePicker.this.scheduledDate;
            }

            protected void setScheduledDate(DateRange dateRange) {
                if (dateRange != null) {
                    ScheduleDatePicker.this.scheduledDate = dateRange;
                } else {
                    ScheduleDatePicker.this.scheduledDate = null;
                }
                ScheduleDatePicker.this.updateDateText();
                ScheduleDatePicker.this.notifyPickerListeners();
            }
        };
        this.tasks = new ArrayList<IRepositoryElement>();
        this.tasks.add((IRepositoryElement)task);
    }

    private void initialize(int style) {
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        this.scheduledDateText = new Text((Composite)this, style);
        this.scheduledDateText.setEditable(false);
        GridData dateTextGridData = new GridData(4, 4, false, false);
        dateTextGridData.heightHint = 5;
        dateTextGridData.grabExcessHorizontalSpace = true;
        dateTextGridData.verticalAlignment = 4;
        this.scheduledDateText.setLayoutData((Object)dateTextGridData);
        this.scheduledDateText.setText(this.initialText);
        this.clearControl = new ImageHyperlink((Composite)this, 0);
        this.clearControl.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.FIND_CLEAR_DISABLED));
        this.clearControl.setHoverImage(CommonImages.getImage((ImageDescriptor)CommonImages.FIND_CLEAR));
        this.clearControl.setToolTipText(Messages.ScheduleDatePicker_Clear);
        this.clearControl.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ScheduleDatePicker.this.setScheduledDate(null);
                for (IRepositoryElement task : ScheduleDatePicker.this.tasks) {
                    if (!(task instanceof AbstractTask)) continue;
                    ((AbstractTask)task).setReminded(false);
                }
                ScheduleDatePicker.this.notifyPickerListeners();
            }
        });
        this.clearControl.setBackground(this.clearControl.getDisplay().getSystemColor(1));
        GridData clearButtonGridData = new GridData();
        clearButtonGridData.horizontalIndent = 3;
        this.clearControl.setLayoutData((Object)clearButtonGridData);
        this.pickButton = new Button((Composite)this, style | 4 | 0x400);
        GridData pickButtonGridData = new GridData(131072, 4, false, true);
        pickButtonGridData.verticalIndent = 0;
        pickButtonGridData.horizontalIndent = 3;
        this.pickButton.setLayoutData((Object)pickButtonGridData);
        this.pickButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MenuManager menuManager = ScheduleDatePicker.this.contributor.getSubMenuManager(ScheduleDatePicker.this.tasks);
                Menu menu = menuManager.createContextMenu((Control)ScheduleDatePicker.this.pickButton);
                ScheduleDatePicker.this.pickButton.setMenu(menu);
                menu.setVisible(true);
                Point location = ScheduleDatePicker.this.pickButton.toDisplay(ScheduleDatePicker.this.pickButton.getLocation());
                Rectangle bounds = ScheduleDatePicker.this.pickButton.getBounds();
                menu.setLocation(location.x - ((ScheduleDatePicker)ScheduleDatePicker.this).pickButton.getBounds().x, location.y + bounds.height + 2);
            }
        });
        this.updateDateText();
        this.pack();
    }

    private void updateClearControlVisibility() {
        if (this.clearControl != null && this.clearControl.getLayoutData() instanceof GridData) {
            GridData gd = (GridData)this.clearControl.getLayoutData();
            gd.exclude = this.scheduledDate == null;
            this.clearControl.getParent().layout();
        }
    }

    public void addPickerSelectionListener(SelectionListener listener) {
        this.pickerListeners.add(listener);
    }

    public void setForeground(Color color) {
        this.pickButton.setForeground(color);
        this.scheduledDateText.setForeground(color);
        super.setForeground(color);
    }

    public void setBackground(Color backgroundColor) {
        this.pickButton.setBackground(backgroundColor);
        this.scheduledDateText.setBackground(backgroundColor);
        super.setBackground(backgroundColor);
    }

    private void notifyPickerListeners() {
        for (SelectionListener listener : this.pickerListeners) {
            listener.widgetSelected(null);
        }
    }

    private void updateDateText() {
        if (this.scheduledDate != null) {
            this.scheduledDateText.setText(this.scheduledDate.toString());
        } else {
            this.scheduledDateText.setEnabled(false);
            this.scheduledDateText.setText(DatePicker.LABEL_CHOOSE);
            this.scheduledDateText.setEnabled(true);
        }
        this.updateClearControlVisibility();
    }

    public void setEnabled(boolean enabled) {
        this.scheduledDateText.setEnabled(enabled);
        this.pickButton.setEnabled(enabled);
        this.clearControl.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public DateRange getScheduledDate() {
        return this.scheduledDate;
    }

    public void setScheduledDate(DateRange date) {
        this.scheduledDate = date;
        this.updateDateText();
    }

    public boolean isFloatingDate() {
        return false;
    }
}

