/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.utility.swt;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jpt.common.ui.internal.listeners.SWTCollectionChangeListenerWrapper;
import org.eclipse.jpt.common.ui.internal.utility.swt.ListWidgetModelBinding;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.WritableCollectionValueModel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ListBoxSelectionBinding<E>
implements ListWidgetModelBinding.SelectionBinding {
    private final ListValueModel<E> listModel;
    private final WritableCollectionValueModel<E> selectedItemsModel;
    private final CollectionChangeListener selectedItemsChangeListener;
    private final List listBox;
    private final SelectionListener listBoxSelectionListener;

    ListBoxSelectionBinding(ListValueModel<E> listModel, WritableCollectionValueModel<E> selectedItemsModel, List listBox) {
        if (listModel == null || selectedItemsModel == null || listBox == null) {
            throw new NullPointerException();
        }
        this.listModel = listModel;
        this.selectedItemsModel = selectedItemsModel;
        this.listBox = listBox;
        this.selectedItemsChangeListener = this.buildSelectedItemsChangeListener();
        this.selectedItemsModel.addCollectionChangeListener("values", this.selectedItemsChangeListener);
        this.listBoxSelectionListener = this.buildListBoxSelectionListener();
        this.listBox.addSelectionListener(this.listBoxSelectionListener);
    }

    private CollectionChangeListener buildSelectedItemsChangeListener() {
        return new SWTCollectionChangeListenerWrapper(this.buildSelectedItemsChangeListener_());
    }

    private CollectionChangeListener buildSelectedItemsChangeListener_() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionAddEvent event) {
                ListBoxSelectionBinding.this.selectedItemsAdded(event);
            }

            public void itemsRemoved(CollectionRemoveEvent event) {
                ListBoxSelectionBinding.this.selectedItemsRemoved(event);
            }

            public void collectionCleared(CollectionClearEvent event) {
                ListBoxSelectionBinding.this.selectedItemsCleared(event);
            }

            public void collectionChanged(CollectionChangeEvent event) {
                ListBoxSelectionBinding.this.selectedItemsChanged(event);
            }

            public String toString() {
                return "selected items listener";
            }
        };
    }

    private SelectionListener buildListBoxSelectionListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ListBoxSelectionBinding.this.listBoxSelectionChanged(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                ListBoxSelectionBinding.this.listBoxDoubleClicked(event);
            }

            public String toString() {
                return "list box selection listener";
            }
        };
    }

    @Override
    public void synchronizeListWidgetSelection() {
        int selectedItemsSize = this.selectedItemsModel.size();
        int[] select = new int[selectedItemsSize];
        int i = 0;
        for (Object item : this.selectedItemsModel) {
            select[i++] = this.indexOf(item);
        }
        int listSize = this.listModel.size();
        int[] deselect = new int[listSize - selectedItemsSize];
        i = 0;
        int j = 0;
        while (j < listSize) {
            if (!ArrayTools.contains((int[])select, (int)j)) {
                deselect[i++] = j;
            }
            ++j;
        }
        int[] old = ArrayTools.sort((int[])this.listBox.getSelectionIndices());
        if (!Arrays.equals(select = ArrayTools.sort((int[])select), old)) {
            this.listBox.deselect(deselect);
            this.listBox.select(select);
        }
    }

    @Override
    public void dispose() {
        this.listBox.removeSelectionListener(this.listBoxSelectionListener);
        this.selectedItemsModel.removeCollectionChangeListener("values", this.selectedItemsChangeListener);
    }

    void selectedItemsAdded(CollectionAddEvent event) {
        if (!this.listBox.isDisposed()) {
            this.selectedItemsAdded_(event);
        }
    }

    private void selectedItemsAdded_(CollectionAddEvent event) {
        int[] indices = new int[event.getItemsSize()];
        int i = 0;
        for (E item : this.getItems(event)) {
            indices[i++] = this.indexOf(item);
        }
        this.listBox.select(indices);
    }

    private Iterable<E> getItems(CollectionAddEvent event) {
        return event.getItems();
    }

    void selectedItemsRemoved(CollectionRemoveEvent event) {
        if (!this.listBox.isDisposed()) {
            this.selectedItemsRemoved_(event);
        }
    }

    private void selectedItemsRemoved_(CollectionRemoveEvent event) {
        int[] indices = new int[event.getItemsSize()];
        int i = 0;
        for (E item : this.getItems(event)) {
            indices[i++] = this.indexOf(item);
        }
        this.listBox.deselect(indices);
    }

    private Iterable<E> getItems(CollectionRemoveEvent event) {
        return event.getItems();
    }

    void selectedItemsCleared(CollectionClearEvent event) {
        if (!this.listBox.isDisposed()) {
            this.selectedItemsCleared_(event);
        }
    }

    private void selectedItemsCleared_(CollectionClearEvent event) {
        this.listBox.deselectAll();
    }

    void selectedItemsChanged(CollectionChangeEvent event) {
        if (!this.listBox.isDisposed()) {
            this.selectedItemsChanged_(event);
        }
    }

    private void selectedItemsChanged_(CollectionChangeEvent event) {
        this.synchronizeListWidgetSelection();
    }

    private int indexOf(E item) {
        int len = this.listModel.size();
        int i = 0;
        while (i < len) {
            if (Tools.valuesAreEqual((Object)this.listModel.get(i), item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void listBoxSelectionChanged(SelectionEvent event) {
        if (!this.listBox.isDisposed()) {
            this.listBoxSelectionChanged_(event);
        }
    }

    void listBoxDoubleClicked(SelectionEvent event) {
        if (!this.listBox.isDisposed()) {
            this.listBoxSelectionChanged_(event);
        }
    }

    private void listBoxSelectionChanged_(SelectionEvent event) {
        this.selectedItemsModel.setValues(this.getListBoxSelectedItems());
    }

    private Iterable<E> getListBoxSelectedItems() {
        ArrayList<Object> selectedItems = new ArrayList<Object>(this.listBox.getSelectionCount());
        int[] nArray = this.listBox.getSelectionIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int selectionIndex = nArray[n2];
            selectedItems.add(this.listModel.get(selectionIndex));
            ++n2;
        }
        return selectedItems;
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, this.selectedItemsModel);
    }
}

