/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.ui.details.DefaultMappingUiDefinition;
import org.eclipse.jpt.jpa.ui.details.MappingUiDefinition;
import org.eclipse.jpt.jpa.ui.internal.details.JptUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.internal.details.MapAsComposite;
import org.eclipse.jpt.jpa.ui.internal.details.orm.UnsupportedOrmMappingUiDefinition;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentAttributeMapAsComposite
extends MapAsComposite<ReadOnlyPersistentAttribute> {
    public PersistentAttributeMapAsComposite(Pane<? extends ReadOnlyPersistentAttribute> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    @Override
    protected String getMappingKey() {
        return ((ReadOnlyPersistentAttribute)this.getSubject()).getMappingKey();
    }

    @Override
    protected MapAsComposite.MappingChangeHandler buildMappingChangeHandler() {
        return new MapAsComposite.MappingChangeHandler(){

            @Override
            public String getLabelText() {
                String mappingKey = PersistentAttributeMapAsComposite.this.getMappingKey();
                if (mappingKey != MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY) {
                    return JptUiDetailsMessages.MapAsComposite_mappedAttributeText;
                }
                if (((ReadOnlyPersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).isVirtual()) {
                    return JptUiDetailsMessages.MapAsComposite_virtualAttributeText;
                }
                return JptUiDetailsMessages.MapAsComposite_unmappedAttributeText;
            }

            @Override
            public String getMappingText() {
                String mappingKey = PersistentAttributeMapAsComposite.this.getMappingKey();
                if (mappingKey == null) {
                    return JptUiDetailsMessages.MapAsComposite_changeMappingType;
                }
                return ((ReadOnlyPersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).getMapping().isDefault() ? PersistentAttributeMapAsComposite.this.getDefaultDefinition(((ReadOnlyPersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).getDefaultMappingKey()).getLinkLabel() : PersistentAttributeMapAsComposite.this.getMappingUiDefinition(mappingKey).getLinkLabel();
            }

            public void morphMapping(MappingUiDefinition definition) {
                ((PersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).setMappingKey(definition.getKey());
            }

            @Override
            public String getName() {
                return ((ReadOnlyPersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).getName();
            }

            public Iterator<? extends MappingUiDefinition<? extends ReadOnlyPersistentAttribute, ?>> mappingUiDefinitions() {
                return PersistentAttributeMapAsComposite.this.attributeMappingUiDefinitions();
            }
        };
    }

    protected Iterator<? extends MappingUiDefinition<? extends ReadOnlyPersistentAttribute, ?>> attributeMappingUiDefinitions() {
        return this.getJpaPlatformUi().attributeMappingUiDefinitions(((ReadOnlyPersistentAttribute)this.getSubject()).getResourceType());
    }

    @Override
    protected DefaultMappingUiDefinition getDefaultDefinition() {
        return this.getDefaultDefinition(((ReadOnlyPersistentAttribute)this.getSubject()).getDefaultMappingKey());
    }

    @Override
    protected DefaultMappingUiDefinition getDefaultDefinition(String mappingKey) {
        return this.getJpaPlatformUi().getDefaultAttributeMappingUiDefinition(((ReadOnlyPersistentAttribute)this.getSubject()).getMapping().getResourceType(), mappingKey);
    }

    @Override
    protected MappingUiDefinition getMappingUiDefinition(String mappingKey) {
        MappingUiDefinition definition = super.getMappingUiDefinition(mappingKey);
        return definition != null ? definition : UnsupportedOrmMappingUiDefinition.instance();
    }

    protected void addPropertyNames(Collection<String> propertyNames) {
        super.addPropertyNames(propertyNames);
        propertyNames.add("defaultMappingKey");
        propertyNames.add("mapping");
        propertyNames.add("name");
    }

    protected void propertyChanged(String propertyName) {
        super.propertyChanged(propertyName);
        if (propertyName == "mapping" || propertyName == "defaultMappingKey" || propertyName == "name") {
            this.updateDescription();
        }
    }
}

