/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainer;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JsGlobalScopeContainerInitializer;
import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.core.compiler.libraries.LibraryLocation;
import org.eclipse.wst.jsdt.core.compiler.libraries.SystemLibraryLocation;
import org.eclipse.wst.jsdt.launching.IVMInstall;
import org.eclipse.wst.jsdt.launching.IVMInstallType;
import org.eclipse.wst.jsdt.launching.JREContainer;
import org.eclipse.wst.jsdt.launching.JavaRuntime;
import org.eclipse.wst.jsdt.launching.LaunchingMessages;

public class JREContainerInitializer
extends JsGlobalScopeContainerInitializer {
    public void initialize(IPath containerPath, IJavaScriptProject project) throws CoreException {
        int size = containerPath.segmentCount();
        if (size > 0 && containerPath.segment(0).equals("org.eclipse.wst.jsdt.launching.JRE_CONTAINER")) {
            IVMInstall vm = JREContainerInitializer.resolveVM(containerPath);
            JREContainer container = null;
            if (vm != null) {
                container = new JREContainer(vm, containerPath);
            }
            JavaScriptCore.setJsGlobalScopeContainer(containerPath, new IJavaScriptProject[]{project}, new IJsGlobalScopeContainer[]{container}, null);
        }
    }

    public int getKind() {
        return 3;
    }

    public static IVMInstall resolveVM(IPath containerPath) {
        IVMInstall vm = null;
        if (containerPath.segmentCount() > 1) {
            String id = JREContainerInitializer.getExecutionEnvironmentId(containerPath);
            if (id != null) {
                throw new UnimplementedException();
            }
            String vmTypeId = JREContainerInitializer.getVMTypeId(containerPath);
            String vmName = JREContainerInitializer.getVMName(containerPath);
            IVMInstallType vmType = JavaRuntime.getVMInstallType(vmTypeId);
            if (vmType != null) {
                vm = vmType.findVMInstallByName(vmName);
            }
        } else {
            vm = JavaRuntime.getDefaultVMInstall();
        }
        return vm;
    }

    public static String getExecutionEnvironmentId(IPath path) {
        return null;
    }

    public static boolean isExecutionEnvironment(IPath path) {
        return JREContainerInitializer.getExecutionEnvironmentId(path) != null;
    }

    public static String encodeEnvironmentId(String id) {
        return id.replace('/', '%');
    }

    public static String decodeEnvironmentId(String id) {
        return id.replace('%', '/');
    }

    public static String getVMTypeId(IPath path) {
        return path.segment(1);
    }

    public static String getVMName(IPath path) {
        return path.segment(2);
    }

    public boolean canUpdateJsGlobalScopeContainer(IPath containerPath, IJavaScriptProject project) {
        return false;
    }

    public void requestJsGlobalScopeContainerUpdate(IPath containerPath, IJavaScriptProject project, IJsGlobalScopeContainer containerSuggestion) throws CoreException {
    }

    public String getDescription(IPath containerPath, IJavaScriptProject project) {
        if (containerPath != null && containerPath.segment(0).equals("org.eclipse.wst.jsdt.launching.JRE_CONTAINER")) {
            return LaunchingMessages.JREContainerInitializer_JsECMA_NAME;
        }
        return containerPath.lastSegment();
    }

    public LibraryLocation getLibraryLocation() {
        return new SystemLibraryLocation();
    }

    public boolean allowAttachJsDoc() {
        return false;
    }

    public String[] containerSuperTypes() {
        return new String[]{LaunchingMessages.JREContainerInitializer_Global, LaunchingMessages.JREContainerInitializer_Object, LaunchingMessages.JREContainerInitializer_Array};
    }

    public String getInferenceID() {
        return "org.eclipse.wst.jsdt.core.infer.DefaultInferrenceProvider";
    }
}

