/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.wst.server.core.internal.Trace;

public class SocketUtil {
    private static final Random rand = new Random(System.currentTimeMillis());
    protected static final Object lock = new Object();
    private static Set<String> localHostCache = new HashSet<String>();
    private static Set<String> notLocalHostCache = new HashSet<String>();
    private static Map<String, CacheThread> threadMap = new HashMap<String, CacheThread>();
    private static Set<InetAddress> addressCache;

    private SocketUtil() {
    }

    public static int findUnusedPort(int low, int high) {
        return SocketUtil.findUnusedPort(null, low, high);
    }

    public static int findUnusedPort(InetAddress address, int low, int high) {
        if (high < low) {
            return -1;
        }
        int i = 0;
        while (i < 10) {
            int port = SocketUtil.getRandomPort(low, high);
            if (!SocketUtil.isPortInUse(address, port)) {
                return port;
            }
            ++i;
        }
        return -1;
    }

    private static int getRandomPort(int low, int high) {
        return rand.nextInt(high - low) + low;
    }

    public static boolean isPortInUse(int port, int count) {
        return SocketUtil.isPortInUse(null, port, count);
    }

    public static boolean isPortInUse(InetAddress address, int port, int count) {
        boolean inUse = SocketUtil.isPortInUse(address, port);
        while (inUse && count > 0) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
            inUse = SocketUtil.isPortInUse(address, port);
            --count;
        }
        return inUse;
    }

    public static boolean isPortInUse(int port) {
        return SocketUtil.isPortInUse(null, port);
    }

    /*
     * Loose catch block
     */
    public static boolean isPortInUse(InetAddress address, int port) {
        block22: {
            ServerSocket s = null;
            try {
                s = new ServerSocket(port, 0, address);
            }
            catch (SocketException socketException) {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Exception exception) {}
                }
                return true;
            }
            catch (IOException iOException) {
                block20: {
                    if (s == null) break block20;
                    try {
                        s.close();
                    }
                    catch (Exception exception) {}
                }
                return true;
            }
            catch (Exception exception) {
                block21: {
                    if (s == null) break block21;
                    {
                        catch (Throwable throwable) {
                            if (s != null) {
                                try {
                                    s.close();
                                }
                                catch (Exception exception2) {}
                            }
                            throw throwable;
                        }
                    }
                    try {
                        s.close();
                    }
                    catch (Exception exception3) {}
                }
                return true;
            }
            if (s == null) break block22;
            try {
                s.close();
            }
            catch (Exception exception) {}
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isLocalhost(String host) {
        Object object;
        block52: {
            boolean refreshedCache;
            boolean currentThread;
            block51: {
                InetAddress localHostaddr;
                block50: {
                    block49: {
                        if (host == null) return false;
                        if (host.equals("")) {
                            return false;
                        }
                        if ("localhost".equals(host = host.toLowerCase())) return true;
                        if ("127.0.0.1".equals(host)) return true;
                        if ("::1".equals(host)) {
                            return true;
                        }
                        Object object2 = lock;
                        synchronized (object2) {
                            if (localHostCache.contains(host)) {
                                return true;
                            }
                            if (notLocalHostCache.contains(host)) {
                                return false;
                            }
                        }
                        localHostaddr = null;
                        try {
                            localHostaddr = InetAddress.getLocalHost();
                            if (host.equals(localHostaddr.getHostName().toLowerCase()) || host.equals(localHostaddr.getCanonicalHostName().toLowerCase()) || host.equals(localHostaddr.getHostAddress().toLowerCase())) {
                                Object object3 = lock;
                                synchronized (object3) {
                                    localHostCache.add(host);
                                    return true;
                                }
                            }
                        }
                        catch (Exception e) {
                            if (!Trace.WARNING) break block49;
                            Trace.trace("/warning", "Localhost caching failure", e);
                        }
                    }
                    currentThread = false;
                    try {
                        Thread t = null;
                        object = lock;
                        synchronized (object) {
                            t = threadMap.get(host);
                        }
                        if (t != null && t.isAlive()) {
                            currentThread = true;
                            t.join(30L);
                        }
                    }
                    catch (Exception e) {
                        if (!Trace.WARNING) break block50;
                        Trace.trace("/warning", "Localhost caching failure", e);
                    }
                }
                refreshedCache = false;
                try {
                    CacheThread cacheThread;
                    HashSet<InetAddress> currentAddresses = new HashSet<InetAddress>();
                    if (localHostaddr != null) {
                        currentAddresses.add(localHostaddr);
                    }
                    Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                    block32: while (true) {
                        if (!nis.hasMoreElements()) {
                            if (addressCache == null || !addressCache.containsAll(currentAddresses) || !currentAddresses.containsAll(addressCache)) {
                                cacheThread = null;
                                refreshedCache = true;
                                Object object4 = lock;
                                synchronized (object4) {
                                    addressCache = currentAddresses;
                                    notLocalHostCache = new HashSet<String>();
                                    localHostCache = new HashSet<String>(currentAddresses.size() * 3);
                                    Iterator iter = currentAddresses.iterator();
                                    while (true) {
                                        if (!iter.hasNext()) {
                                            cacheThread = new CacheThread(host, currentAddresses, localHostCache, notLocalHostCache, threadMap);
                                            threadMap.put(host, cacheThread);
                                            cacheThread.setDaemon(true);
                                            cacheThread.setPriority(4);
                                            cacheThread.start();
                                            break block32;
                                        }
                                        InetAddress addr = (InetAddress)iter.next();
                                        String a = addr.getHostAddress().toLowerCase();
                                        if (a == null || localHostCache.contains(a)) continue;
                                        localHostCache.add(a);
                                    }
                                }
                            }
                            break block51;
                        }
                        NetworkInterface inter = nis.nextElement();
                        Enumeration<InetAddress> ias = inter.getInetAddresses();
                        while (true) {
                            if (!ias.hasMoreElements()) continue block32;
                            currentAddresses.add(ias.nextElement());
                        }
                        break;
                    }
                    cacheThread.join(200L);
                }
                catch (Exception e) {
                    if (!Trace.WARNING) break block51;
                    Trace.trace("/warning", "Localhost caching failure", e);
                }
            }
            Object e = lock;
            synchronized (e) {
                if (localHostCache.contains(host)) {
                    return true;
                }
                if (notLocalHostCache.contains(host)) {
                    return false;
                }
            }
            if (!refreshedCache && !currentThread) {
                try {
                    CacheThread cacheThread = null;
                    Object object5 = lock;
                    synchronized (object5) {
                        cacheThread = new CacheThread(host, null, localHostCache, notLocalHostCache, threadMap);
                        threadMap.put(host, cacheThread);
                        cacheThread.setDaemon(true);
                        cacheThread.setPriority(4);
                        cacheThread.start();
                    }
                    cacheThread.join(75L);
                    object5 = lock;
                    synchronized (object5) {
                        if (localHostCache.contains(host)) {
                            return true;
                        }
                    }
                }
                catch (Exception e2) {
                    if (!Trace.WARNING) break block52;
                    Trace.trace("/warning", "Could not find localhost", e2);
                }
            }
        }
        object = lock;
        synchronized (object) {
            if (notLocalHostCache.contains(host)) return false;
            notLocalHostCache.add(host);
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CacheThread
    extends Thread {
        private Set<InetAddress> currentAddresses;
        private Set<String> addressList;
        private String host;
        private Set<String> nonAddressList;
        private Map threadMap2;

        public CacheThread(String host, Set<InetAddress> currentAddresses, Set<String> addressList, Set<String> nonAddressList, Map threadMap2) {
            super("Caching localhost information");
            this.host = host;
            this.currentAddresses = currentAddresses;
            this.addressList = addressList;
            this.nonAddressList = nonAddressList;
            this.threadMap2 = threadMap2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            if (this.currentAddresses != null) {
                for (InetAddress addr : this.currentAddresses) {
                    String hostname = addr.getHostName().toLowerCase();
                    String hostname2 = addr.getCanonicalHostName().toLowerCase();
                    Object object2 = lock;
                    synchronized (object2) {
                        if (hostname != null && !this.addressList.contains(hostname)) {
                            this.addressList.add(hostname);
                        }
                        if (hostname2 != null && !this.addressList.contains(hostname2)) {
                            this.addressList.add(hostname2);
                        }
                    }
                }
            }
            try {
                InetAddress[] addrs = InetAddress.getAllByName(this.host);
                int length = addrs.length;
                int j = 0;
                while (j < length) {
                    InetAddress addr = addrs[0];
                    String hostname = addr.getHostName().toLowerCase();
                    String hostname2 = addr.getCanonicalHostName().toLowerCase();
                    Object object3 = lock;
                    synchronized (object3) {
                        if (addr.isLoopbackAddress()) {
                            if (hostname != null && !this.addressList.contains(hostname)) {
                                this.addressList.add(hostname);
                            }
                            if (hostname2 != null && !this.addressList.contains(hostname2)) {
                                this.addressList.add(hostname2);
                            }
                        } else {
                            if (hostname != null && !this.nonAddressList.contains(hostname)) {
                                this.nonAddressList.add(hostname);
                            }
                            if (hostname2 != null && !this.nonAddressList.contains(hostname2)) {
                                this.nonAddressList.add(hostname2);
                            }
                        }
                    }
                    ++j;
                }
            }
            catch (UnknownHostException unknownHostException) {
                object = lock;
                synchronized (object) {
                    if (this.host != null && !this.nonAddressList.contains(this.host)) {
                        this.nonAddressList.add(this.host);
                    }
                }
            }
            object = lock;
            synchronized (object) {
                this.threadMap2.remove(this.host);
            }
        }
    }
}

