/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainIterator<E>
implements Iterator<E> {
    private E nextLink;
    private final Linker<E> linker;

    public ChainIterator(E startLink) {
        this(startLink, Linker.Disabled.instance());
    }

    public ChainIterator(E startLink, Linker<E> linker) {
        this.nextLink = startLink;
        this.linker = linker;
    }

    @Override
    public boolean hasNext() {
        return this.nextLink != null;
    }

    @Override
    public E next() {
        if (this.nextLink == null) {
            throw new NoSuchElementException();
        }
        E result = this.nextLink;
        this.nextLink = this.nextLink(this.nextLink);
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected E nextLink(E currentLink) {
        return this.linker.nextLink(currentLink);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.nextLink);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Linker<T> {
        public T nextLink(T var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Disabled<S>
        implements Linker<S> {
            public static final Linker INSTANCE = new Disabled();
            private static final long serialVersionUID = 1L;

            public static <R> Linker<R> instance() {
                return INSTANCE;
            }

            private Disabled() {
            }

            @Override
            public S nextLink(S currentLink) {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return "ChainIterator.Linker.Disabled";
            }

            private Object readResolve() {
                return INSTANCE;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Null<S>
        implements Linker<S> {
            public static final Linker INSTANCE = new Null();
            private static final long serialVersionUID = 1L;

            public static <R> Linker<R> instance() {
                return INSTANCE;
            }

            private Null() {
            }

            @Override
            public S nextLink(S currentLink) {
                return null;
            }

            public String toString() {
                return "ChainIterator.Linker.Null";
            }

            private Object readResolve() {
                return INSTANCE;
            }
        }
    }
}

