/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterables;

import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.common.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.common.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeIterable<E>
implements Iterable<E> {
    private final Iterable<? extends Iterable<? extends E>> iterables;

    public CompositeIterable(Iterable<? extends Iterable<? extends E>> iterables) {
        this.iterables = iterables;
    }

    public CompositeIterable(E object, Iterable<? extends E> iterable) {
        this(new Iterable[]{new SingleElementIterable<E>(object), iterable});
    }

    public CompositeIterable(Iterable<? extends E> iterable, E object) {
        this(new Iterable[]{iterable, new SingleElementIterable<E>(object)});
    }

    public CompositeIterable(Iterable<? extends E> ... iterables) {
        this((Iterable<Iterable<? extends E>>)new ArrayIterable<Iterable<? extends E>>(iterables));
    }

    @Override
    public Iterator<E> iterator() {
        return new CompositeIterator<E>(this.iterators());
    }

    protected Iterator<? extends Iterator<? extends E>> iterators() {
        return new TransformationIterator<Iterable<? extends E>, Iterator<? extends E>>(this.iterables()){

            @Override
            protected Iterator<? extends E> transform(Iterable<? extends E> next) {
                return next.iterator();
            }
        };
    }

    protected Iterator<? extends Iterable<? extends E>> iterables() {
        return this.iterables.iterator();
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.iterables);
    }
}

