/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.xsd;

import java.util.Stack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.util.XSDSwitch;

public class XSDNodeVisitor {
    private Stack<XSDComponent> visitedNodeStack = new Stack();

    public void visitNode(XSDComponent node) {
        if (node != null && !this.visitedNodeStack.contains(node)) {
            this.visitedNodeStack.push(node);
            XSDSwitch xsdSwitch = new XSDSwitch(){

                public Object caseXSDAttributeDeclaration(XSDAttributeDeclaration object) {
                    XSDNodeVisitor.this.visitXSDAttributeDeclaration(object);
                    return null;
                }

                public Object caseXSDAttributeGroupDefinition(XSDAttributeGroupDefinition object) {
                    XSDNodeVisitor.this.visitXSDAttributeGroupDefinition(object);
                    return null;
                }

                public Object caseXSDAttributeUse(XSDAttributeUse object) {
                    XSDNodeVisitor.this.visitXSDAttributeUse(object);
                    return null;
                }

                public Object caseXSDComplexTypeDefinition(XSDComplexTypeDefinition object) {
                    XSDNodeVisitor.this.visitXSDComplexTypeDefinition(object);
                    return null;
                }

                public Object caseXSDElementDeclaration(XSDElementDeclaration object) {
                    XSDNodeVisitor.this.visitXSDElementDeclaration(object);
                    return null;
                }

                public Object caseXSDModelGroup(XSDModelGroup object) {
                    XSDNodeVisitor.this.visitXSDModelGroup(object);
                    return null;
                }

                public Object caseXSDModelGroupDefinition(XSDModelGroupDefinition object) {
                    XSDNodeVisitor.this.visitXSDModelGroupDefinition(object);
                    return null;
                }

                public Object caseXSDParticle(XSDParticle object) {
                    XSDNodeVisitor.this.visitXSDParticle(object);
                    return null;
                }

                public Object caseXSDSimpleTypeDefinition(XSDSimpleTypeDefinition object) {
                    XSDNodeVisitor.this.visitXSDSimpleTypeDefinition(object);
                    return null;
                }
            };
            xsdSwitch.doSwitch((EObject)node);
            this.visitedNodeStack.pop();
        }
    }

    public void visitXSDAttributeDeclaration(XSDAttributeDeclaration node) {
    }

    public void visitXSDAttributeGroupDefinition(XSDAttributeGroupDefinition node) {
        for (XSDAttributeUse attrUse : node.getAttributeUses()) {
            this.visitNode((XSDComponent)attrUse);
        }
    }

    public void visitXSDAttributeUse(XSDAttributeUse node) {
    }

    public void visitXSDComplexTypeDefinition(XSDComplexTypeDefinition node) {
        if (node.getBaseType() != null) {
            this.visitNode((XSDComponent)node.getBaseType());
        }
        for (XSDAttributeUse attrUse : node.getAttributeUses()) {
            this.visitNode((XSDComponent)attrUse);
        }
        if (node.getContent() != null) {
            this.visitNode((XSDComponent)node.getContent());
        }
    }

    public void visitXSDElementDeclaration(XSDElementDeclaration node) {
        for (XSDElementDeclaration element : node.getSubstitutionGroup()) {
            this.visitNode((XSDComponent)element);
        }
        if (node.getTypeDefinition() != null) {
            this.visitNode((XSDComponent)node.getTypeDefinition());
        }
    }

    public void visitXSDModelGroup(XSDModelGroup node) {
        for (XSDParticle particle : node.getParticles()) {
            this.visitNode((XSDComponent)particle);
        }
    }

    public void visitXSDModelGroupDefinition(XSDModelGroupDefinition node) {
        if (node.getModelGroup() != null) {
            this.visitNode((XSDComponent)node.getModelGroup());
        }
    }

    public void visitXSDParticle(XSDParticle node) {
        if (node.getTerm() != null) {
            this.visitNode((XSDComponent)node.getTerm());
        }
    }

    public void visitXSDSimpleTypeDefinition(XSDSimpleTypeDefinition node) {
        if (node.getBaseType() != null) {
            this.visitNode((XSDComponent)node.getBaseType());
        }
    }
}

