/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.java.source;

import java.util.HashMap;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jpt.common.core.utility.jdt.AbstractType;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.SimpleIntReference;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jaxb.core.internal.resource.java.source.SourceMember;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourceAbstractType<A extends AbstractType>
extends SourceMember<A>
implements JavaResourceAbstractType {
    private String name;
    private String qualifiedName;
    private String packageName;
    private String declaringTypeName;
    private boolean memberType;

    protected SourceAbstractType(JavaResourceCompilationUnit javaResourceCompilationUnit, A type) {
        super((JavaResourceNode)javaResourceCompilationUnit, type);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        ITypeBinding binding = ((AbstractType)this.annotatedElement).getBinding(astRoot);
        this.name = this.buildName(binding);
        this.qualifiedName = this.buildQualifiedName(binding);
        this.packageName = this.buildPackageName(binding);
        this.declaringTypeName = this.buildDeclaringTypeName(binding);
        this.memberType = this.buildMemberType(binding);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        ITypeBinding binding = ((AbstractType)this.annotatedElement).getBinding(astRoot);
        this.syncName(this.buildName(binding));
        this.syncQualifiedName(this.buildQualifiedName(binding));
        this.syncPackageName(this.buildPackageName(binding));
        this.syncDeclaringTypeName(this.buildDeclaringTypeName(binding));
        this.syncMemberType(this.buildMemberType(binding));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(ITypeBinding binding) {
        return binding == null ? null : binding.getName();
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    private void syncQualifiedName(String astQualifiedName) {
        String old = this.qualifiedName;
        this.qualifiedName = astQualifiedName;
        this.firePropertyChanged("qualifiedName", old, astQualifiedName);
    }

    private String buildQualifiedName(ITypeBinding binding) {
        return binding == null ? null : binding.getQualifiedName();
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    private void syncPackageName(String astPackageName) {
        String old = this.packageName;
        this.packageName = astPackageName;
        this.firePropertyChanged("packageName", old, astPackageName);
    }

    private String buildPackageName(ITypeBinding binding) {
        return binding == null ? null : binding.getPackage().getName();
    }

    @Override
    public boolean isIn(IPackageFragment packageFragment) {
        return StringTools.stringsAreEqual((String)packageFragment.getElementName(), (String)this.packageName);
    }

    @Override
    public String getDeclaringTypeName() {
        return this.declaringTypeName;
    }

    private void syncDeclaringTypeName(String astDeclaringTypeName) {
        String old = this.declaringTypeName;
        this.declaringTypeName = astDeclaringTypeName;
        this.firePropertyChanged("declaringTypeName", old, astDeclaringTypeName);
    }

    private String buildDeclaringTypeName(ITypeBinding binding) {
        if (binding == null) {
            return null;
        }
        ITypeBinding declaringClass = binding.getDeclaringClass();
        return declaringClass == null ? null : declaringClass.getTypeDeclaration().getQualifiedName();
    }

    @Override
    public boolean isMemberType() {
        return this.memberType;
    }

    private void syncMemberType(boolean memberType) {
        boolean old = this.memberType;
        this.memberType = memberType;
        this.firePropertyChanged("memberType", old, memberType);
    }

    private boolean buildMemberType(ITypeBinding binding) {
        return binding == null ? false : binding.isMember();
    }

    @Override
    public boolean isMapped() {
        return !CollectionTools.isEmpty(this.getAnnotations());
    }

    protected static class CounterMap {
        private final HashMap<Object, SimpleIntReference> counters;

        protected CounterMap(int initialCapacity) {
            this.counters = new HashMap(initialCapacity);
        }

        int increment(Object o) {
            SimpleIntReference counter = this.counters.get(o);
            if (counter == null) {
                counter = new SimpleIntReference();
                this.counters.put(o, counter);
            }
            counter.increment();
            return counter.getValue();
        }
    }
}

