/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.platform;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jpt.common.core.internal.utility.XPointTools;
import org.eclipse.jpt.common.utility.internal.KeyedSet;
import org.eclipse.jpt.common.utility.internal.iterables.SuperIterableWrapper;
import org.eclipse.jpt.jaxb.core.JaxbFacet;
import org.eclipse.jpt.jaxb.core.JptJaxbCorePlugin;
import org.eclipse.jpt.jaxb.core.internal.platform.JaxbPlatformDescriptionImpl;
import org.eclipse.jpt.jaxb.core.internal.platform.JaxbPlatformGroupDescriptionImpl;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformDefinition;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformDescription;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformGroupDescription;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformManager;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbPlatformManagerImpl
implements JaxbPlatformManager {
    static final String EXTENSION_POINT_ID = "jaxbPlatforms";
    static final String QUALIFIED_EXTENSION_POINT_ID = "org.eclipse.jpt.jaxb.core.jaxbPlatforms";
    static final String PLATFORM_GROUP_ELEMENT = "jaxbPlatformGroup";
    static final String PLATFORM_ELEMENT = "jaxbPlatform";
    static final String ID_ATTRIBUTE = "id";
    static final String LABEL_ATTRIBUTE = "label";
    static final String FACTORY_CLASS_ATTRIBUTE = "factoryClass";
    static final String JAXB_FACET_VERSION_ATTRIBUTE = "jaxbFacetVersion";
    static final String DEFAULT_ATTRIBUTE = "default";
    static final String GROUP_ELEMENT = "group";
    private static final JaxbPlatformManagerImpl INSTANCE = new JaxbPlatformManagerImpl();
    private KeyedSet<String, JaxbPlatformGroupDescriptionImpl> platformGroupDescriptions = new KeyedSet();
    private KeyedSet<String, JaxbPlatformDescriptionImpl> platformDescriptions = new KeyedSet();

    public static JaxbPlatformManagerImpl instance() {
        return INSTANCE;
    }

    private JaxbPlatformManagerImpl() {
        this.readExtensions();
    }

    private void readExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint xpoint = registry.getExtensionPoint("org.eclipse.jpt.jaxb.core", EXTENSION_POINT_ID);
        if (xpoint == null) {
            throw new IllegalStateException();
        }
        ArrayList<IConfigurationElement> platformGroupConfigs = new ArrayList<IConfigurationElement>();
        ArrayList<IConfigurationElement> platformConfigs = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = xpoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals(PLATFORM_GROUP_ELEMENT)) {
                    platformGroupConfigs.add(element);
                } else if (element.getName().equals(PLATFORM_ELEMENT)) {
                    platformConfigs.add(element);
                }
                ++n4;
            }
            ++n2;
        }
        for (IConfigurationElement element : platformGroupConfigs) {
            this.readPlatformGroupExtension(element);
        }
        for (IConfigurationElement element : platformConfigs) {
            this.readPlatformExtension(element);
        }
    }

    private void readPlatformGroupExtension(IConfigurationElement element) {
        try {
            JaxbPlatformGroupDescriptionImpl desc = new JaxbPlatformGroupDescriptionImpl();
            desc.setPluginId(element.getContributor().getName());
            desc.setId(XPointTools.findRequiredAttribute((IConfigurationElement)element, (String)ID_ATTRIBUTE));
            if (this.platformGroupDescriptions.containsKey((Object)desc.getId())) {
                XPointTools.logDuplicateExtension((String)QUALIFIED_EXTENSION_POINT_ID, (String)ID_ATTRIBUTE, (String)desc.getId());
                throw new XPointTools.XPointException();
            }
            desc.setLabel(XPointTools.findRequiredAttribute((IConfigurationElement)element, (String)LABEL_ATTRIBUTE));
            this.platformGroupDescriptions.addItem((Object)desc.getId(), (Object)desc);
        }
        catch (XPointTools.XPointException xPointException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readPlatformExtension(IConfigurationElement element) {
        try {
            String groupId;
            String defaultString;
            JaxbPlatformDescriptionImpl desc = new JaxbPlatformDescriptionImpl();
            desc.setPluginId(element.getContributor().getName());
            desc.setId(XPointTools.findRequiredAttribute((IConfigurationElement)element, (String)ID_ATTRIBUTE));
            if (this.platformDescriptions.containsKey((Object)desc.getId())) {
                XPointTools.logDuplicateExtension((String)QUALIFIED_EXTENSION_POINT_ID, (String)ID_ATTRIBUTE, (String)desc.getId());
                throw new XPointTools.XPointException();
            }
            desc.setLabel(XPointTools.findRequiredAttribute((IConfigurationElement)element, (String)LABEL_ATTRIBUTE));
            desc.setFactoryClassName(XPointTools.findRequiredAttribute((IConfigurationElement)element, (String)FACTORY_CLASS_ATTRIBUTE));
            String jaxbFacetVersionString = element.getAttribute(JAXB_FACET_VERSION_ATTRIBUTE);
            if (jaxbFacetVersionString != null) {
                IProjectFacetVersion jpaFacetVersion = JaxbFacet.FACET.getVersion(jaxbFacetVersionString);
                if (jpaFacetVersion == null) {
                    XPointTools.logInvalidValue((IConfigurationElement)element, (String)JAXB_FACET_VERSION_ATTRIBUTE, (String)jaxbFacetVersionString);
                    throw new XPointTools.XPointException();
                }
                desc.setJaxbFacetVersion(jpaFacetVersion);
            }
            if ((defaultString = element.getAttribute(DEFAULT_ATTRIBUTE)) != null) {
                if (defaultString.equals("true")) {
                    desc.setDefault(true);
                } else {
                    if (!defaultString.equals("false")) {
                        XPointTools.logInvalidValue((IConfigurationElement)element, (String)DEFAULT_ATTRIBUTE, (String)defaultString);
                        throw new XPointTools.XPointException();
                    }
                    desc.setDefault(false);
                }
            }
            if ((groupId = element.getAttribute(GROUP_ELEMENT)) != null) {
                JaxbPlatformGroupDescriptionImpl group = (JaxbPlatformGroupDescriptionImpl)this.platformGroupDescriptions.getItem((Object)groupId);
                if (group == null) {
                    XPointTools.logInvalidValue((IConfigurationElement)element, (String)GROUP_ELEMENT, (String)groupId);
                    throw new XPointTools.XPointException();
                }
                desc.setGroup(group);
                group.addPlatform(desc);
            } else {
                JaxbPlatformGroupDescriptionImpl group = new JaxbPlatformGroupDescriptionImpl();
                group.setPluginId(desc.getPluginId());
                group.setId(desc.getId());
                group.setLabel(desc.getLabel());
                group.addPlatform(desc);
                if (this.platformGroupDescriptions.containsKey((Object)group.getId())) {
                    XPointTools.logInvalidValue((IConfigurationElement)element, (String)GROUP_ELEMENT, (String)groupId);
                    throw new XPointTools.XPointException();
                }
                this.platformGroupDescriptions.addItem((Object)group.getId(), (Object)group);
            }
            this.platformDescriptions.addItem((Object)desc.getId(), (Object)desc);
            return;
        }
        catch (XPointTools.XPointException xPointException) {}
    }

    @Override
    public Iterable<JaxbPlatformGroupDescription> getJaxbPlatformGroups() {
        return new SuperIterableWrapper((Iterable)this.platformGroupDescriptions.getItemSet());
    }

    @Override
    public JaxbPlatformGroupDescription getJaxbPlatformGroup(String groupId) {
        return (JaxbPlatformGroupDescription)this.platformGroupDescriptions.getItem((Object)groupId);
    }

    @Override
    public Iterable<JaxbPlatformDescription> getJaxbPlatforms() {
        return new SuperIterableWrapper((Iterable)this.platformDescriptions.getItemSet());
    }

    @Override
    public JaxbPlatformDescription getJaxbPlatform(String platformId) {
        return (JaxbPlatformDescription)this.platformDescriptions.getItem((Object)platformId);
    }

    @Override
    public JaxbPlatformDescription getDefaultJaxbPlatform(IProjectFacetVersion jaxbFacetVersion) {
        if (!jaxbFacetVersion.getProjectFacet().equals(JaxbFacet.FACET)) {
            throw new IllegalArgumentException(jaxbFacetVersion.toString());
        }
        for (JaxbPlatformDescription platform : this.getJaxbPlatforms()) {
            if (!platform.isDefault() || !platform.supportsJaxbFacetVersion(jaxbFacetVersion)) continue;
            return platform;
        }
        return null;
    }

    @Override
    public JaxbPlatformDefinition buildJaxbPlatformDefinition(IProject project) {
        String jaxbPlatformId = JptJaxbCorePlugin.getJaxbPlatformId(project);
        JaxbPlatformDescriptionImpl platformDesc = (JaxbPlatformDescriptionImpl)this.platformDescriptions.getItem((Object)jaxbPlatformId);
        if (platformDesc == null) {
            throw new IllegalArgumentException("Project does not have a recognized JAXB platform.");
        }
        return platformDesc.buildJaxbPlatformDefinition();
    }
}

