/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.ui.pages.impl;

import java.util.ArrayList;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.InputElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.Properties;
import org.eclipse.datatools.connectivity.oda.design.Property;
import org.eclipse.datatools.connectivity.oda.design.PropertyAttributes;
import org.eclipse.datatools.connectivity.oda.design.ScalarValueChoices;
import org.eclipse.datatools.connectivity.oda.design.ScalarValueDefinition;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.Messages;
import org.eclipse.datatools.connectivity.oda.design.ui.pages.impl.DefaultDataSourcePropertyPage;
import org.eclipse.datatools.connectivity.oda.design.ui.pages.impl.DefaultDataSourceWizardPage;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.datatools.connectivity.oda.util.manifest.PropertyChoice;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DefaultDataSourcePageHelper {
    public static final String DEFAULT_MESSAGE = Messages.ui_defaultDataSourceTitle;
    private static final String EMPTY_STRING = "";
    private static final String COLON_CHAR = ":";
    private static final String REQUIRED_FIELD_SYMBOL = " *";
    private DefaultDataSourceWizardPage m_wizardPage = null;
    private DefaultDataSourcePropertyPage m_propertyPage = null;
    private transient Control[] m_propCtrls = null;
    private ExtensionManifest m_manifest = null;
    private org.eclipse.datatools.connectivity.oda.util.manifest.Property[] m_extendedManifestProps = null;
    private org.eclipse.datatools.connectivity.oda.util.manifest.Property[] m_manifestProps = null;
    private java.util.Properties m_manifestPropsVisibility = null;
    private Properties m_dataSourceDesignProps = null;
    private ArrayList m_orderedPropNameList = null;

    protected DefaultDataSourcePageHelper(DefaultDataSourceWizardPage page) {
        assert (page != null);
        this.m_wizardPage = page;
        this.init();
    }

    protected DefaultDataSourcePageHelper(DefaultDataSourcePropertyPage page) {
        assert (page != null);
        this.m_propertyPage = page;
        this.init();
        DataSourceDesign dataSourceDesign = this.m_propertyPage.getCurrentDataSource();
        if (dataSourceDesign != null) {
            this.m_dataSourceDesignProps = dataSourceDesign.getPublicProperties();
        }
    }

    private void init() {
        this.m_manifestProps = this.getEditableManifestProperties();
        this.m_manifestPropsVisibility = this.getManifest().getPropertiesVisibility();
        this.m_extendedManifestProps = this.getManifest().getProperties(true);
    }

    protected org.eclipse.datatools.connectivity.oda.util.manifest.Property[] getEditableManifestProperties() {
        return this.getManifest().getProperties(false);
    }

    protected void createCustomControl(Composite parent) throws OdaException {
        final ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 2560);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        final Composite content = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)content);
        scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = scrolledComposite.getClientArea();
                scrolledComposite.setMinSize(content.computeSize(r.width, -1));
            }
        });
        this.setupPropFields(content);
    }

    protected java.util.Properties collectCustomProperties(java.util.Properties props) {
        if (props == null) {
            props = new java.util.Properties();
        }
        int i = 0;
        while (i < this.getPropCount()) {
            String propVal = EMPTY_STRING;
            if (this.m_propCtrls[i] instanceof Text) {
                propVal = ((Text)this.m_propCtrls[i]).getText();
            } else if (this.m_propCtrls[i] instanceof Combo) {
                int selectionIndex = ((Combo)this.m_propCtrls[i]).getSelectionIndex();
                if (selectionIndex != -1) {
                    propVal = this.getPropChoiceSelection(i, selectionIndex);
                } else {
                    assert (false);
                    propVal = EMPTY_STRING;
                }
            } else if (this.m_propCtrls[i] == null) {
                propVal = this.getPropDefaultValue(i);
            } else assert (false);
            if (propVal == null) {
                propVal = EMPTY_STRING;
            }
            String propName = this.getPropName(i);
            props.setProperty(propName, propVal);
            ++i;
        }
        return props;
    }

    protected int getPropCount() {
        return this.getOrderedPropNameList().size();
    }

    protected String getPropGroupName(int propIndex) {
        String propName = this.getPropName(propIndex);
        assert (propName != null);
        return this.getManifestPropGroupName(propName);
    }

    protected String getPropChoiceSelection(int propIndex, int choiceIndex) {
        String propName = this.getPropName(propIndex);
        assert (propName != null);
        String choiceName = this.getDesignPropChoiceSelection(propName, choiceIndex);
        if (choiceName != null) {
            return choiceName;
        }
        return this.getManifestPropChoiceSelection(propName, choiceIndex);
    }

    protected String getPropName(int propIndex) {
        return (String)this.getOrderedPropNameList().get(propIndex);
    }

    protected String getPropDisplayName(int propIndex) {
        String propName = this.getPropName(propIndex);
        assert (propName != null);
        String displayName = this.getDesignPropDisplayName(propName);
        if (displayName != null) {
            return displayName;
        }
        return this.getManifestPropDisplayName(propName);
    }

    protected String getPropDefaultValue(int propIndex) {
        String propName = this.getPropName(propIndex);
        assert (propName != null);
        String defaultVal = this.getDesignPropDefaultValue(propName);
        if (defaultVal != null) {
            return defaultVal;
        }
        return this.getManifestPropDefaultValue(propName);
    }

    protected Boolean isPropHidden(int propIndex) {
        String propName = this.getPropName(propIndex);
        assert (propName != null);
        return this.isManifestPropHidden(propName);
    }

    protected boolean isPropRequired(int propIndex) {
        String propName = this.getPropName(propIndex);
        assert (propName != null);
        Boolean boolObj = this.isDesignPropRequired(propName);
        if (boolObj != null) {
            return boolObj == false;
        }
        return false;
    }

    protected Boolean isPropReadOnly(int propIndex) {
        String propName = this.getPropName(propIndex);
        assert (propName != null);
        Boolean isEditable = this.isDesignPropReadOnly(propName);
        if (isEditable != null) {
            return isEditable;
        }
        return this.isManifestPropReadOnly(propName);
    }

    protected Boolean isPropEncryptable(int propIndex) {
        String propName = this.getPropName(propIndex);
        assert (propName != null);
        Boolean isEncryptable = this.isDesignPropEncryptable(propName);
        if (isEncryptable != null) {
            return isEncryptable;
        }
        return this.isManifestPropEncryptable(propName);
    }

    protected ArrayList getPropChoices(int propIndex) {
        String propName = this.getPropName(propIndex);
        assert (propName != null);
        ArrayList choiceLabelList = this.getDesignPropChoiceLabels(propName);
        if (choiceLabelList != null && choiceLabelList.size() > 0) {
            return choiceLabelList;
        }
        return this.getManifestPropChoiceLabels(propName);
    }

    protected Integer findPropChoiceIndex(int propIndex, String propVal) {
        String propName = this.getPropName(propIndex);
        assert (propName != null);
        Integer choiceIndex = this.findDesignPropChoiceIndex(propName, propVal);
        if (choiceIndex != null) {
            return choiceIndex;
        }
        return this.findManifestPropChoiceIndex(propName, propVal);
    }

    protected Property getDesignProperty(String propName) {
        if (this.m_dataSourceDesignProps == null) {
            return null;
        }
        return this.m_dataSourceDesignProps.findProperty(propName);
    }

    protected String getDesignPropDisplayName(String propName) {
        PropertyAttributes propAttrs = this.getDesignPropDesignAttrs(propName);
        if (propAttrs == null) {
            return null;
        }
        return propAttrs.getDisplayName();
    }

    protected PropertyAttributes getDesignPropDesignAttrs(String propName) {
        Property prop = this.getDesignProperty(propName);
        if (prop == null) {
            return null;
        }
        return prop.getDesignAttributes();
    }

    protected InputElementAttributes getDesignPropElementAttrs(String propName) {
        PropertyAttributes propAttrs = this.getDesignPropDesignAttrs(propName);
        if (propAttrs == null) {
            return null;
        }
        return propAttrs.getElementAttributes();
    }

    protected String getDesignPropDefaultValue(String propName) {
        InputElementAttributes inputElemAttrs = this.getDesignPropElementAttrs(propName);
        if (inputElemAttrs == null) {
            return null;
        }
        return inputElemAttrs.getDefaultScalarValue();
    }

    protected Boolean isDesignPropReadOnly(String propName) {
        InputElementAttributes inputElemAttrs = this.getDesignPropElementAttrs(propName);
        if (inputElemAttrs == null) {
            return null;
        }
        if (inputElemAttrs.isSetEditable()) {
            return new Boolean(!inputElemAttrs.isEditable());
        }
        return null;
    }

    protected Boolean isDesignPropRequired(String propName) {
        InputElementAttributes inputElemAttrs = this.getDesignPropElementAttrs(propName);
        if (inputElemAttrs == null) {
            return null;
        }
        if (inputElemAttrs.isSetOptional()) {
            return new Boolean(inputElemAttrs.isOptional());
        }
        return null;
    }

    protected Boolean isDesignPropEncryptable(String propName) {
        InputElementAttributes inputElemAttrs = this.getDesignPropElementAttrs(propName);
        if (inputElemAttrs == null) {
            return null;
        }
        if (inputElemAttrs.isSetMasksValue()) {
            return new Boolean(inputElemAttrs.isMasksValue());
        }
        return null;
    }

    protected EList getDesignPropChoices(String propName) {
        InputElementAttributes inputElemAttrs = this.getDesignPropElementAttrs(propName);
        if (inputElemAttrs == null) {
            return null;
        }
        ScalarValueChoices scalarValueChoices = inputElemAttrs.getStaticValueChoices();
        if (scalarValueChoices == null) {
            return null;
        }
        return scalarValueChoices.getScalarValues();
    }

    protected ArrayList getDesignPropChoiceLabels(String propName) {
        EList choiceList = this.getDesignPropChoices(propName);
        if (choiceList == null || choiceList.size() == 0) {
            return null;
        }
        ArrayList<String> choiceLabelList = new ArrayList<String>();
        int i = 0;
        while (i < choiceList.size()) {
            ScalarValueDefinition scalarValueDefn = (ScalarValueDefinition)choiceList.get(i);
            String label = scalarValueDefn.getDisplayName();
            if (this.isEmpty(label)) {
                label = scalarValueDefn.getValue();
            }
            choiceLabelList.add(label);
            ++i;
        }
        return choiceLabelList;
    }

    protected String getDesignPropChoiceSelection(String propName, int choiceIndex) {
        EList choiceList = this.getDesignPropChoices(propName);
        if (choiceList == null || choiceList.size() == 0) {
            return null;
        }
        ScalarValueDefinition scalarValueDefn = (ScalarValueDefinition)choiceList.get(choiceIndex);
        assert (scalarValueDefn != null);
        return scalarValueDefn.getValue();
    }

    protected Integer findDesignPropChoiceIndex(String propName, String propVal) {
        EList choiceList = this.getDesignPropChoices(propName);
        if (choiceList == null || choiceList.size() == 0) {
            return null;
        }
        int i = 0;
        while (i < choiceList.size()) {
            ScalarValueDefinition scalarValueDefn = (ScalarValueDefinition)choiceList.get(i);
            if (propVal.equals(scalarValueDefn.getValue())) {
                return new Integer(i);
            }
            ++i;
        }
        return new Integer(-1);
    }

    protected void validatePropertyFields() {
        int i = 0;
        while (i < this.getPropCount()) {
            String propVal = null;
            if (this.m_propCtrls[i] instanceof Text) {
                propVal = ((Text)this.m_propCtrls[i]).getText();
            } else if (this.m_propCtrls[i] instanceof Combo) {
                int index = ((Combo)this.m_propCtrls[i]).getSelectionIndex();
                propVal = index == -1 ? EMPTY_STRING : this.getPropChoiceSelection(i, index);
            } else if (this.m_propCtrls[i] == null) {
                propVal = this.getPropDefaultValue(i);
            } else assert (false);
            if (this.isPropRequired(i) && this.isEmpty(propVal)) {
                this.setMessage(Messages.ui_requiredFieldsMissingValue, 2);
                return;
            }
            ++i;
        }
        this.setMessage(DEFAULT_MESSAGE, 0);
    }

    protected void initCustomControl(java.util.Properties profileProps) {
        int i = 0;
        while (i < this.getPropCount()) {
            String propVal = EMPTY_STRING;
            if (profileProps != null) {
                propVal = profileProps.getProperty(this.getPropName(i));
            }
            this.setPropertyControlValue(i, propVal);
            ++i;
        }
        this.validatePropertyFields();
    }

    protected ArrayList getOrderedPropNameList() {
        if (this.m_orderedPropNameList != null) {
            return this.m_orderedPropNameList;
        }
        ArrayList<String> orderedPropNameList = new ArrayList<String>();
        if (this.m_dataSourceDesignProps != null) {
            Property prop;
            EList propList = this.m_dataSourceDesignProps.getProperties();
            int i = 0;
            while (i < propList.size()) {
                prop = (Property)propList.get(i);
                if (this.getExtendedManifestProp(prop.getName()) == null) {
                    orderedPropNameList.add(prop.getName());
                }
                ++i;
            }
            i = 0;
            while (i < this.m_manifestProps.length) {
                prop = this.m_manifestProps[i];
                assert (prop != null);
                String propName = prop.getName();
                if (this.getDesignProperty(propName) != null) {
                    orderedPropNameList.add(propName);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.m_manifestProps.length) {
                org.eclipse.datatools.connectivity.oda.util.manifest.Property prop = this.m_manifestProps[i];
                assert (prop != null);
                orderedPropNameList.add(prop.getName());
                ++i;
            }
        }
        this.m_orderedPropNameList = orderedPropNameList;
        return this.m_orderedPropNameList;
    }

    protected void setupPropFields(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        composite.setLayout((Layout)layout);
        this.m_propCtrls = new Control[this.getPropCount()];
        String curGroupName = null;
        Composite curCtrlParent = null;
        int i = 0;
        while (i < this.getPropCount()) {
            Boolean isHidden = this.isPropHidden(i);
            if (isHidden == null || !isHidden.booleanValue()) {
                String propGroupName = this.getPropGroupName(i);
                if (this.isEmpty(propGroupName)) {
                    curCtrlParent = composite;
                    curGroupName = null;
                } else if (!this.hasSameGroup(propGroupName, curGroupName)) {
                    String propName = this.getPropName(i);
                    assert (propName != null);
                    curCtrlParent = this.createGroupControl(composite, this.getManifestPropGroupDisplayName(propName));
                    GridData data = new GridData(768);
                    data.horizontalSpan = 5;
                    curCtrlParent.setLayoutData((Object)data);
                    curGroupName = propGroupName;
                }
                this.setUpPropertyLabelAndControl(curCtrlParent, i);
            }
            ++i;
        }
        this.setPageComplete(true);
    }

    protected void setUpPropertyLabelAndControl(Composite parent, int propIndex) {
        assert (parent != null);
        this.createPropertyLabel(parent, propIndex);
        this.m_propCtrls[propIndex] = this.createPropertyControl(parent, propIndex);
        GridData data = new GridData(768);
        data.horizontalSpan = 4;
        this.m_propCtrls[propIndex].setLayoutData((Object)data);
    }

    protected Group createGroupControl(Composite parent, String groupName) {
        Group groupCtrl = new Group(parent, 0);
        groupCtrl.setLayout((Layout)new GridLayout());
        groupCtrl.setText(groupName);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        groupCtrl.setLayout((Layout)layout);
        return groupCtrl;
    }

    protected boolean isEmpty(String name) {
        return name == null || name.length() == 0;
    }

    protected boolean hasSameGroup(String propGroupName, String curGroupName) {
        if (this.isEmpty(propGroupName) != this.isEmpty(curGroupName)) {
            return false;
        }
        if (this.isEmpty(propGroupName) && this.isEmpty(curGroupName)) {
            return true;
        }
        return propGroupName.equals(curGroupName);
    }

    private org.eclipse.datatools.connectivity.oda.util.manifest.Property getExtendedManifestProp(String propName) {
        return this.getManifestProp(this.m_extendedManifestProps, propName);
    }

    protected org.eclipse.datatools.connectivity.oda.util.manifest.Property getManifestProp(String propName) {
        return this.getManifestProp(this.m_manifestProps, propName);
    }

    private org.eclipse.datatools.connectivity.oda.util.manifest.Property getManifestProp(org.eclipse.datatools.connectivity.oda.util.manifest.Property[] properties, String propName) {
        if (properties == null) {
            return null;
        }
        int i = 0;
        while (i < properties.length) {
            if (properties[i].getName().equals(propName)) {
                return properties[i];
            }
            ++i;
        }
        return null;
    }

    protected String getManifestPropDefaultValue(String propName) {
        org.eclipse.datatools.connectivity.oda.util.manifest.Property prop = this.getManifestProp(propName);
        if (prop == null) {
            return null;
        }
        return prop.getDefaultValue();
    }

    protected String getManifestPropDisplayName(String propName) {
        org.eclipse.datatools.connectivity.oda.util.manifest.Property prop = this.getManifestProp(propName);
        if (prop == null) {
            return null;
        }
        return prop.getDisplayName();
    }

    protected String getManifestPropGroupName(String propName) {
        org.eclipse.datatools.connectivity.oda.util.manifest.Property prop = this.getManifestProp(propName);
        if (prop == null) {
            return null;
        }
        return prop.getGroupName();
    }

    protected String getManifestPropGroupDisplayName(String propName) {
        org.eclipse.datatools.connectivity.oda.util.manifest.Property prop = this.getManifestProp(propName);
        if (prop == null) {
            return null;
        }
        return prop.getGroupDisplayName();
    }

    protected String getManifestPropChoiceSelection(String propName, int choiceIndex) {
        org.eclipse.datatools.connectivity.oda.util.manifest.Property prop = this.getManifestProp(propName);
        if (prop == null) {
            return null;
        }
        PropertyChoice[] choices = prop.getChoices();
        PropertyChoice choice = choices[choiceIndex];
        assert (choice != null);
        return choice.getName();
    }

    protected Boolean isManifestPropHidden(String propName) {
        org.eclipse.datatools.connectivity.oda.util.manifest.Property prop = this.getManifestProp(propName);
        if (prop == null) {
            return null;
        }
        boolean boolVal = !prop.isVisible(this.m_manifestPropsVisibility);
        return new Boolean(boolVal);
    }

    protected Boolean isManifestPropReadOnly(String propName) {
        org.eclipse.datatools.connectivity.oda.util.manifest.Property prop = this.getManifestProp(propName);
        if (prop == null) {
            return null;
        }
        boolean boolVal = !prop.isEditable(this.m_manifestPropsVisibility);
        return new Boolean(boolVal);
    }

    protected Boolean isManifestPropEncryptable(String propName) {
        org.eclipse.datatools.connectivity.oda.util.manifest.Property prop = this.getManifestProp(propName);
        if (prop == null) {
            return null;
        }
        return new Boolean(prop.isEncryptable());
    }

    protected PropertyChoice[] getManifestPropChoices(String propName) {
        org.eclipse.datatools.connectivity.oda.util.manifest.Property prop = this.getManifestProp(propName);
        if (prop == null) {
            return null;
        }
        return prop.getChoices();
    }

    protected Integer findManifestPropChoiceIndex(String propName, String propVal) {
        PropertyChoice[] choices = this.getManifestPropChoices(propName);
        if (choices == null || choices.length == 0) {
            return null;
        }
        int j = 0;
        while (j < choices.length) {
            if (choices[j].getName().equals(propVal)) {
                return new Integer(j);
            }
            ++j;
        }
        return new Integer(-1);
    }

    protected ArrayList getManifestPropChoiceLabels(String propName) {
        PropertyChoice[] choices = this.getManifestPropChoices(propName);
        if (choices == null || choices.length == 0) {
            return null;
        }
        ArrayList<String> choiceLabelList = new ArrayList<String>();
        int j = 0;
        while (j < choices.length) {
            String label = choices[j].getDisplayName();
            if (this.isEmpty(label)) {
                label = choices[j].getName();
            }
            choiceLabelList.add(label);
            ++j;
        }
        return choiceLabelList;
    }

    protected void createPropertyLabel(Composite composite, int propIndex) {
        Label labelCtrl = new Label(composite, 0);
        String displayName = this.getPropDisplayName(propIndex);
        if (this.isEmpty(displayName)) {
            displayName = this.getPropName(propIndex);
        }
        String displayText = String.valueOf(displayName) + COLON_CHAR;
        if (this.isPropRequired(propIndex)) {
            displayText = String.valueOf(displayText) + REQUIRED_FIELD_SYMBOL;
        }
        labelCtrl.setText(displayText);
    }

    protected Control createPropertyControl(Composite composite, int propIndex) {
        Text propCtrl = null;
        int style = 2048;
        ArrayList choiceLabelList = this.getPropChoices(propIndex);
        if (choiceLabelList != null && choiceLabelList.size() > 0) {
            Combo choiceCombo = new Combo(composite, style | 4 | 8);
            int j = 0;
            while (j < choiceLabelList.size()) {
                String label = (String)choiceLabelList.get(j);
                assert (!this.isEmpty(label));
                choiceCombo.add(label);
                ++j;
            }
            Boolean isReadOnly = this.isPropReadOnly(propIndex);
            choiceCombo.setEnabled(isReadOnly != null && isReadOnly == false);
            propCtrl = choiceCombo;
        } else {
            Text textCtrl;
            Boolean isEncryptable;
            Boolean isReadOnly = this.isPropReadOnly(propIndex);
            if (isReadOnly != null && isReadOnly.booleanValue()) {
                style |= 8;
            }
            if ((isEncryptable = this.isPropEncryptable(propIndex)) != null && isEncryptable.booleanValue()) {
                style |= 0x400000;
            }
            propCtrl = textCtrl = new Text(composite, style | 4);
        }
        if (propCtrl instanceof Combo) {
            ((Combo)propCtrl).addModifyListener(this.createModifyListener());
        } else if (propCtrl instanceof Text) {
            propCtrl.addModifyListener(this.createModifyListener());
        } else assert (false);
        return propCtrl;
    }

    protected ModifyListener createModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DefaultDataSourcePageHelper.this.validatePropertyFields();
            }
        };
    }

    protected void setPropertyControlValue(int propIndex, String propertyVal) {
        String propVal;
        Control propCtrl = this.m_propCtrls[propIndex];
        String propName = this.getPropName(propIndex);
        assert (propName != null);
        Boolean isHidden = this.isManifestPropHidden(propName);
        if (isHidden != null && isHidden.booleanValue()) {
            return;
        }
        String string = propVal = propertyVal == null ? EMPTY_STRING : propertyVal;
        if (propVal.length() == 0 && (propVal = this.getPropDefaultValue(propIndex)) == null) {
            propVal = EMPTY_STRING;
        }
        if (propCtrl instanceof Text) {
            ((Text)propCtrl).setText(propVal);
        } else if (propCtrl instanceof Combo) {
            Combo choiceCombo = (Combo)propCtrl;
            Integer choiceIndex = this.findPropChoiceIndex(propIndex, propVal);
            if (choiceIndex != null) {
                choiceCombo.select(choiceIndex.intValue());
            } else {
                choiceCombo.select(0);
            }
        } else assert (false);
    }

    protected void setPageComplete(boolean complete) {
        if (this.m_wizardPage != null) {
            this.m_wizardPage.setPageComplete(complete);
        } else if (this.m_propertyPage != null) {
            this.m_propertyPage.setValid(complete);
        }
    }

    protected void setMessage(String newMessage, int newType) {
        if (this.m_wizardPage != null) {
            this.m_wizardPage.setMessage(newMessage, newType);
        } else if (this.m_propertyPage != null) {
            this.m_propertyPage.setMessage(newMessage, newType);
        }
    }

    protected ExtensionManifest getManifest() {
        if (this.m_manifest == null) {
            String dsId = null;
            if (this.m_wizardPage != null) {
                dsId = this.m_wizardPage.getOdaDataSourceId();
            } else if (this.m_propertyPage != null) {
                dsId = this.m_propertyPage.getOdaDataSourceId();
            } else {
                assert (false);
                return null;
            }
            try {
                this.m_manifest = ManifestExplorer.getInstance().getExtensionManifest(dsId);
            }
            catch (OdaException odaException) {
                assert (false);
                return null;
            }
        }
        return this.m_manifest;
    }
}

