/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Member;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source.SourceEclipseLinkNamedConverterAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkConverterAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceEclipseLinkConverterAnnotation
extends SourceEclipseLinkNamedConverterAnnotation
implements EclipseLinkConverterAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.Converter");
    private static final DeclarationAnnotationElementAdapter<String> CONVERTER_CLASS_ADAPTER = SourceEclipseLinkConverterAnnotation.buildConverterClassAdapter();
    private final AnnotationElementAdapter<String> converterClassAdapter;
    private String converterClass;
    private String fullyQualifiedConverterClassName;
    private boolean fqConverterClassNameStale = true;

    public SourceEclipseLinkConverterAnnotation(JavaResourcePersistentMember parent, Member member) {
        super((JavaResourceNode)parent, member, DECLARATION_ANNOTATION_ADAPTER);
        this.converterClassAdapter = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)member, CONVERTER_CLASS_ADAPTER);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.Converter";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.converterClass = this.buildConverterClass(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncConverterClass(this.buildConverterClass(astRoot));
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.converterClass == null;
    }

    @Override
    String getNameElementName() {
        return "name";
    }

    @Override
    public String getConverterClass() {
        return this.converterClass;
    }

    @Override
    public void setConverterClass(String converterClass) {
        if (this.attributeValueHasChanged(this.converterClass, converterClass)) {
            this.converterClass = converterClass;
            this.fqConverterClassNameStale = true;
            this.converterClassAdapter.setValue((Object)converterClass);
        }
    }

    private void syncConverterClass(String astConverterClass) {
        if (this.attributeValueHasChanged(this.converterClass, astConverterClass)) {
            this.syncConverterClass_(astConverterClass);
        }
    }

    private void syncConverterClass_(String astConverterClass) {
        String old = this.converterClass;
        this.converterClass = astConverterClass;
        this.fqConverterClassNameStale = true;
        this.firePropertyChanged("converterClass", old, astConverterClass);
    }

    private String buildConverterClass(CompilationUnit astRoot) {
        return (String)this.converterClassAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getConverterClassTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(CONVERTER_CLASS_ADAPTER, astRoot);
    }

    @Override
    public boolean converterClassImplementsInterface(String interfaceName, CompilationUnit astRoot) {
        return this.converterClass != null && ASTTools.typeImplementsInterface((Expression)this.converterClassAdapter.getExpression(astRoot), (String)interfaceName);
    }

    @Override
    public String getFullyQualifiedConverterClassName() {
        if (this.fqConverterClassNameStale) {
            this.fullyQualifiedConverterClassName = this.buildFullyQualifiedConverterClassName();
            this.fqConverterClassNameStale = false;
        }
        return this.fullyQualifiedConverterClassName;
    }

    private String buildFullyQualifiedConverterClassName() {
        return this.converterClass == null ? null : this.buildFullyQualifiedConverterClassName_();
    }

    private String buildFullyQualifiedConverterClassName_() {
        return ASTTools.resolveFullyQualifiedName((Expression)this.converterClassAdapter.getExpression(this.buildASTRoot()));
    }

    private static DeclarationAnnotationElementAdapter<String> buildConverterClassAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "converterClass", SimpleTypeStringExpressionConverter.instance());
    }
}

