/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.utilities.os;

import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import cz.vity.freerapid.utilities.os.OSCommand;
import cz.vity.freerapid.utilities.os.SysCommand;
import cz.vity.freerapid.utilities.os.SystemCommander;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

final class NirCmdUtils
implements SystemCommander {
    private static final Logger logger = Logger.getLogger(NirCmdUtils.class.getName());
    private static final String PATH = "tools/nircmd/nircmd.exe";

    NirCmdUtils() {
    }

    private boolean createDesktopShortcut() {
        return this.createShortCut("FreeRapid 0.83u1", "", "~$folder.desktop$", "");
    }

    private boolean createStartMenuShortcut() {
        return this.createShortCut("FreeRapid 0.83u1", "", "~$folder.programs$", "");
    }

    private boolean createStartupShortcut() {
        return this.createShortCut("FreeRapid 0.83u1", "-m", "~$folder.startup$", "\"\" \"min\"");
    }

    private boolean createQuickLaunchShortcut() {
        return this.createShortCut("FreeRapid 0.83u1", "", "~$folder.appdata$\\Microsoft\\Internet Explorer\\Quick Launch", "");
    }

    private boolean startNewApplicationInstance() {
        String string;
        if (!System.getProperties().containsKey("exePath")) {
            String string2 = Utils.getAppPath();
            String string3 = Utils.addFileSeparator(string2);
            string = string3 + "frd.exe";
        } else {
            string = System.getProperty("exePath");
        }
        return NirCmdUtils.run(string + " " + Utils.getApplicationArguments(), false);
    }

    private boolean createShortCut(String string, String string2, String string3, String string4) {
        String string5 = Utils.getAppPath();
        String string6 = Utils.addFileSeparator(string5);
        String string7 = string6 + "frd.exe";
        String string8 = string6 + "frd.ico";
        String string9 = String.format("shortcut \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" %s", string7, string3, string, string2, string8, string4);
        return NirCmdUtils.runCommand(string9, true);
    }

    @Override
    public boolean createShortCut(OSCommand oSCommand) {
        if (!OSCommand.shortCutCommands.contains((Object)oSCommand)) {
            throw new IllegalArgumentException("OS command " + (Object)((Object)oSCommand) + " is not a shortcut command");
        }
        switch (oSCommand) {
            case CREATE_DESKTOP_SHORTCUT: {
                return this.createDesktopShortcut();
            }
            case CREATE_QUICKLAUNCH_SHORTCUT: {
                return this.createQuickLaunchShortcut();
            }
            case CREATE_STARTMENU_SHORTCUT: {
                return this.createStartMenuShortcut();
            }
            case CREATE_STARTUP_SHORTCUT: {
                return this.createStartupShortcut();
            }
        }
        assert (false);
        return false;
    }

    @Override
    public boolean shutDown(OSCommand oSCommand, boolean bl) {
        if (!OSCommand.shutDownCommands.contains((Object)oSCommand)) {
            throw new IllegalArgumentException("OS command " + (Object)((Object)oSCommand) + " is not a shut down command");
        }
        if (oSCommand == OSCommand.RESTART_APPLICATION) {
            return this.startNewApplicationInstance();
        }
        String string = "";
        switch (oSCommand) {
            case HIBERNATE: {
                string = "hibernate";
                break;
            }
            case STANDBY: {
                string = "standby";
                break;
            }
            case REBOOT: {
                string = "exitwin reboot";
                break;
            }
            case SHUTDOWN: {
                string = "exitwin shutdown";
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (bl) {
            string = string + " force";
        }
        return NirCmdUtils.runCommand("cmdwait 2200 " + string, false);
    }

    @Override
    public boolean isSupported(OSCommand oSCommand) {
        return true;
    }

    private static boolean runCommand(String string, boolean bl) {
        String string2 = Utils.addFileSeparator(Utils.getAppPath()) + PATH;
        return NirCmdUtils.run("\"" + new File(string2).getPath() + "\" " + string, bl);
    }

    private static boolean run(String string, boolean bl) {
        if (!Utils.isWindows()) {
            return true;
        }
        logger.info("System command:" + string);
        try {
            Process process = Runtime.getRuntime().exec(SysCommand.splitCommand(string));
            if (bl) {
                process.waitFor();
                return process.exitValue() == 0;
            }
            return true;
        }
        catch (IOException iOException) {
            logger.warning("Command:" + string + " failed from some reason");
            LogUtils.processException(logger, iOException);
            return false;
        }
        catch (InterruptedException interruptedException) {
            LogUtils.processException(logger, interruptedException);
            return false;
        }
    }
}

