/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.utilities;

import cz.vity.freerapid.core.MainApp;
import java.applet.Applet;
import java.applet.AudioClip;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.jdesktop.application.ResourceManager;
import org.jdesktop.application.ResourceMap;

public class Sound {
    private static final Logger logger = Logger.getLogger(Sound.class.getName());
    private static final Map<String, AudioClip> clipsMap = new HashMap<String, AudioClip>(1);

    private Sound() {
    }

    private static void playSound(AudioClip audioClip) {
        if (audioClip != null) {
            audioClip.play();
        }
    }

    private static AudioClip getCachedAudioClip(String string) {
        if (!clipsMap.containsKey(string)) {
            AudioClip audioClip = Sound.getAudioClip(string);
            if (audioClip != null) {
                clipsMap.put(string, audioClip);
            }
            return audioClip;
        }
        return clipsMap.get(string);
    }

    private static AudioClip getAudioClip(String string) {
        ResourceManager resourceManager = MainApp.getAContext().getResourceManager();
        ResourceMap resourceMap = resourceManager.getResourceMap();
        String string2 = resourceMap.getResourcesDir() + "sound" + "/" + string;
        URL uRL = resourceMap.getClassLoader().getResource(string2);
        if (uRL == null) {
            return null;
        }
        return Applet.newAudioClip(uRL);
    }

    public static AudioClip playSound(String string) {
        AudioClip audioClip = Sound.getCachedAudioClip(string);
        if (audioClip == null) {
            logger.warning("Audioclip " + string + " was not found probably.");
        }
        Sound.playSound(audioClip);
        return audioClip;
    }

    public static void playSound(File file) throws MalformedURLException {
        AudioClip audioClip = Applet.newAudioClip(file.toURI().toURL());
        Sound.playSound(audioClip);
    }
}

