/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.swing;

import cz.vity.freerapid.core.application.SubmitErrorReporter;
import cz.vity.freerapid.gui.dialogs.ErrorDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceManager;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorReporter;

public class Swinger {
    private static final Logger logger = Logger.getLogger(Swinger.class.getName());
    private static final String MESSAGE_ERROR_TITLE_CODE = "errorMessage";
    private static final String MESSAGE_CONFIRM_TITLE_CODE = "confirmMessage";
    private static final String MESSAGE_INFORMATION_TITLE_CODE = "informationMessage";
    private static final String MESSAGE_BTN_YES_CODE = "message.button.yes";
    private static final String MESSAGE_BTN_NO_CODE = "message.button.no";
    private static final String MESSAGE_BTN_OK_CODE = "message.button.ok";
    public static final String MESSAGE_BTN_CANCEL_CODE = "message.button.cancel";
    public static final int RESULT_NO = 1;
    public static final int RESULT_YES = 0;
    public static final int RESULT_CANCEL = 1;
    public static final int RESULT_OK = 0;

    private Swinger() {
    }

    public static void initActions(Object object, ApplicationContext applicationContext) {
        ApplicationActionMap applicationActionMap = applicationContext.getActionMap();
        ApplicationActionMap applicationActionMap2 = applicationContext.getActionMap(object);
        for (Object object2 : applicationActionMap2.keys()) {
            applicationActionMap.put(object2, applicationActionMap2.get(object2));
        }
    }

    public static void showInformationDialog(String string) {
        JOptionPane.showMessageDialog(Swinger.getActiveWindowComponent(), string, Swinger.getResourceMap().getString(MESSAGE_INFORMATION_TITLE_CODE, new Object[0]), 1);
    }

    public static int getChoiceYesNoCancel(String string) {
        ResourceMap resourceMap = Swinger.getResourceMap();
        return JOptionPane.showOptionDialog(Swinger.getActiveWindowComponent(), string, resourceMap.getString(MESSAGE_CONFIRM_TITLE_CODE, new Object[0]), 0, 3, null, new Object[]{resourceMap.getString(MESSAGE_BTN_YES_CODE, new Object[0]), resourceMap.getString(MESSAGE_BTN_NO_CODE, new Object[0]), resourceMap.getString(MESSAGE_BTN_CANCEL_CODE, new Object[0])}, resourceMap.getString(MESSAGE_BTN_YES_CODE, new Object[0]));
    }

    public static int getChoiceYesNoCancel(String string, Object ... objectArray) {
        ResourceMap resourceMap = Swinger.getResourceMap();
        return Swinger.getChoiceYesNoCancel(resourceMap.getString(string, objectArray));
    }

    public static int getChoiceOKCancel(String string, Object ... objectArray) {
        ResourceMap resourceMap = Swinger.getResourceMap();
        return JOptionPane.showOptionDialog(Swinger.getActiveWindowComponent(), resourceMap.getString(string, objectArray), resourceMap.getString(MESSAGE_CONFIRM_TITLE_CODE, new Object[0]), 2, 3, null, new Object[]{resourceMap.getString(MESSAGE_BTN_OK_CODE, new Object[0]), resourceMap.getString(MESSAGE_BTN_CANCEL_CODE, new Object[0])}, resourceMap.getString(MESSAGE_BTN_OK_CODE, new Object[0]));
    }

    public static ImageIcon getIconImage(String string) {
        ResourceMap resourceMap = Swinger.getResourceMap();
        return Swinger.getIconImage(resourceMap, string);
    }

    public static ImageIcon getIconImage(ResourceMap resourceMap, String string) {
        ImageIcon imageIcon = resourceMap.getImageIcon(string);
        if (imageIcon == null) {
            logger.warning("Invalid image property code:" + string);
        }
        return imageIcon;
    }

    public static ResourceMap getResourceMap() {
        return Swinger.getContext().getResourceManager().getResourceMap();
    }

    public static ResourceMap getResourceMap(Class clazz) {
        ResourceManager resourceManager = Swinger.getContext().getResourceManager();
        return resourceManager.getResourceMap(clazz);
    }

    public static ResourceMap getResourceMap(Class clazz, Class clazz2) {
        ResourceManager resourceManager = Swinger.getContext().getResourceManager();
        return resourceManager.getResourceMap(clazz, clazz2);
    }

    public static Action getAction(Object object) {
        Action action = Swinger.getContext().getActionMap().get(object);
        if (action == null) {
            throw new IllegalStateException("Action with a name \"" + object + "\" does not exist.");
        }
        return action;
    }

    public static ActionMap getActionMap(Class clazz, Object object) {
        return Swinger.getContext().getActionMap(clazz, object);
    }

    private static ApplicationContext getContext() {
        return Application.getInstance().getContext();
    }

    public static ActionMap getActionMap(Object object) {
        return Swinger.getContext().getActionMap(object);
    }

    public static void showErrorMessage(ResourceMap resourceMap, String string, Object ... objectArray) {
        JOptionPane.showMessageDialog(Swinger.getActiveWindowComponent(), resourceMap.containsKey(string) ? resourceMap.getString(string, objectArray) : string, Swinger.getResourceMap().getString(MESSAGE_ERROR_TITLE_CODE, new Object[0]), 0);
    }

    public static void showErrorMessage(ResourceMap resourceMap, Throwable throwable) {
        JOptionPane.showMessageDialog(Swinger.getActiveWindowComponent(), Swinger.getMessageFromException(resourceMap, throwable), Swinger.getResourceMap().getString(MESSAGE_ERROR_TITLE_CODE, new Object[0]), 0);
    }

    public static int showOptionDialog(ResourceMap resourceMap, int n, String string, String string2, String[] stringArray, Object ... objectArray) {
        ResourceMap resourceMap2 = Swinger.getResourceMap();
        Object[] objectArray2 = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = resourceMap.getString(stringArray[i], new Object[0]);
            assert (string3 != null);
            objectArray2[i] = string3;
        }
        Frame frame = Swinger.getActiveFrame();
        Swinger.bringToFront(frame, true);
        Toolkit.getDefaultToolkit().beep();
        return JOptionPane.showOptionDialog(Swinger.getActiveWindowComponent(), resourceMap.getString(string2, objectArray), resourceMap2.getString(string, new Object[0]), 1, n, null, objectArray2, objectArray2[0]);
    }

    public static int showInputDialog(String string, Object object, boolean bl) {
        ResourceMap resourceMap = Swinger.getResourceMap();
        String[] stringArray = bl ? new String[]{MESSAGE_BTN_OK_CODE, MESSAGE_BTN_CANCEL_CODE} : new String[]{MESSAGE_BTN_OK_CODE};
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = resourceMap.getString(stringArray[i], new Object[0]);
            assert (string2 != null);
            objectArray[i] = string2;
        }
        Frame frame = Swinger.getActiveFrame();
        Swinger.bringToFront(frame, true);
        return JOptionPane.showOptionDialog(frame, object, string, 1, -1, null, objectArray, objectArray[0]);
    }

    public static void bringToFront(Frame frame, boolean bl) {
        if (frame != null) {
            int n = frame.getExtendedState();
            if ((n & 1) == 1) {
                frame.setExtendedState(n &= 0xFFFFFFFE);
            }
            frame.setVisible(true);
            if (bl) {
                frame.toFront();
            }
        }
    }

    public static void showMessage(ResourceMap resourceMap, String string, Object ... objectArray) {
        JOptionPane.showMessageDialog(Swinger.getActiveFrame(), resourceMap.getString(string, objectArray), Swinger.getResourceMap().getString(MESSAGE_ERROR_TITLE_CODE, objectArray), 0);
    }

    public static void inputFocus(JComboBox jComboBox) {
        Swinger.inputFocus((JComponent)jComboBox.getEditor().getEditorComponent());
    }

    public static void inputFocus(final JComponent jComponent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jComponent.grabFocus();
                jComponent.requestFocus();
            }
        });
    }

    public static TableColumn updateColumn(JTable jTable, String string, int n, int n2, int n3, TableCellRenderer tableCellRenderer) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        tableColumn.setIdentifier(string);
        if (tableCellRenderer != null) {
            tableColumn.setCellRenderer(tableCellRenderer);
        }
        if (n3 != -1) {
            tableColumn.setPreferredWidth(n3);
        }
        if (n2 != -1) {
            tableColumn.setMinWidth(n3);
        }
        return tableColumn;
    }

    public static TableColumn updateColumn(JTable jTable, String string, int n, int n2) {
        return Swinger.updateColumn(jTable, string, n, n2, n2, null);
    }

    public static void showErrorDialog(Class clazz, String string, Throwable throwable, boolean bl) {
        Swinger.showErrorDialog(Swinger.getResourceMap(clazz), string, throwable, bl);
    }

    public static void showErrorDialog(Class clazz, String string, Throwable throwable) {
        Swinger.showErrorDialog(Swinger.getResourceMap(clazz), string, throwable, false);
    }

    public static void showErrorDialog(String string, Throwable throwable, boolean bl) {
        Swinger.showErrorDialog(ErrorDialog.class, string, throwable, bl);
    }

    public static void showErrorDialog(String string, Throwable throwable) {
        Swinger.showErrorDialog(ErrorDialog.class, string, throwable, false);
    }

    public static void showErrorDialog(ResourceMap resourceMap, String string, Throwable throwable) {
        Swinger.showErrorDialog(resourceMap, string, throwable, false);
    }

    private static void showErrorDialog(ResourceMap resourceMap, String string, Throwable throwable, boolean bl) {
        if (resourceMap == null) {
            throw new IllegalArgumentException("Map cannot be null");
        }
        String string2 = throwable.getLocalizedMessage();
        if (string2 == null) {
            string2 = "";
        }
        String string3 = resourceMap.getString(string, string2);
        Swinger.showErrorDialog(string3, false, throwable, bl);
    }

    private static void showErrorDialog(String string, boolean bl, Throwable throwable, boolean bl2) {
        ResourceMap resourceMap = Swinger.getResourceMap();
        ErrorInfo errorInfo = new ErrorInfo(resourceMap.getString(MESSAGE_ERROR_TITLE_CODE, new Object[0]), bl ? resourceMap.getString(string, new Object[0]) : string, null, "EDT Thread", throwable, Level.SEVERE, null);
        JXErrorPane jXErrorPane = new JXErrorPane();
        if (bl2) {
            jXErrorPane.setErrorReporter((ErrorReporter)new SubmitErrorReporter());
        }
        jXErrorPane.setErrorInfo(errorInfo);
        JXErrorPane.showDialog((Component)Swinger.getActiveFrame(), (JXErrorPane)jXErrorPane);
    }

    public static Component getActiveWindowComponent() {
        Window window = Swinger.getActiveDialog();
        if (window == null) {
            return Swinger.getActiveFrame();
        }
        return window;
    }

    public static JComponent getTitleComponent(String string) {
        return Swinger.getTitleComponent(new JLabel(string));
    }

    public static JComponent getTitleComponent2(String string) {
        JLabel jLabel = new JLabel();
        jLabel.setName(string);
        jLabel.setFont(jLabel.getFont().deriveFont(1, 16.0f));
        return Swinger.getTitleComponent(jLabel);
    }

    private static JComponent getTitleComponent(JLabel jLabel) {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setLayout(new GridBagLayout());
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(false);
        jToolBar.setOpaque(false);
        jToolBar.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 2, 0.0, 1.0, 17, 0, new Insets(0, 4, 0, 2), 0, 0));
        jToolBar.add((Component)new JSeparator(0), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(4, 0, 0, 0), 0, 0));
        return jToolBar;
    }

    public static int getChoiceYesNo(String string) {
        ResourceMap resourceMap = Swinger.getResourceMap();
        return JOptionPane.showOptionDialog(Swinger.getActiveWindowComponent(), string, resourceMap.getString(MESSAGE_CONFIRM_TITLE_CODE, new Object[0]), 0, 3, null, new Object[]{resourceMap.getString(MESSAGE_BTN_YES_CODE, new Object[0]), resourceMap.getString(MESSAGE_BTN_NO_CODE, new Object[0])}, null);
    }

    public static void minimize(JFrame jFrame) {
        int n = jFrame.getExtendedState();
        jFrame.setExtendedState(n |= 1);
    }

    public static Frame getActiveFrame() {
        Frame[] frameArray;
        for (Frame frame : frameArray = Frame.getFrames()) {
            if (!frame.isActive()) continue;
            return frame;
        }
        return frameArray.length > 0 ? frameArray[0] : null;
    }

    public static Window getActiveDialog() {
        Window[] windowArray;
        for (Window window : windowArray = Dialog.getWindows()) {
            if (!window.isActive()) continue;
            return window;
        }
        return windowArray.length > 0 ? windowArray[0] : null;
    }

    public static int[] getSelectedRows(JTable jTable) {
        int[] nArray = jTable.getSelectedRows();
        int n = nArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            if (n3 >= jTable.getModel().getRowCount() || n3 >= jTable.getRowSorter().getViewRowCount()) continue;
            nArray[n2++] = jTable.convertRowIndexToModel(n3);
        }
        if (n2 > 0) {
            return Arrays.copyOfRange(nArray, 0, n2);
        }
        return new int[0];
    }

    public static String getMessageFromException(ResourceMap resourceMap, Throwable throwable) {
        String string;
        String string2 = throwable.getLocalizedMessage();
        String string3 = string2 != null ? (resourceMap.containsKey(string2) ? resourceMap.getString(string2, new Object[0]) : string2) : ((string = throwable.getMessage()) != null && resourceMap.containsKey(string) ? resourceMap.getString(string, new Object[0]) : string);
        return string3;
    }

    public static int convertRowIndexToView(JTable jTable, int n) {
        if (n <= -1 || n >= jTable.getModel().getRowCount()) {
            return -1;
        }
        return jTable.convertRowIndexToView(n);
    }
}

