/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient.utils;

import cz.vity.freerapid.plugins.exceptions.PluginImplementationException;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpFile;
import cz.vity.freerapid.plugins.webclient.utils.Entities;
import cz.vity.freerapid.plugins.webclient.utils.GOCR;
import cz.vity.freerapid.utilities.Utils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.methods.PostMethod;

public final class PlugUtils {
    private static final Logger logger = Logger.getLogger(PlugUtils.class.getName());
    private static Pattern parameterInputPattern;
    private static Pattern parameterNamePattern;
    private static Pattern parameterValuePattern;

    public static long getFileSizeFromString(String string) {
        if (string == null) {
            throw new NullPointerException("Input value cannot be null");
        }
        string = string.replace('\u041c', 'M');
        string = string.replace('\u0431', 'B');
        string = string.replace('\u043a', 'K');
        string = string.replace('\u041a', 'K');
        string = string.replace('\u0433', 'G');
        string = string.replace('\u0413', 'G');
        string = string.toUpperCase();
        int n = 1;
        int n2 = string.lastIndexOf("KB");
        if (n2 >= 0) {
            n = 1024;
        } else {
            n2 = string.lastIndexOf("MB");
            if (n2 >= 0) {
                n = 0x100000;
            } else {
                n2 = string.lastIndexOf("GB");
                if (n2 >= 0) {
                    n = 0x40000000;
                } else {
                    n2 = string.lastIndexOf("BYTES");
                    if (n2 < 0) {
                        n2 = string.lastIndexOf("BB");
                    }
                    if (n2 < 0) {
                        n2 = string.lastIndexOf("B");
                    }
                }
            }
        }
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        if ((string = string.replaceAll("(\\s|\u00a0)*", "").replace(',', '.')).indexOf(46) > 0) {
            return new BigDecimal(string).multiply(BigDecimal.valueOf(n)).setScale(0, RoundingMode.UP).longValue();
        }
        return Long.parseLong(string) * (long)n;
    }

    public static Matcher matcher(String string, String string2) {
        if (string2 == null) {
            throw new NullPointerException("Input value cannot be null");
        }
        return Pattern.compile(string, 8).matcher(string2);
    }

    public static boolean find(String string, String string2) {
        return PlugUtils.matcher(string, string2).find();
    }

    public static String unescapeHtml(String string) {
        if (string == null) {
            return null;
        }
        try {
            StringWriter stringWriter = new StringWriter((int)((double)string.length() * 1.5));
            Entities.HTML40.unescape(stringWriter, string);
            return stringWriter.toString().replaceAll("\u00a0", " ");
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Cannot unescape HTML", iOException);
            return null;
        }
    }

    public static String getParameter(String string, String string2) throws PluginImplementationException {
        PlugUtils.initParameterPatterns();
        int n = 0;
        Matcher matcher = parameterInputPattern.matcher(string2);
        while (matcher.find(n)) {
            String string3 = matcher.group(1);
            Matcher matcher2 = parameterNamePattern.matcher(string3);
            if (matcher2.find()) {
                String string4 = matcher2.group(1);
                if (string.toLowerCase().equals(string4.toLowerCase())) {
                    Matcher matcher3 = parameterValuePattern.matcher(string3);
                    if (matcher3.find()) {
                        return matcher3.group(1);
                    }
                    return "";
                }
            }
            n = matcher.end();
        }
        throw new PluginImplementationException("Parameter " + string + " was not found");
    }

    public static void addParameters(PostMethod postMethod, String string, String[] stringArray) throws PluginImplementationException {
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("You have to provide some parameter names");
        }
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        hashSet.addAll(Arrays.asList(stringArray));
        PlugUtils.initParameterPatterns();
        int n = 0;
        Matcher matcher = parameterInputPattern.matcher(string);
        while (matcher.find(n)) {
            String string2;
            String string3 = matcher.group(1);
            Matcher matcher2 = parameterNamePattern.matcher(string3);
            if (matcher2.find() && hashSet.contains(string2 = matcher2.group(1))) {
                Matcher matcher3 = parameterValuePattern.matcher(string3);
                String string4 = "";
                if (matcher3.find()) {
                    string4 = matcher3.group(1);
                }
                hashSet.remove(string2);
                postMethod.addParameter(string2, string4);
                if (hashSet.isEmpty()) break;
            }
            n = matcher.end();
        }
        if (!hashSet.isEmpty()) {
            throw new PluginImplementationException("Following parameters: " + Arrays.toString(hashSet.toArray()) + " were not found");
        }
    }

    private static void initParameterPatterns() {
        if (parameterInputPattern == null) {
            parameterInputPattern = Pattern.compile("<input (.+?)>", 42);
        }
        if (parameterNamePattern == null) {
            parameterNamePattern = Pattern.compile("name\\s?=\\s?(?:\"|')?(.*?)(?:\"|'|\\s|$)", 10);
        }
        if (parameterValuePattern == null) {
            parameterValuePattern = Pattern.compile("value\\s?=\\s?(?:\"|')?(.*?)(?:\"|'|\\s|$)", 10);
        }
    }

    public static String replaceEntities(String string) {
        return string.replaceAll("\\&amp;", "&");
    }

    public static String recognize(BufferedImage bufferedImage, String string) {
        GOCR gOCR = new GOCR(bufferedImage, string);
        try {
            return gOCR.recognize();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void checkName(HttpFile httpFile, String string, String string2, String string3) throws PluginImplementationException {
        String string4 = Pattern.quote(Utils.rtrim(string2)).replaceAll("\n", "\\\\E\\\\s*\\\\Q");
        String string5 = Pattern.quote(Utils.ltrim(string3)).replaceAll("\n", "\\\\E\\\\s*\\\\Q");
        Matcher matcher = PlugUtils.matcher(string4 + "\\s*(.+?)\\s*" + string5, string);
        if (!matcher.find()) {
            throw new PluginImplementationException("File name not found");
        }
        String string6 = matcher.group(1).trim();
        logger.info("File name " + string6);
        httpFile.setFileName(string6);
    }

    public static void checkFileSize(HttpFile httpFile, String string, String string2, String string3) throws PluginImplementationException {
        String string4 = Pattern.quote(Utils.rtrim(string2)).replaceAll("\n", "\\\\E\\\\s*\\\\Q");
        String string5 = Pattern.quote(Utils.ltrim(string3)).replaceAll("\n", "\\\\E\\\\s*\\\\Q");
        Matcher matcher = PlugUtils.matcher(string4 + "\\s*(.+?)\\s*" + string5, string);
        if (!matcher.find()) {
            throw new PluginImplementationException("File size not found");
        }
        String string6 = matcher.group(1);
        logger.info("File size " + string6);
        long l = PlugUtils.getFileSizeFromString(matcher.group(1));
        httpFile.setFileSize(l);
    }

    public static String getStringBetween(String string, String string2, String string3) throws PluginImplementationException {
        String string4 = Pattern.quote(Utils.rtrim(string2));
        String string5 = Pattern.quote(Utils.ltrim(string3));
        Matcher matcher = PlugUtils.matcher(string4 + "\\s*(.+?)\\s*" + string5, string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new PluginImplementationException(String.format("No string between '%s' and '%s' was found", string2, string3));
    }

    public static int getNumberBetween(String string, String string2, String string3) throws PluginImplementationException {
        String string4 = Pattern.quote(Utils.rtrim(string2));
        String string5 = Pattern.quote(Utils.ltrim(string3));
        Matcher matcher = PlugUtils.matcher(string4 + "\\s*([0-9]+?)\\s*" + string5, string);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1));
        }
        throw new PluginImplementationException(String.format("No number between '%s' and '%s' was found", string2, string3));
    }

    public static int getWaitTimeBetween(String string, String string2, String string3, TimeUnit timeUnit) throws PluginImplementationException {
        String string4 = Pattern.quote(Utils.rtrim(string2));
        String string5 = Pattern.quote(Utils.ltrim(string3));
        Matcher matcher = PlugUtils.matcher(string4 + "\\s*([0-9]+?)\\s*" + string5, string);
        if (matcher.find()) {
            long l = Long.parseLong(matcher.group(1));
            return new Long(timeUnit.toSeconds(l)).intValue();
        }
        throw new PluginImplementationException(String.format("No wait time value between '%s' and '%s' was found", string2, string3));
    }
}

