/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient.ssl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class EasyX509TrustManager
implements X509TrustManager {
    private X509TrustManager standardTrustManager = null;
    private static final Logger logger = Logger.getLogger(EasyX509TrustManager.class.getName());

    public EasyX509TrustManager(KeyStore keyStore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        if (trustManagerArray.length == 0) {
            throw new NoSuchAlgorithmException("no trust manager found");
        }
        this.standardTrustManager = (X509TrustManager)trustManagerArray[0];
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.standardTrustManager.checkClientTrusted(x509CertificateArray, string);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        if (x509CertificateArray != null && logger.isLoggable(Level.FINE)) {
            logger.fine("Server certificate chain:");
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                logger.fine("X509Certificate[" + i + "]=" + x509CertificateArray[i]);
            }
        }
        if (x509CertificateArray != null && x509CertificateArray.length == 1) {
            x509CertificateArray[0].checkValidity();
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }
}

