/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.UserProp;
import cz.vity.freerapid.core.application.GlobalEDTExceptionHandler;
import cz.vity.freerapid.core.tasks.DownloadTask;
import cz.vity.freerapid.core.tasks.DownloadTaskError;
import cz.vity.freerapid.core.tasks.RunCheckTask;
import cz.vity.freerapid.gui.actions.DownloadsActions;
import cz.vity.freerapid.gui.managers.ClientManager;
import cz.vity.freerapid.gui.managers.DataManager;
import cz.vity.freerapid.gui.managers.DownloadService;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.PluginsManager;
import cz.vity.freerapid.gui.managers.exceptions.NotSupportedDownloadServiceException;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.model.PluginMetaData;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.plugins.webclient.FileState;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpDownloadClient;
import cz.vity.freerapid.plugins.webclient.interfaces.ShareDownloadService;
import cz.vity.freerapid.utilities.LogUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.SwingUtilities;
import javax.swing.event.SwingPropertyChangeSupport;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.TaskEvent;
import org.jdesktop.application.TaskListener;
import org.jdesktop.application.TaskService;

public class ProcessManager
extends Thread {
    private static final Logger logger = Logger.getLogger(ProcessManager.class.getName());
    private final ApplicationContext context;
    private DataManager dataManager;
    private final PropertyChangeSupport pcs;
    private volatile Map<String, DownloadService> services = new Hashtable<String, DownloadService>();
    private volatile Map<DownloadFile, ConnectionSettings> forceDownloadFiles = new Hashtable<DownloadFile, ConnectionSettings>();
    private volatile List<DownloadFile> forceValidateCheck = new Vector<DownloadFile>();
    private boolean threadSuspended;
    private final Object downloadingLock = new Object();
    private final Object manipulation = new Object();
    private final Timer errorTimer = new Timer();
    private PluginsManager pluginsManager;
    private volatile int downloading;
    private TaskService taskService;
    private ClientManager clientManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessManager(ManagerDirector managerDirector, ApplicationContext applicationContext) {
        this.dataManager = managerDirector.getDataManager();
        this.pluginsManager = managerDirector.getPluginsManager();
        this.pcs = new SwingPropertyChangeSupport(this);
        this.context = applicationContext;
        this.taskService = managerDirector.getTaskServiceManager().getTaskService("downloadService");
        this.clientManager = managerDirector.getClientManager();
        Object object = this.downloadingLock;
        synchronized (object) {
            this.setDownloading(0);
        }
        AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                if ("maxDownloadsAtATime".equals(preferenceChangeEvent.getKey())) {
                    ProcessManager.this.queueUpdated();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setName("ProcessManagerThread");
        this.setUncaughtExceptionHandler(new GlobalEDTExceptionHandler());
        while (!this.isInterrupted()) {
            Object object = this.dataManager.getLock();
            synchronized (object) {
                Object object2 = this.manipulation;
                synchronized (object2) {
                    if (this.canCreateAnotherConnection(true) && !this.forceDownloadFiles.isEmpty()) {
                        this.executeForceDownload();
                    }
                    if (this.canCreateAnotherConnection(true) && !this.forceValidateCheck.isEmpty()) {
                        this.executeForceValidateCheck();
                    }
                    if (this.canCreateAnotherConnection(true)) {
                        this.execute();
                    }
                }
            }
            try {
                object = this;
                synchronized (object) {
                    this.threadSuspended = true;
                    logger.info("Test for sleeping");
                    while (this.threadSuspended) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        logger.info("Process Manager thread was interrupted succesfuly");
    }

    private void executeForceValidateCheck() {
        DownloadFile[] downloadFileArray = new DownloadFile[this.forceValidateCheck.size()];
        for (DownloadFile downloadFile : downloadFileArray = this.forceValidateCheck.toArray(downloadFileArray)) {
            logger.info("Getting file for check " + downloadFile);
            ShareDownloadService shareDownloadService = this.pluginsManager.getService(downloadFile);
            if (shareDownloadService == null) continue;
            DownloadService downloadService = this.getDownloadService(shareDownloadService);
            List<ConnectionSettings> list = this.clientManager.getRotatedEnabledConnections();
            if (downloadFile.getFileState() == FileState.NOT_CHECKED && shareDownloadService.supportsRunCheck() && !list.isEmpty()) {
                this.queueDownload(downloadFile, list.get(0), downloadService, shareDownloadService, true);
            }
            if (!this.canCreateAnotherConnection(false)) break;
        }
        this.forceValidateCheck.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canCreateAnotherConnection(boolean bl) {
        Object object = this.downloadingLock;
        synchronized (object) {
            int n = this.getDownloading();
            if (n == 9) {
                return false;
            }
            if (bl) {
                return true;
            }
            int n2 = Math.min(AppPrefs.getProperty("maxDownloadsAtATime", UserProp.MAX_DOWNLOADS_AT_A_TIME_DEFAULT), 9);
            boolean bl2 = n2 > n;
            return bl2;
        }
    }

    private List<DownloadFile> getFilesForForceDownload() {
        return new LinkedList<DownloadFile>(this.forceDownloadFiles.keySet());
    }

    private boolean execute() {
        ArrayList<DownloadFile> arrayList = new ArrayList<DownloadFile>((Collection<DownloadFile>)this.dataManager.getDownloadFiles());
        boolean bl = AppPrefs.getProperty("testFiles", true);
        List<DownloadFile> list = this.getQueued(arrayList);
        for (DownloadFile downloadFile : list) {
            logger.info("Getting downloadFile " + downloadFile);
            ShareDownloadService shareDownloadService = this.pluginsManager.getService(downloadFile);
            if (shareDownloadService == null) continue;
            DownloadService downloadService = this.getDownloadService(shareDownloadService);
            List<ConnectionSettings> list2 = this.clientManager.getRotatedEnabledConnections();
            if (bl && downloadFile.getFileState() == FileState.NOT_CHECKED && shareDownloadService.supportsRunCheck() && !list2.isEmpty()) {
                this.queueDownload(downloadFile, list2.get(0), downloadService, shareDownloadService, true);
            } else if (this.canCreateAnotherConnection(false) && downloadService.canDownloadBeforeCheck(downloadFile, arrayList, this.isStartFromTop())) {
                for (ConnectionSettings connectionSettings : list2) {
                    if (!downloadService.canDownloadWith(connectionSettings)) continue;
                    this.queueDownload(downloadFile, connectionSettings, downloadService, shareDownloadService, false);
                    break;
                }
            }
            if (this.canCreateAnotherConnection(true)) continue;
            return true;
        }
        return false;
    }

    private boolean executeForceDownload() {
        for (DownloadFile downloadFile : this.getFilesForForceDownload()) {
            logger.info("Getting downloadFile " + downloadFile);
            ShareDownloadService shareDownloadService = this.pluginsManager.getService(downloadFile);
            if (shareDownloadService == null) continue;
            DownloadService downloadService = this.getDownloadService(shareDownloadService);
            ConnectionSettings connectionSettings = this.forceDownloadFiles.remove(downloadFile);
            if (connectionSettings == null) {
                throw new IllegalStateException("Cannot find forceDownloaded File");
            }
            logger.info("Force downloading with settings " + connectionSettings);
            this.queueDownload(downloadFile, connectionSettings, downloadService, shareDownloadService, false);
            if (this.canCreateAnotherConnection(true)) continue;
            return true;
        }
        return false;
    }

    private DownloadService getDownloadService(ShareDownloadService shareDownloadService) {
        PluginMetaData pluginMetaData = this.pluginsManager.getPluginMetadata(shareDownloadService.getId());
        String string = pluginMetaData.getServices();
        DownloadService downloadService = this.services.get(string);
        if (downloadService == null) {
            downloadService = new DownloadService(pluginMetaData, shareDownloadService);
            this.services.put(string, downloadService);
        }
        logger.info("Getting plugin: " + pluginMetaData.toString());
        return downloadService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceDownload(ConnectionSettings connectionSettings, List<DownloadFile> list) {
        Object object = this.manipulation;
        synchronized (object) {
            for (DownloadFile downloadFile : list) {
                if (DownloadsActions.isProcessState(downloadFile.getState())) continue;
                logger.info("Force downloading file " + downloadFile + " with settings " + connectionSettings);
                this.forceDownloadFiles.put(downloadFile, connectionSettings);
                downloadFile.setState(DownloadState.QUEUED);
            }
        }
        this.queueUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceValidateCheck(List<DownloadFile> list) {
        Object object = this.manipulation;
        synchronized (object) {
            for (DownloadFile downloadFile : list) {
                if (DownloadsActions.isProcessState(downloadFile.getState())) continue;
                logger.info("Force validate check file " + downloadFile);
                this.forceValidateCheck.add(downloadFile);
                downloadFile.setState(DownloadState.QUEUED);
            }
        }
        this.queueUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueDownload(final DownloadFile downloadFile, ConnectionSettings connectionSettings, final DownloadService downloadService, final ShareDownloadService shareDownloadService, final boolean bl) {
        HttpDownloadClient httpDownloadClient;
        if (downloadFile.getState() != DownloadState.QUEUED) {
            logger.info("QUEUED not found - found " + (Object)((Object)downloadFile.getState()));
            return;
        }
        Object object = this.downloadingLock;
        synchronized (object) {
            httpDownloadClient = this.clientManager.popWorkingClient();
            this.setDownloading(this.downloading + 1);
            httpDownloadClient.initClient(connectionSettings);
        }
        if (bl) {
            downloadService.addTestingFile(downloadFile);
            downloadFile.setState(DownloadState.TESTING);
        } else {
            downloadService.addDownloadingClient(httpDownloadClient);
            downloadFile.setState(DownloadState.GETTING);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DownloadState downloadState = downloadFile.getState();
                if (downloadState != DownloadState.GETTING && downloadState != DownloadState.TESTING) {
                    ProcessManager.this.finishedDownloading(downloadFile, httpDownloadClient, downloadService, null, bl);
                } else {
                    ProcessManager.this.startDownload(downloadFile, httpDownloadClient, downloadService, shareDownloadService, bl);
                }
            }
        });
    }

    private List<DownloadFile> getQueued(List<DownloadFile> list) {
        LinkedList<DownloadFile> linkedList = new LinkedList<DownloadFile>();
        boolean bl = this.isStartFromTop();
        if (bl) {
            for (DownloadFile downloadFile : list) {
                if (downloadFile.getState() != DownloadState.QUEUED) continue;
                linkedList.add(downloadFile);
            }
        } else {
            for (int i = list.size() - 1; i >= 0; --i) {
                DownloadFile downloadFile = list.get(i);
                if (downloadFile.getState() != DownloadState.QUEUED) continue;
                linkedList.add(downloadFile);
            }
        }
        return linkedList;
    }

    private boolean isStartFromTop() {
        return AppPrefs.getProperty("startDownloadFromTheTop", true);
    }

    private void startDownload(final DownloadFile downloadFile, final HttpDownloadClient httpDownloadClient, final DownloadService downloadService, ShareDownloadService shareDownloadService, final boolean bl) {
        DownloadState downloadState = downloadFile.getState();
        logger.info("starting download in state s = " + (Object)((Object)downloadState));
        try {
            final DownloadTask downloadTask = bl ? new RunCheckTask(this.context.getApplication(), httpDownloadClient, downloadFile, shareDownloadService) : new DownloadTask(this.context.getApplication(), httpDownloadClient, downloadFile, shareDownloadService);
            downloadFile.setTask(downloadTask);
            this.updateResumable(downloadFile);
            downloadTask.addTaskListener(new TaskListener.Adapter<Void, Long>(){

                @Override
                public void finished(TaskEvent<Void> taskEvent) {
                    ProcessManager.this.finishedDownloading(downloadFile, httpDownloadClient, downloadService, downloadTask, bl);
                    downloadFile.setTask(null);
                }
            });
            try {
                this.taskService.execute(downloadTask);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                logger.severe("downloading = " + this.downloading);
                throw rejectedExecutionException;
            }
        }
        catch (NotSupportedDownloadServiceException notSupportedDownloadServiceException) {
            LogUtils.processException(logger, notSupportedDownloadServiceException);
        }
    }

    private void updateResumable(DownloadFile downloadFile) {
        if (downloadFile.isResumeSupported()) {
            try {
                boolean bl = this.pluginsManager.getPluginMetadata(downloadFile.getPluginID()).isResumeSupported();
                downloadFile.setResumeSupported(bl);
            }
            catch (NotSupportedDownloadServiceException notSupportedDownloadServiceException) {
                LogUtils.processException(logger, notSupportedDownloadServiceException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishedDownloading(DownloadFile downloadFile, HttpDownloadClient httpDownloadClient, DownloadService downloadService, DownloadTask downloadTask, boolean bl) {
        Object object = this.manipulation;
        synchronized (object) {
            if (bl) {
                downloadService.finishedTestingFile(downloadFile);
            } else {
                downloadService.finishedDownloading(httpDownloadClient);
            }
            Object object2 = this.downloadingLock;
            synchronized (object2) {
                this.clientManager.pushWorkingClient(httpDownloadClient);
                this.setDownloading(this.downloading - 1);
            }
            if (downloadTask != null) {
                object2 = downloadTask.getServiceError();
                ConnectionSettings connectionSettings = httpDownloadClient.getSettings();
                if (object2 == DownloadTaskError.NO_ROUTE_TO_HOST) {
                    this.clientManager.setConnectionEnabled(connectionSettings, false);
                    if (this.clientManager.getEnabledConnections().size() > 0) {
                        downloadFile.setState(DownloadState.QUEUED);
                    } else {
                        object2 = DownloadTaskError.NOT_RECOVERABLE_DOWNLOAD_ERROR;
                    }
                }
                DownloadState downloadState = downloadFile.getState();
                int n = downloadFile.getErrorAttemptsCount();
                if (downloadState == DownloadState.ERROR && n != 0 || downloadState == DownloadState.SLEEPING) {
                    if (object2 == DownloadTaskError.NOT_RECOVERABLE_DOWNLOAD_ERROR && n != -1) {
                        downloadFile.setErrorAttemptsCount(0);
                    } else {
                        if (n != -1) {
                            downloadFile.setErrorAttemptsCount(n - 1);
                        }
                        downloadService.addProblematicConnection(connectionSettings);
                        int n2 = this.errorTimer.purge();
                        if (n2 > 0) {
                            logger.info("Purging timer threads count:" + n2);
                        }
                        if (object2 == DownloadTaskError.YOU_HAVE_TO_WAIT_ERROR) {
                            int n3 = downloadTask.getYouHaveToSleepSecondsTime();
                            this.errorTimer.schedule((TimerTask)new ErrorTimerTask(downloadService, connectionSettings, downloadFile, n3), 0L, 1000L);
                        } else {
                            this.errorTimer.schedule((TimerTask)new ErrorTimerTask(downloadService, connectionSettings, downloadFile), 0L, 1000L);
                        }
                    }
                }
            }
        }
        this.checkCompleted(downloadFile);
        this.wakeUp();
    }

    private void checkCompleted(DownloadFile downloadFile) {
        if (downloadFile.getState() == DownloadState.COMPLETED) {
            boolean bl = false;
            if (Boolean.TRUE.equals(downloadFile.getProperties().get("removeCompleted"))) {
                bl = true;
            } else {
                boolean bl2 = AppPrefs.getProperty("removeCompletedCrypter", true);
                try {
                    PluginMetaData pluginMetaData = this.pluginsManager.getPluginMetadata(downloadFile.getPluginID());
                    if (bl2 && pluginMetaData.isRemoveCompleted()) {
                        bl = true;
                    }
                }
                catch (NotSupportedDownloadServiceException notSupportedDownloadServiceException) {
                    // empty catch block
                }
            }
            if (bl) {
                this.dataManager.removeSelected(Arrays.asList(downloadFile));
            }
        }
    }

    public void queueUpdated() {
        this.wakeUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUp() {
        ProcessManager processManager = this;
        synchronized (processManager) {
            this.threadSuspended = false;
            this.notify();
        }
    }

    public int getDownloading() {
        return this.downloading;
    }

    public void setDownloading(int n) {
        int n2 = this.downloading;
        this.downloading = n;
        this.pcs.firePropertyChange("downloading", n2, this.downloading);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    private class ErrorTimerTask
    extends TimerTask
    implements PropertyChangeListener {
        private int counter;
        private final DownloadService service;
        private final ConnectionSettings settings;
        private final DownloadFile file;
        private long lastTime;
        private boolean finished;

        public ErrorTimerTask(DownloadService downloadService, ConnectionSettings connectionSettings, DownloadFile downloadFile) {
            this(downloadService, connectionSettings, downloadFile, AppPrefs.getProperty("autoReconnectTime", 120));
        }

        public ErrorTimerTask(DownloadService downloadService, ConnectionSettings connectionSettings, DownloadFile downloadFile, int n) {
            this.service = downloadService;
            this.settings = connectionSettings;
            this.file = downloadFile;
            this.counter = n;
            downloadFile.setTimeToQueuedMax(n);
            this.lastTime = System.currentTimeMillis();
            this.finished = false;
            downloadFile.addPropertyChangeListener("state", this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DownloadState downloadState = (DownloadState)((Object)propertyChangeEvent.getNewValue());
            if (downloadState != DownloadState.ERROR && downloadState != DownloadState.SLEEPING) {
                Object object = ProcessManager.this.manipulation;
                synchronized (object) {
                    this.cancel();
                    if (downloadState != DownloadState.WAITING) {
                        this.file.setTimeToQueued(-1);
                        this.file.setTimeToQueuedMax(-1);
                    }
                    this.finished = true;
                    this.unregisterListener();
                    this.file.resetErrorAttempts();
                    this.renewProblematicConnection();
                }
                ProcessManager.this.queueUpdated();
            }
        }

        private void unregisterListener() {
            this.file.removePropertyChangeListener("state", this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.finished) {
                return;
            }
            this.file.setTimeToQueued(--this.counter);
            long l = System.currentTimeMillis();
            if (this.counter <= 0 || l - this.lastTime > 60000L) {
                Object object = ProcessManager.this.manipulation;
                synchronized (object) {
                    this.unregisterListener();
                    this.file.setTimeToQueued(-1);
                    this.file.setTimeToQueuedMax(-1);
                    this.file.setState(DownloadState.QUEUED);
                    this.cancel();
                    this.renewProblematicConnection();
                }
                ProcessManager.this.queueUpdated();
            }
            this.lastTime = l;
        }

        private void renewProblematicConnection() {
            this.service.removeProblematicConnection(this.settings);
        }
    }
}

