/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.PluginMetaDataManager;
import cz.vity.freerapid.gui.managers.exceptions.NotSupportedDownloadServiceException;
import cz.vity.freerapid.gui.managers.exceptions.PluginIsNotEnabledException;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.model.PluginMetaData;
import cz.vity.freerapid.plugimpl.StandardDialogSupportImpl;
import cz.vity.freerapid.plugimpl.StandardPluginContextImpl;
import cz.vity.freerapid.plugimpl.StandardStorageSupportImpl;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.plugins.webclient.interfaces.PluginContext;
import cz.vity.freerapid.plugins.webclient.interfaces.ShareDownloadService;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.java.plugin.ObjectFactory;
import org.java.plugin.PathResolver;
import org.java.plugin.Plugin;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.standard.ShadingPathResolver;
import org.java.plugin.standard.StandardPluginLocation;
import org.java.plugin.util.ExtendedProperties;
import org.java.plugin.util.IoUtil;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;

public class PluginsManager {
    private static final Logger logger = Logger.getLogger(PluginsManager.class.getName());
    private Map<String, PluginMetaData> supportedPlugins = new HashMap<String, PluginMetaData>();
    private final Object lock = new Object();
    private final ApplicationContext context;
    private final ManagerDirector director;
    private PluginManager pluginManager;
    private PluginMetaDataManager pluginMetaDataManager;

    public PluginsManager(ApplicationContext applicationContext, ManagerDirector managerDirector) {
        this.context = applicationContext;
        this.director = managerDirector;
        this.pluginMetaDataManager = new PluginMetaDataManager(applicationContext);
        this.context.getApplication().addExitListener(new Application.ExitListener(){

            @Override
            public boolean canExit(EventObject eventObject) {
                return true;
            }

            @Override
            public void willExit(EventObject eventObject) {
                if (PluginsManager.this.pluginManager != null) {
                    try {
                        PluginsManager.this.pluginManager.shutdown();
                        File file = new File(System.getProperty("java.io.tmpdir"), ".jpf-shadow");
                        IoUtil.emptyFolder((File)file);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.loadPlugins();
    }

    private void loadPlugins() {
        logger.info("Init Plugins Manager");
        ObjectFactory objectFactory = ObjectFactory.newInstance();
        ShadingPathResolver shadingPathResolver = new ShadingPathResolver();
        try {
            shadingPathResolver.configure(new ExtendedProperties());
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
        this.pluginManager = objectFactory.createManager(objectFactory.createRegistry(), (PathResolver)shadingPathResolver);
        this.initPlugins();
    }

    public void initPlugins() {
        File file = this.getPluginsDir();
        logger.info("Plugins dir: " + file.getAbsolutePath());
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.toLowerCase().endsWith(".frp");
            }
        });
        try {
            Object object2;
            Object object3;
            if (fileArray == null) {
                throw new IllegalStateException("Plugins directory does not exists");
            }
            int n = fileArray.length;
            PluginManager.PluginLocation[] pluginLocationArray = new PluginManager.PluginLocation[n];
            for (int i = 0; i < n; ++i) {
                try {
                    object3 = PluginsManager.fileToUrl(fileArray[i]).toExternalForm();
                    logger.info("Plugins path:" + (String)object3);
                    object2 = new URL("jar:" + (String)object3 + "!/");
                    URL object4 = new URL("jar:" + (String)object3 + "!/plugin.xml");
                    pluginLocationArray[i] = new StandardPluginLocation((URL)object2, object4);
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    LogUtils.processException(logger, malformedURLException);
                }
            }
            this.pluginManager.publishPlugins(pluginLocationArray);
            Set<PluginMetaData> set = this.pluginMetaDataManager.getItems();
            object3 = new HashMap(set.size());
            for (PluginMetaData pluginMetaData : set) {
                object3.put(pluginMetaData.getId(), pluginMetaData);
            }
            object2 = this.pluginManager.getRegistry().getPluginDescriptors();
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                PluginDescriptor pluginDescriptor = (PluginDescriptor)iterator.next();
                String string = pluginDescriptor.getId();
                if (object3.containsKey(string)) {
                    PluginMetaData pluginMetaData = (PluginMetaData)object3.get(string);
                    pluginMetaData.setPluginDescriptor(pluginDescriptor);
                    this.supportedPlugins.put(string, pluginMetaData);
                    continue;
                }
                this.supportedPlugins.put(string, new PluginMetaData(pluginDescriptor));
            }
            this.disablePluginsInConflict();
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
            this.context.getApplication().exit();
        }
    }

    public File getPluginsDir() {
        File file = new File(Utils.getAppPath(), "plugins");
        String string = System.getProperty("plug-dir", file.getAbsolutePath());
        File file2 = new File(string);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        return file2;
    }

    private void disablePluginsInConflict() {
        HashMap hashMap = new HashMap();
        for (PluginMetaData object3 : this.supportedPlugins.values()) {
            Object object;
            if (!object3.isEnabled()) continue;
            String string = object3.getServices();
            if (hashMap.containsKey(string)) {
                object = (List)hashMap.get(string);
                object.add(object3);
                continue;
            }
            object = new LinkedList();
            object.add(object3);
            hashMap.put(string, object);
        }
        for (List list : hashMap.values()) {
            if (list.size() <= 1) continue;
            for (Object object : list) {
                if (!((PluginMetaData)object).isPremium()) continue;
                ((PluginMetaData)object).setEnabled(false);
            }
        }
    }

    private static URL fileToUrl(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSupported(URL uRL) {
        String string = uRL.toExternalForm();
        Object object = this.lock;
        synchronized (object) {
            for (PluginMetaData pluginMetaData : this.supportedPlugins.values()) {
                if (!pluginMetaData.isSupported(string) || !pluginMetaData.isEnabled()) continue;
                return true;
            }
            return false;
        }
    }

    public String getServiceIDForURL(URL uRL) throws NotSupportedDownloadServiceException {
        Set<Map.Entry<String, PluginMetaData>> set = this.supportedPlugins.entrySet();
        String string = uRL.toExternalForm();
        PluginMetaData pluginMetaData = null;
        for (Map.Entry<String, PluginMetaData> entry : set) {
            PluginMetaData pluginMetaData2 = entry.getValue();
            if (!pluginMetaData2.isSupported(string)) continue;
            if (!pluginMetaData2.isEnabled()) {
                pluginMetaData = pluginMetaData2;
                continue;
            }
            return entry.getKey();
        }
        if (pluginMetaData != null) {
            throw new PluginIsNotEnabledException(pluginMetaData);
        }
        throw new NotSupportedDownloadServiceException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareDownloadService getPluginInstance(String string) throws NotSupportedDownloadServiceException {
        Object object = this.lock;
        synchronized (object) {
            Plugin plugin;
            try {
                logger.info("Loading plugin with ID=" + string);
                plugin = this.pluginManager.getPlugin(string);
            }
            catch (Exception exception) {
                LogUtils.processException(logger, exception);
                throw new NotSupportedDownloadServiceException(string);
            }
            if (!(plugin instanceof ShareDownloadService)) {
                throw new NotSupportedDownloadServiceException(string);
            }
            ShareDownloadService shareDownloadService = (ShareDownloadService)plugin;
            if (shareDownloadService.getPluginContext() == null) {
                shareDownloadService.setPluginContext(this.createPluginContext());
            }
            logger.info("Plugin with ID=" + string + " was loaded");
            return shareDownloadService;
        }
    }

    private PluginContext createPluginContext() {
        return StandardPluginContextImpl.create(new StandardDialogSupportImpl(this.context), new StandardStorageSupportImpl(this.context), this.director.getDataManager());
    }

    public List<PluginMetaData> getSupportedPlugins() {
        return new ArrayList<PluginMetaData>(this.supportedPlugins.values());
    }

    public void updatePluginSettings() {
        this.pluginMetaDataManager.saveToFile(new HashSet<PluginMetaData>(this.supportedPlugins.values()));
    }

    public PluginMetaData getPluginMetadata(String string) throws NotSupportedDownloadServiceException {
        if (!this.supportedPlugins.containsKey(string)) {
            throw new NotSupportedDownloadServiceException(string);
        }
        return this.supportedPlugins.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareDownloadService getService(DownloadFile downloadFile) {
        Object object = this.lock;
        synchronized (object) {
            return this.getActiveService(downloadFile);
        }
    }

    private ShareDownloadService getActiveService(DownloadFile downloadFile) {
        String string = downloadFile.getPluginID();
        try {
            PluginMetaData pluginMetaData = this.getPluginMetadata(string);
            if (!pluginMetaData.isEnabled()) {
                try {
                    String string2 = this.getServiceIDForURL(downloadFile.getFileUrl());
                    downloadFile.setPluginID(string2);
                    return this.getPluginInstance(string2);
                }
                catch (NotSupportedDownloadServiceException notSupportedDownloadServiceException) {
                    downloadFile.setPluginID(string);
                    downloadFile.setState(DownloadState.DISABLED);
                    downloadFile.setErrorMessage(Swinger.getMessageFromException(Swinger.getResourceMap(), notSupportedDownloadServiceException));
                    return null;
                }
            }
            return this.getPluginInstance(string);
        }
        catch (NotSupportedDownloadServiceException notSupportedDownloadServiceException) {
            try {
                String string3 = this.getServiceIDForURL(downloadFile.getFileUrl());
                downloadFile.setPluginID(string3);
                return this.getPluginInstance(string3);
            }
            catch (PluginIsNotEnabledException pluginIsNotEnabledException) {
                downloadFile.setState(DownloadState.DISABLED);
                downloadFile.setErrorMessage(Swinger.getResourceMap().getString("PluginIsNotEnabled", downloadFile.getPluginID()));
            }
            catch (NotSupportedDownloadServiceException notSupportedDownloadServiceException2) {
                downloadFile.setState(DownloadState.ERROR);
                downloadFile.setErrorMessage(Swinger.getMessageFromException(Swinger.getResourceMap(), notSupportedDownloadServiceException));
            }
            return null;
        }
    }

    public boolean hasPlugin(String string) {
        return this.supportedPlugins.containsKey(string);
    }
}

