/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.content;

import cz.vity.freerapid.gui.content.ContentPanel;
import cz.vity.freerapid.model.DownloadFile;
import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;

final class SizeCellRenderer
extends DefaultTableCellRenderer {
    private final String sizeRendererProgress;
    private final String sizeRendererUnknown;
    private final String sizeRendererInBytes;
    private NumberFormat numberFormatter;

    SizeCellRenderer(ApplicationContext applicationContext) {
        ResourceMap resourceMap = applicationContext.getResourceMap();
        this.sizeRendererProgress = resourceMap.getString("sizeRendererProgress", new Object[0]);
        this.sizeRendererUnknown = resourceMap.getString("sizeRendererUnknown", new Object[0]);
        this.sizeRendererInBytes = resourceMap.getString("sizeRendererInBytes", new Object[0]);
        this.numberFormatter = NumberFormat.getIntegerInstance();
    }

    @Override
    public final Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        DownloadFile downloadFile;
        long l;
        if (object == null) {
            object = jTable.getValueAt(n, n2);
        }
        if ((l = (downloadFile = (DownloadFile)object).getFileSize()) >= 0L) {
            object = downloadFile.getDownloaded() != l ? String.format(this.sizeRendererProgress, ContentPanel.bytesToAnother(downloadFile.getDownloaded()), ContentPanel.bytesToAnother(l)) : ContentPanel.bytesToAnother(l);
            this.setToolTipText(String.format(this.sizeRendererInBytes, this.numberFormatter.format(l)));
        } else {
            object = this.sizeRendererUnknown;
            this.setToolTipText(null);
        }
        this.getAccessibleContext().setAccessibleName(jTable.getColumnName(n2) + " " + object);
        return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
    }
}

