/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.actions;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.gui.content.ContentPanel;
import cz.vity.freerapid.gui.dialogs.DownloadHistoryDialog;
import cz.vity.freerapid.gui.dialogs.SpeedMeterDialog;
import cz.vity.freerapid.gui.dialogs.UserPreferencesDialog;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.os.OSCommand;
import cz.vity.freerapid.utilities.os.SystemCommander;
import cz.vity.freerapid.utilities.os.SystemCommanderFactory;
import java.awt.Frame;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.SwingUtilities;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.Action;

public class ViewActions
extends AbstractBean {
    private static final Logger logger = Logger.getLogger(ViewActions.class.getName());
    private MainApp app = MainApp.getInstance(MainApp.class);

    public ViewActions() {
        AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                if ("autoshutdown".equals(preferenceChangeEvent.getKey())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ViewActions.this.updateSelectedAction();
                        }
                    });
                }
            }
        });
    }

    private void updateSelectedAction() {
        String string = this.app.getManagerDirector().getMenuManager().getSelectedShutDownAction();
        this.app.getContext().getActionMap().get(string).putValue("SwingSelectedKey", Boolean.TRUE);
    }

    @Action
    public void showStatusBar() {
        AppPrefs.negateProperty("showStatusbar", true);
    }

    @Action
    public void showToolbar() {
        AppPrefs.negateProperty("showToolbar", true);
    }

    protected MainApp getApp() {
        return this.app;
    }

    @Action
    public void showDownloadHistoryAction() {
        ManagerDirector managerDirector = this.app.getManagerDirector();
        DownloadHistoryDialog downloadHistoryDialog = new DownloadHistoryDialog(this.app.getMainFrame(), managerDirector);
        this.app.show(downloadHistoryDialog);
    }

    @Action
    public void showSpeedMonitor() {
        ManagerDirector managerDirector = this.app.getManagerDirector();
        SpeedMeterDialog speedMeterDialog = new SpeedMeterDialog(this.app.getMainFrame(), managerDirector);
        this.app.show(speedMeterDialog);
    }

    @Action
    public void options() {
        try {
            UserPreferencesDialog userPreferencesDialog = new UserPreferencesDialog((Frame)this.app.getMainFrame(), this.app.getContext());
            this.app.prepareDialog(userPreferencesDialog, true);
            this.app.getAppPrefs().store();
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
    }

    @Action
    public void monitorClipboardAction() {
        AppPrefs.negateProperty("clipboardMonitoring", true);
    }

    @Action
    public void globalLimitSpeedAction() {
        AppPrefs.negateProperty("speedLimitEnabled", false);
    }

    @Action
    public void showCompletedAction() {
        AppPrefs.negateProperty("removeCompleted", true);
        ManagerDirector managerDirector = this.app.getManagerDirector();
        ContentPanel contentPanel = managerDirector.getContentManager().getContentPanel();
        contentPanel.updateFilters();
    }

    @Action
    public void shutdownDisabledAction() {
        this.setShutdownProperty(0);
    }

    private void setShutdownProperty(int n) {
        AppPrefs.storeProperty("autoshutdown", n);
    }

    @Action
    public void shutdownQuitAction() {
        this.setShutdownProperty(1);
    }

    @Action
    public void shutdownHibernateAction() {
        this.updateShutdown(OSCommand.HIBERNATE, 5);
    }

    @Action
    public void shutdownShutdownAction() {
        this.updateShutdown(OSCommand.SHUTDOWN, 4);
    }

    @Action
    public void shutdownStandByAction() {
        this.updateShutdown(OSCommand.STANDBY, 2);
    }

    @Action
    public void shutdownRebootAction() {
        this.updateShutdown(OSCommand.REBOOT, 3);
    }

    private void updateShutdown(OSCommand oSCommand, int n) {
        SystemCommander systemCommander = SystemCommanderFactory.getInstance().getSystemCommanderInstance(this.app.getContext());
        if (!systemCommander.isSupported(oSCommand)) {
            this.setShutdownProperty(0);
            Swinger.showErrorMessage(this.app.getContext().getResourceMap(), "systemCommandNotSupported", oSCommand.toString().toLowerCase());
        } else {
            this.setShutdownProperty(n);
        }
    }
}

