/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.tasks;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.tasks.CheckPluginUpdateTask;
import cz.vity.freerapid.core.tasks.ConnectResult;
import cz.vity.freerapid.core.tasks.CoreTask;
import cz.vity.freerapid.core.tasks.exceptions.NoAvailableConnection;
import cz.vity.freerapid.gui.managers.ClientManager;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.DownloadClient;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.Browser;
import cz.vity.freerapid.utilities.LogUtils;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class CheckForNewVersionTask
extends CoreTask<ConnectResult, Void> {
    private static final Logger logger = Logger.getLogger(CheckForNewVersionTask.class.getName());
    private static final String PARAM_VERSION = "version";
    private final boolean showInfoMessages;
    private static int counter = 0;

    public CheckForNewVersionTask(boolean bl) {
        super(Application.getInstance());
        logger.info("Starting to check for a new version");
        this.showInfoMessages = bl;
        this.setUserCanCancel(false);
        this.setDescription("");
        this.setMessage("");
        this.setTaskToForeground();
    }

    @Override
    protected ConnectResult doInBackground() throws Exception {
        if (counter++ > 4) {
            return ConnectResult.SAME_VERSION;
        }
        this.message("message.connecting", new Object[0]);
        String string = AppPrefs.getProperty("checkForNewVersionURL", "http://wordrider.net/checkfrd.php");
        ClientManager clientManager = ((MainApp)this.getApplication()).getManagerDirector().getClientManager();
        List<ConnectionSettings> list = clientManager.getEnabledConnections();
        ResourceMap resourceMap = this.getApplication().getContext().getResourceMap(CheckPluginUpdateTask.class);
        if (list.isEmpty()) {
            throw new NoAvailableConnection(resourceMap.getString("noAvailableConnection", new Object[0]));
        }
        DownloadClient downloadClient = new DownloadClient();
        downloadClient.initClient(list.get(0));
        PostMethod postMethod = downloadClient.getPostMethod(string);
        postMethod.addParameter(PARAM_VERSION, "FreeRapid 0.83u1");
        logger.info("Connected to the web, Writing params");
        this.message("message.connect.status.checking", new Object[0]);
        if (downloadClient.makeRequest((HttpMethod)postMethod, true) != 200) {
            throw new ConnectException(resourceMap.getString("Connection_failed", new Object[0]));
        }
        this.message("message.checkingData", new Object[0]);
        if (this.isCancelled()) {
            throw new InterruptedException();
        }
        logger.info("disconnecting");
        this.message("message.connect.status.disconnect", new Object[0]);
        String string2 = downloadClient.getContentAsString();
        if (string2 != null && string2.toLowerCase().contains("yes")) {
            return ConnectResult.CONNECT_NEW_VERSION;
        }
        return ConnectResult.SAME_VERSION;
    }

    @Override
    protected void succeeded(ConnectResult connectResult) {
        super.succeeded(connectResult);
        switch (connectResult) {
            case SAME_VERSION: {
                if (!this.showInfoMessages) break;
                Swinger.showInformationDialog(this.getResourceMap().getString("message.connect.sameVersion", new Object[0]));
                break;
            }
            case CONNECT_NEW_VERSION: {
                int n = Swinger.getChoiceYesNo(this.getResourceMap().getString("message.connect.newVersion", new Object[0]));
                if (n != 0) break;
                Browser.showHomepage();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Override
    protected void failed(Throwable throwable) {
        LogUtils.processException(logger, throwable);
        if (this.handleRuntimeException(throwable)) {
            return;
        }
        if (!this.showInfoMessages) {
            return;
        }
        if (throwable instanceof UnknownHostException) {
            Swinger.showErrorMessage(this.getResourceMap(), "errormessage_check_inet_settings", new Object[0]);
        } else {
            Swinger.showErrorMessage(this.getResourceMap(), "errormessage_submit_failed", throwable.getMessage());
        }
    }
}

