/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.swingx;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.border.IconBorder;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.event.DateSelectionEvent;
import org.jdesktop.swingx.event.DateSelectionListener;
import org.jdesktop.swingx.plaf.basic.BasicMonthViewUI;
import org.jdesktop.swingx.plaf.basic.CalendarState;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.animation.FadeConfigurationManager;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.animation.FadeTrackerAdapter;
import org.jvnet.lafwidget.animation.FadeTrackerCallback;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.api.ColorSchemeAssociationKind;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.painter.utils.BackgroundPaintingUtils;
import org.jvnet.substance.painter.utils.HighlightPainterUtils;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;
import org.jvnet.substance.utils.SubstanceImageCreator;
import org.jvnet.substance.utils.SubstanceTextUtilities;
import org.jvnet.substance.utils.Trackable;

public class SubstanceMonthViewUI
extends BasicMonthViewUI
implements Trackable {
    protected Set lafWidgets;
    protected DayRolloverFadeListener substanceFadeRolloverListener;
    protected int rolloverDayId = -1;
    protected int rolloverMonthId = -1;
    protected int rolloverYearId = -1;
    protected Set<String> selectedIndices;
    protected DateSelectionListener substanceFadeSelectionListener;
    private Map<String, ComponentState> prevDayStateMap = new HashMap<String, ComponentState>();
    private Map<String, ComponentState> nextDayStateMap = new HashMap<String, ComponentState>();
    private Map<String, ComponentState> prevMonthStateMap = new HashMap<String, ComponentState>();
    private Map<String, ComponentState> nextMonthStateMap = new HashMap<String, ComponentState>();

    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, (float)f));
        object = RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        this.__org__jvnet__substance__swingx__SubstanceMonthViewUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    protected void __org__jvnet__substance__swingx__SubstanceMonthViewUI__installComponents() {
        super.installComponents();
    }

    protected void installComponents() {
        this.__org__jvnet__substance__swingx__SubstanceMonthViewUI__installComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    public void __org__jvnet__substance__swingx__SubstanceMonthViewUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__swingx__SubstanceMonthViewUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__jvnet__substance__swingx__SubstanceMonthViewUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__swingx__SubstanceMonthViewUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    protected void installListeners() {
        this.__org__jvnet__substance__swingx__SubstanceMonthViewUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    protected void installDefaults() {
        this.__org__jvnet__substance__swingx__SubstanceMonthViewUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    protected void __org__jvnet__substance__swingx__SubstanceMonthViewUI__uninstallComponents() {
        super.uninstallComponents();
    }

    protected void uninstallComponents() {
        this.__org__jvnet__substance__swingx__SubstanceMonthViewUI__uninstallComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    protected void uninstallListeners() {
        this.__org__jvnet__substance__swingx__SubstanceMonthViewUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    protected void uninstallDefaults() {
        this.__org__jvnet__substance__swingx__SubstanceMonthViewUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new SubstanceMonthViewUI();
    }

    public SubstanceMonthViewUI() {
        this.selectedIndices = new HashSet<String>();
    }

    protected void __org__jvnet__substance__swingx__SubstanceMonthViewUI__installDefaults() {
        super.installDefaults();
        BasicLookAndFeel.installColors((JComponent)this.monthView, "JXMonthView.background", "JXMonthView.foreground");
        Calendar cal = this.monthView.getCalendar();
        if (cal != null) {
            for (Date selected : this.getSelection()) {
                cal.setTime(selected);
                int day = cal.get(5);
                int month = cal.get(2);
                int year = cal.get(1);
                this.selectedIndices.add(day + ":" + month + ":" + year);
            }
        }
    }

    protected void installDelegate() {
        super.installDelegate();
        this.monthDownImage = SubstanceImageCreator.getArrowIcon((int)this.monthView.getFont().getSize(), (int)7, (SubstanceColorScheme)SubstanceColorSchemeUtilities.getColorScheme((Component)this.monthView, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.MARK, (ComponentState)ComponentState.DEFAULT));
        this.monthUpImage = SubstanceImageCreator.getArrowIcon((int)this.monthView.getFont().getSize(), (int)3, (SubstanceColorScheme)SubstanceColorSchemeUtilities.getColorScheme((Component)this.monthView, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.MARK, (ComponentState)ComponentState.DEFAULT));
    }

    protected void __org__jvnet__substance__swingx__SubstanceMonthViewUI__installListeners() {
        super.installListeners();
        this.substanceFadeRolloverListener = new DayRolloverFadeListener();
        this.monthView.addMouseMotionListener((MouseMotionListener)this.substanceFadeRolloverListener);
        this.monthView.addMouseListener((MouseListener)this.substanceFadeRolloverListener);
        this.substanceFadeSelectionListener = new DateSelectionListener(){

            protected void cancelFades(Set<Long> initiatedFadeSequences) {
                FadeTracker fadeTrackerInstance = FadeTracker.getInstance();
                for (long fadeId : initiatedFadeSequences) {
                    fadeTrackerInstance.cancelFadeInstance(fadeId);
                }
            }

            public void valueChanged(DateSelectionEvent ev) {
                if (LafWidgetUtilities.hasNoFades((Component)SubstanceMonthViewUI.this.monthView, (FadeKind)FadeKind.SELECTION)) {
                    return;
                }
                HashSet<Long> initiatedFadeSequences = new HashSet<Long>();
                boolean fadeCanceled = false;
                Calendar cal = SubstanceMonthViewUI.this.monthView.getCalendar();
                cal.set(5, 1);
                int month = cal.get(2);
                DateSelectionModel selectionModel = SubstanceMonthViewUI.this.monthView.getSelectionModel();
                FadeTracker fadeTrackerInstance = FadeTracker.getInstance();
                while (cal.get(2) == month) {
                    long fadeId;
                    int dayIndex = cal.get(5);
                    int monthIndex = cal.get(2);
                    int yearIndex = cal.get(1);
                    String index = dayIndex + ":" + monthIndex + ":" + yearIndex;
                    if (selectionModel.isSelected(cal.getTime())) {
                        if (!SubstanceMonthViewUI.this.selectedIndices.contains(dayIndex)) {
                            if (!fadeCanceled) {
                                fadeId = fadeTrackerInstance.trackFadeIn(FadeKind.SELECTION, (Component)SubstanceMonthViewUI.this.monthView, (Comparable)((Object)index), false, (FadeTrackerCallback)new DayRepaintCallback(SubstanceMonthViewUI.this.monthView, dayIndex, monthIndex, yearIndex));
                                initiatedFadeSequences.add(fadeId);
                                if (initiatedFadeSequences.size() > 25) {
                                    this.cancelFades(initiatedFadeSequences);
                                    initiatedFadeSequences.clear();
                                    fadeCanceled = true;
                                }
                            }
                            SubstanceMonthViewUI.this.selectedIndices.add(index);
                        }
                    } else if (SubstanceMonthViewUI.this.selectedIndices.contains(dayIndex)) {
                        if (!fadeCanceled) {
                            fadeId = fadeTrackerInstance.trackFadeOut(FadeKind.SELECTION, (Component)SubstanceMonthViewUI.this.monthView, (Comparable)((Object)index), false, (FadeTrackerCallback)new DayRepaintCallback(SubstanceMonthViewUI.this.monthView, dayIndex, monthIndex, yearIndex));
                            initiatedFadeSequences.add(fadeId);
                            if (initiatedFadeSequences.size() > 25) {
                                this.cancelFades(initiatedFadeSequences);
                                initiatedFadeSequences.clear();
                                fadeCanceled = true;
                            }
                        }
                        SubstanceMonthViewUI.this.selectedIndices.remove(dayIndex);
                    }
                    cal.add(5, 1);
                }
            }
        };
        this.monthView.getSelectionModel().addDateSelectionListener(this.substanceFadeSelectionListener);
    }

    protected void __org__jvnet__substance__swingx__SubstanceMonthViewUI__uninstallListeners() {
        this.monthView.getSelectionModel().removeDateSelectionListener(this.substanceFadeSelectionListener);
        this.substanceFadeSelectionListener = null;
        this.monthView.removeMouseListener((MouseListener)this.substanceFadeRolloverListener);
        this.monthView.removeMouseMotionListener((MouseMotionListener)this.substanceFadeRolloverListener);
        this.substanceFadeRolloverListener = null;
        super.uninstallListeners();
    }

    protected void __org__jvnet__substance__swingx__SubstanceMonthViewUI__uninstallDefaults() {
        this.selectedIndices.clear();
        super.uninstallDefaults();
    }

    public boolean isInside(MouseEvent me) {
        return true;
    }

    public ComponentState getDayState(int dayIndex, int monthIndex, int yearIndex) {
        DefaultButtonModel synthModel = new DefaultButtonModel();
        synthModel.setEnabled(this.monthView.isEnabled());
        synthModel.setRollover(this.rolloverDayId >= 0 && this.rolloverDayId == dayIndex && this.rolloverMonthId >= 0 && this.rolloverMonthId == monthIndex && this.rolloverYearId >= 0 && this.rolloverYearId == yearIndex);
        Calendar cal = this.monthView.getCalendar();
        cal.set(5, dayIndex);
        cal.set(2, monthIndex);
        cal.set(1, yearIndex);
        synthModel.setSelected(this.monthView.isSelected(cal.getTime()));
        return ComponentState.getState((ButtonModel)synthModel, null);
    }

    public ComponentState getMonthState(int monthIndex, int yearIndex) {
        DefaultButtonModel synthModel = new DefaultButtonModel();
        synthModel.setEnabled(this.monthView.isEnabled());
        synthModel.setRollover(this.rolloverMonthId >= 0 && this.rolloverMonthId == monthIndex && this.rolloverYearId >= 0 && this.rolloverYearId == yearIndex);
        return ComponentState.getState((ButtonModel)synthModel, null);
    }

    public ComponentState getPrevDayState(int dayIndex, int monthIndex, int yearIndex) {
        String key = dayIndex + ":" + monthIndex + ":" + yearIndex;
        if (this.prevDayStateMap.containsKey(key)) {
            return this.prevDayStateMap.get(key);
        }
        return ComponentState.DEFAULT;
    }

    public ComponentState getPrevMonthState(int monthIndex, int yearIndex) {
        String key = monthIndex + ":" + yearIndex;
        if (this.prevMonthStateMap.containsKey(key)) {
            return this.prevMonthStateMap.get(key);
        }
        return ComponentState.DEFAULT;
    }

    public void resetRolloverIndex() {
        this.rolloverDayId = -1;
        this.rolloverMonthId = -1;
        this.rolloverYearId = -1;
    }

    protected BasicMonthViewUI.RenderingHandler createRenderingHandler() {
        return new SubstanceRenderingHandler();
    }

    protected void paintMonthHeader(Graphics g, Calendar calendar) {
        Rectangle page = this.getMonthHeaderBounds(calendar.getTime(), false);
        int month = calendar.get(2);
        int year = calendar.get(1);
        Graphics2D g2d = (Graphics2D)g.create();
        ComponentState componentState = this.monthView.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED;
        float fillAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)this.monthView, (ComponentState)componentState);
        g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.monthView, (float)fillAlpha, (Graphics)g));
        HighlightPainterUtils.paintHighlight((Graphics)g2d, null, (Component)this.monthView, (Rectangle)page, (float)0.5f, null, (ComponentState)componentState, (ComponentState)componentState, (float)0.0f);
        g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.monthView, (Graphics)g));
        ComponentState prevState = this.getPrevMonthState(month, year);
        ComponentState currState = this.getMonthState(month, year);
        float startAlpha = SubstanceColorSchemeUtilities.getHighlightAlpha((Component)this.monthView, (ComponentState)prevState);
        float endAlpha = SubstanceColorSchemeUtilities.getHighlightAlpha((Component)this.monthView, (ComponentState)currState);
        FadeState state = SubstanceFadeUtilities.getFadeState((Component)this.monthView, (Comparable)((Object)(month + ":" + year)), (FadeKind[])new FadeKind[]{FadeKind.ROLLOVER});
        float totalAlpha = endAlpha;
        float fadeCoef = 0.0f;
        if (state != null) {
            fadeCoef = state.getFadePosition();
            totalAlpha = state.isFadingIn() ? startAlpha + (endAlpha - startAlpha) * fadeCoef : startAlpha + (endAlpha - startAlpha) * (1.0f - fadeCoef);
            if (state.isFadingIn()) {
                fadeCoef = 1.0f - fadeCoef;
            }
        }
        SubstanceColorScheme prevScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.monthView, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.HIGHLIGHT, (ComponentState)prevState);
        SubstanceColorScheme currScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.monthView, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.HIGHLIGHT, (ComponentState)currState);
        SubstanceColorScheme prevBorderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.monthView, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.BORDER, (ComponentState)prevState);
        SubstanceColorScheme currBorderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.monthView, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.BORDER, (ComponentState)currState);
        if (totalAlpha > 0.0f) {
            g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.monthView, (float)totalAlpha, (Graphics)g));
            HighlightPainterUtils.paintHighlight((Graphics)g2d, null, (Component)this.monthView, (Rectangle)page, (float)0.5f, null, (SubstanceColorScheme)currScheme, (SubstanceColorScheme)prevScheme, (SubstanceColorScheme)currBorderScheme, (SubstanceColorScheme)prevBorderScheme, (float)fadeCoef);
            g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.monthView, (Graphics)g));
        }
        g2d.dispose();
        super.paintMonthHeader(g, calendar);
    }

    protected void paintDayOfMonth(Graphics g, Rectangle bounds, Calendar calendar, CalendarState state) {
        if (state == CalendarState.IN_MONTH || state == CalendarState.TODAY) {
            Graphics2D graphics = (Graphics2D)g.create();
            int day = calendar.get(5);
            int month = calendar.get(2);
            int year = calendar.get(1);
            if (this.isToday(calendar.getTime())) {
                graphics.setColor(this.monthView.getTodayBackground());
                graphics.drawRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
            }
            ComponentState prevState = this.getPrevDayState(day, month, year);
            ComponentState currState = this.getDayState(day, month, year);
            float startAlpha = SubstanceColorSchemeUtilities.getHighlightAlpha((Component)this.monthView, (ComponentState)prevState);
            float endAlpha = SubstanceColorSchemeUtilities.getHighlightAlpha((Component)this.monthView, (ComponentState)currState);
            FadeState fadeState = SubstanceFadeUtilities.getFadeState((Component)this.monthView, (Comparable)((Object)(day + ":" + month + ":" + year)), (FadeKind[])new FadeKind[]{FadeKind.SELECTION, FadeKind.ROLLOVER});
            float totalAlpha = endAlpha;
            float fadeCoef = 0.0f;
            if (fadeState != null) {
                fadeCoef = fadeState.getFadePosition();
                totalAlpha = fadeState.isFadingIn() ? startAlpha + (endAlpha - startAlpha) * fadeCoef : startAlpha + (endAlpha - startAlpha) * (1.0f - fadeCoef) / 1.0f;
                if (fadeState.isFadingIn()) {
                    fadeCoef = 1.0f - fadeCoef;
                }
            }
            if (totalAlpha > 0.0f) {
                graphics.setComposite(TransitionLayout.getAlphaComposite((Component)this.monthView, (float)totalAlpha, (Graphics)g));
                HighlightPainterUtils.paintHighlight((Graphics)graphics, null, (Component)this.monthView, (Rectangle)bounds, (float)0.5f, null, (ComponentState)currState, (ComponentState)prevState, (float)fadeCoef);
                graphics.setComposite(TransitionLayout.getAlphaComposite((Component)this.monthView, (Graphics)g));
            }
            graphics.dispose();
        }
        super.paintDayOfMonth(g, bounds, calendar, state);
    }

    public void __org__jvnet__substance__swingx__SubstanceMonthViewUI__update(Graphics g, JComponent c) {
        BackgroundPaintingUtils.update((Graphics)g, (Component)this.monthView, (boolean)false);
        this.paint(g, c);
    }

    protected class SubstanceRenderingHandler
    extends BasicMonthViewUI.RenderingHandler {
        protected SubstanceRenderingHandler() {
        }

        public JComponent prepareRenderingComponent(JXMonthView monthView, Calendar calendar, CalendarState dayState) {
            ComponentState prevState;
            ComponentState state;
            JComponent result = super.prepareRenderingComponent(monthView, calendar, dayState);
            int day = calendar.get(5);
            int month = calendar.get(2);
            int year = calendar.get(1);
            if (dayState == CalendarState.IN_MONTH || dayState == CalendarState.TODAY) {
                state = SubstanceMonthViewUI.this.getDayState(day, month, year);
                prevState = SubstanceMonthViewUI.this.getPrevDayState(day, month, year);
                Color customFgColor = monthView.getDayForeground(calendar.get(7));
                boolean isForegroundUiResource = customFgColor instanceof UIResource;
                Color fgColor = customFgColor;
                if (isForegroundUiResource) {
                    if (monthView.isEnabled()) {
                        fgColor = SubstanceColorUtilities.getInterpolatedForegroundColor((Component)monthView, (Comparable)((Object)(day + ":" + month + ":" + year)), (SubstanceColorScheme)SubstanceColorSchemeUtilities.getColorScheme((Component)monthView, (ComponentState)state), (ComponentState)state, (SubstanceColorScheme)SubstanceColorSchemeUtilities.getColorScheme((Component)monthView, (ComponentState)prevState), (ComponentState)prevState, (FadeKind[])new FadeKind[]{FadeKind.ROLLOVER, FadeKind.SELECTION});
                    } else {
                        float textAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)monthView, (ComponentState)ComponentState.DISABLED_UNSELECTED);
                        fgColor = SubstanceTextUtilities.getForegroundColor((JComponent)monthView, (String)" ", (ComponentState)ComponentState.DISABLED_UNSELECTED, (ComponentState)ComponentState.DISABLED_UNSELECTED, (float)textAlpha);
                    }
                }
                result.setForeground(fgColor);
            }
            if (dayState == CalendarState.TITLE) {
                state = SubstanceMonthViewUI.this.getMonthState(month, year);
                prevState = SubstanceMonthViewUI.this.getPrevMonthState(month, year);
                Color fgColor = SubstanceColorUtilities.getInterpolatedForegroundColor((Component)monthView, (Comparable)((Object)(month + ":" + year)), (SubstanceColorScheme)SubstanceColorSchemeUtilities.getColorScheme((Component)monthView, (ComponentState)state), (ComponentState)state, (SubstanceColorScheme)SubstanceColorSchemeUtilities.getColorScheme((Component)monthView, (ComponentState)prevState), (ComponentState)prevState, (FadeKind[])new FadeKind[]{FadeKind.ROLLOVER, FadeKind.SELECTION});
                result.setForeground(fgColor);
            }
            if (dayState == CalendarState.LEADING || dayState == CalendarState.TRAILING) {
                float textAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)monthView, (ComponentState)ComponentState.DISABLED_UNSELECTED);
                result.setForeground(SubstanceTextUtilities.getForegroundColor((JComponent)monthView, (String)" ", (ComponentState)ComponentState.DISABLED_UNSELECTED, (ComponentState)ComponentState.DISABLED_UNSELECTED, (float)textAlpha));
            }
            if (dayState == CalendarState.TITLE) {
                result.setBorder(this.getTitleBorder());
            }
            result.setOpaque(false);
            return result;
        }

        private Border getTitleBorder() {
            if (SubstanceMonthViewUI.this.monthView.isTraversable()) {
                IconBorder up = new IconBorder(SubstanceMonthViewUI.this.monthUpImage, 3, SubstanceMonthViewUI.this.monthView.getBoxPaddingX());
                IconBorder down = new IconBorder(SubstanceMonthViewUI.this.monthDownImage, 7, SubstanceMonthViewUI.this.monthView.getBoxPaddingX());
                CompoundBorder compound = BorderFactory.createCompoundBorder((Border)up, (Border)down);
                Border empty = BorderFactory.createEmptyBorder(2 * SubstanceMonthViewUI.this.monthView.getBoxPaddingY(), 0, 2 * SubstanceMonthViewUI.this.monthView.getBoxPaddingY(), 0);
                return BorderFactory.createCompoundBorder(compound, empty);
            }
            return BorderFactory.createEmptyBorder(SubstanceMonthViewUI.this.monthView.getBoxPaddingY(), SubstanceMonthViewUI.this.monthView.getBoxPaddingX(), SubstanceMonthViewUI.this.monthView.getBoxPaddingY(), SubstanceMonthViewUI.this.monthView.getBoxPaddingX());
        }
    }

    protected class DayRepaintCallback
    extends FadeTrackerAdapter {
        protected JXMonthView monthView;
        protected int dayIndex;
        protected int monthIndex;
        protected int yearIndex;

        public DayRepaintCallback(JXMonthView monthView, int dayIndex, int monthIndex, int yearIndex) {
            this.monthView = monthView;
            this.dayIndex = dayIndex;
            this.monthIndex = monthIndex;
            this.yearIndex = yearIndex;
        }

        public void fadeEnded(FadeKind fadeKind) {
            String key = this.dayIndex + ":" + this.monthIndex + ":" + this.yearIndex;
            if (this.monthView == SubstanceMonthViewUI.this.monthView) {
                ComponentState currState = SubstanceMonthViewUI.this.getDayState(this.dayIndex, this.monthIndex, this.yearIndex);
                if (currState == ComponentState.DEFAULT) {
                    SubstanceMonthViewUI.this.prevDayStateMap.remove(key);
                    SubstanceMonthViewUI.this.nextDayStateMap.remove(key);
                } else {
                    SubstanceMonthViewUI.this.prevDayStateMap.put(key, currState);
                    SubstanceMonthViewUI.this.nextDayStateMap.put(key, currState);
                }
            }
            this.repaintCell();
        }

        public void fadeReversed(FadeKind fadeKind, boolean isFadingIn, float fadeCycle10) {
            if (this.monthView == SubstanceMonthViewUI.this.monthView) {
                String key = this.dayIndex + ":" + this.monthIndex + ":" + this.yearIndex;
                ComponentState nextState = (ComponentState)SubstanceMonthViewUI.this.nextDayStateMap.get(key);
                if (nextState == null) {
                    SubstanceMonthViewUI.this.prevDayStateMap.remove(key);
                } else {
                    SubstanceMonthViewUI.this.prevDayStateMap.put(key, nextState);
                }
            }
            this.repaintCell();
        }

        public void fadePerformed(FadeKind fadeKind, float fade) {
            if (this.monthView == SubstanceMonthViewUI.this.monthView) {
                String key = this.dayIndex + ":" + this.monthIndex + ":" + this.yearIndex;
                SubstanceMonthViewUI.this.nextDayStateMap.put(key, SubstanceMonthViewUI.this.getDayState(this.dayIndex, this.monthIndex, this.yearIndex));
            }
            this.repaintCell();
        }

        private void repaintCell() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (DayRepaintCallback.this.monthView != SubstanceMonthViewUI.this.monthView) {
                        return;
                    }
                    Calendar cal = DayRepaintCallback.this.monthView.getCalendar();
                    cal.set(5, DayRepaintCallback.this.dayIndex);
                    cal.set(2, DayRepaintCallback.this.monthIndex);
                    cal.set(1, DayRepaintCallback.this.yearIndex);
                    Rectangle dayBounds = SubstanceMonthViewUI.this.getDayBounds(cal.getTime());
                    if (dayBounds != null) {
                        DayRepaintCallback.this.monthView.repaint(dayBounds);
                    }
                }
            });
        }
    }

    protected class MonthRepaintCallback
    extends FadeTrackerAdapter {
        protected JXMonthView monthView;
        protected int monthIndex;
        protected int yearIndex;

        public MonthRepaintCallback(JXMonthView monthView, int monthIndex, int yearIndex) {
            this.monthView = monthView;
            this.monthIndex = monthIndex;
            this.yearIndex = yearIndex;
        }

        public void fadeEnded(FadeKind fadeKind) {
            if (this.monthView == SubstanceMonthViewUI.this.monthView) {
                String key = this.monthIndex + ":" + this.yearIndex;
                ComponentState currState = SubstanceMonthViewUI.this.getMonthState(this.monthIndex, this.yearIndex);
                if (currState == ComponentState.DEFAULT) {
                    SubstanceMonthViewUI.this.prevMonthStateMap.remove(key);
                    SubstanceMonthViewUI.this.nextMonthStateMap.remove(key);
                } else {
                    SubstanceMonthViewUI.this.prevMonthStateMap.put(key, currState);
                    SubstanceMonthViewUI.this.nextMonthStateMap.put(key, currState);
                }
            }
            this.repaintCell();
        }

        public void fadeReversed(FadeKind fadeKind, boolean isFadingIn, float fadeCycle10) {
            if (this.monthView == SubstanceMonthViewUI.this.monthView) {
                String key = this.monthIndex + ":" + this.yearIndex;
                ComponentState nextState = (ComponentState)SubstanceMonthViewUI.this.nextMonthStateMap.get(key);
                if (nextState == null) {
                    SubstanceMonthViewUI.this.prevMonthStateMap.remove(key);
                } else {
                    SubstanceMonthViewUI.this.prevMonthStateMap.put(key, nextState);
                }
            }
            this.repaintCell();
        }

        public void fadePerformed(FadeKind fadeKind, float fade) {
            if (this.monthView == SubstanceMonthViewUI.this.monthView) {
                String key = this.monthIndex + ":" + this.yearIndex;
                SubstanceMonthViewUI.this.nextMonthStateMap.put(key, SubstanceMonthViewUI.this.getMonthState(this.monthIndex, this.yearIndex));
            }
            this.repaintCell();
        }

        private void repaintCell() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (MonthRepaintCallback.this.monthView != SubstanceMonthViewUI.this.monthView) {
                        return;
                    }
                    Calendar cal = MonthRepaintCallback.this.monthView.getCalendar();
                    cal.set(2, MonthRepaintCallback.this.monthIndex);
                    cal.set(1, MonthRepaintCallback.this.yearIndex);
                    Rectangle monthBounds = SubstanceMonthViewUI.this.getMonthBounds(cal.getTime());
                    if (monthBounds != null) {
                        MonthRepaintCallback.this.monthView.repaint(monthBounds);
                    }
                }
            });
        }
    }

    private class DayRolloverFadeListener
    implements MouseListener,
    MouseMotionListener {
        private DayRolloverFadeListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.fadeOutDay();
            this.fadeOutMonth();
            SubstanceMonthViewUI.this.resetRolloverIndex();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!SubstanceMonthViewUI.this.monthView.isEnabled()) {
                return;
            }
            this.handleMove(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!SubstanceMonthViewUI.this.monthView.isEnabled()) {
                return;
            }
            this.handleMove(e);
        }

        private void handleMove(MouseEvent e) {
            boolean fadeAllowed = FadeConfigurationManager.getInstance().fadeAllowed(FadeKind.ROLLOVER, (Component)SubstanceMonthViewUI.this.monthView);
            if (!fadeAllowed) {
                this.fadeOutDay();
                this.fadeOutMonth();
                SubstanceMonthViewUI.this.resetRolloverIndex();
                return;
            }
            Date matchingDay = SubstanceMonthViewUI.this.monthView.getDayAtLocation(e.getX(), e.getY());
            if (matchingDay == null) {
                this.fadeOutDay();
                this.fadeOutMonth();
                SubstanceMonthViewUI.this.resetRolloverIndex();
            } else {
                Rectangle monthBounds = SubstanceMonthViewUI.this.getMonthBounds(matchingDay);
                if (monthBounds == null || !monthBounds.contains(e.getPoint())) {
                    this.fadeOutDay();
                    this.fadeOutMonth();
                    SubstanceMonthViewUI.this.resetRolloverIndex();
                } else {
                    boolean isDifferentMonth;
                    Calendar cal = SubstanceMonthViewUI.this.monthView.getCalendar();
                    cal.setTime(matchingDay);
                    int roIndexDay = cal.get(5);
                    int roIndexMonth = cal.get(2);
                    int roIndexYear = cal.get(1);
                    if (SubstanceMonthViewUI.this.rolloverDayId >= 0 && SubstanceMonthViewUI.this.rolloverDayId == roIndexDay && SubstanceMonthViewUI.this.rolloverMonthId >= 0 && SubstanceMonthViewUI.this.rolloverMonthId == roIndexMonth && SubstanceMonthViewUI.this.rolloverYearId >= 0 && SubstanceMonthViewUI.this.rolloverYearId == roIndexYear) {
                        return;
                    }
                    this.fadeOutDay();
                    boolean bl = isDifferentMonth = SubstanceMonthViewUI.this.rolloverMonthId != roIndexMonth;
                    if (isDifferentMonth) {
                        this.fadeOutMonth();
                    }
                    SubstanceMonthViewUI.this.rolloverDayId = roIndexDay;
                    SubstanceMonthViewUI.this.rolloverMonthId = roIndexMonth;
                    SubstanceMonthViewUI.this.rolloverYearId = roIndexYear;
                    FadeTracker.getInstance().trackFadeIn(FadeKind.ROLLOVER, (Component)SubstanceMonthViewUI.this.monthView, (Comparable)((Object)(SubstanceMonthViewUI.this.rolloverDayId + ":" + SubstanceMonthViewUI.this.rolloverMonthId + ":" + SubstanceMonthViewUI.this.rolloverYearId)), false, (FadeTrackerCallback)new DayRepaintCallback(SubstanceMonthViewUI.this.monthView, SubstanceMonthViewUI.this.rolloverDayId, SubstanceMonthViewUI.this.rolloverMonthId, SubstanceMonthViewUI.this.rolloverYearId));
                    if (isDifferentMonth) {
                        FadeTracker.getInstance().trackFadeIn(FadeKind.ROLLOVER, (Component)SubstanceMonthViewUI.this.monthView, (Comparable)((Object)(SubstanceMonthViewUI.this.rolloverMonthId + ":" + SubstanceMonthViewUI.this.rolloverYearId)), false, (FadeTrackerCallback)new MonthRepaintCallback(SubstanceMonthViewUI.this.monthView, SubstanceMonthViewUI.this.rolloverMonthId, SubstanceMonthViewUI.this.rolloverYearId));
                    }
                }
            }
        }

        private void fadeOutDay() {
            if (SubstanceMonthViewUI.this.rolloverDayId < 0 || SubstanceMonthViewUI.this.rolloverMonthId < 0 || SubstanceMonthViewUI.this.rolloverYearId < 0) {
                return;
            }
            FadeTracker.getInstance().trackFadeOut(FadeKind.ROLLOVER, (Component)SubstanceMonthViewUI.this.monthView, (Comparable)((Object)(SubstanceMonthViewUI.this.rolloverDayId + ":" + SubstanceMonthViewUI.this.rolloverMonthId + ":" + SubstanceMonthViewUI.this.rolloverYearId)), false, (FadeTrackerCallback)new DayRepaintCallback(SubstanceMonthViewUI.this.monthView, SubstanceMonthViewUI.this.rolloverDayId, SubstanceMonthViewUI.this.rolloverMonthId, SubstanceMonthViewUI.this.rolloverYearId));
        }

        private void fadeOutMonth() {
            if (SubstanceMonthViewUI.this.rolloverMonthId < 0 || SubstanceMonthViewUI.this.rolloverYearId < 0) {
                return;
            }
            FadeTracker.getInstance().trackFadeOut(FadeKind.ROLLOVER, (Component)SubstanceMonthViewUI.this.monthView, (Comparable)((Object)(SubstanceMonthViewUI.this.rolloverMonthId + ":" + SubstanceMonthViewUI.this.rolloverYearId)), false, (FadeTrackerCallback)new MonthRepaintCallback(SubstanceMonthViewUI.this.monthView, SubstanceMonthViewUI.this.rolloverMonthId, SubstanceMonthViewUI.this.rolloverYearId));
        }
    }
}

