/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.util;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class Utilities {
    public static final int OS_WINNT = 1;
    public static final int OS_WIN95 = 2;
    public static final int OS_WIN98 = 4;
    public static final int OS_SOLARIS = 8;
    public static final int OS_LINUX = 16;
    public static final int OS_HP = 32;
    public static final int OS_AIX = 64;
    public static final int OS_IRIX = 128;
    public static final int OS_SUNOS = 256;
    public static final int OS_TRU64 = 512;
    public static final int OS_OS2 = 2048;
    public static final int OS_MAC = 4096;
    public static final int OS_WIN2000 = 8192;
    public static final int OS_VMS = 16384;
    public static final int OS_WIN_OTHER = 32768;
    public static final int OS_OTHER = 65536;
    public static final int OS_FREEBSD = 131072;
    public static final int OS_WINDOWS_MASK = 40967;
    public static final int OS_UNIX_MASK = 136184;
    public static final int TYPICAL_WINDOWS_TASKBAR_HEIGHT = 27;
    private static int operatingSystem = -1;
    private static Reference<Object> namesAndValues;

    public static int getOperatingSystem() {
        if (operatingSystem == -1) {
            String string = System.getProperty("os.name");
            operatingSystem = "Windows NT".equals(string) ? 1 : ("Windows 95".equals(string) ? 2 : ("Windows 98".equals(string) ? 4 : ("Windows 2000".equals(string) ? 8192 : (string.startsWith("Windows ") ? 32768 : ("Solaris".equals(string) ? 8 : (string.startsWith("SunOS") ? 8 : (string.endsWith("Linux") ? 16 : ("HP-UX".equals(string) ? 32 : ("AIX".equals(string) ? 64 : ("Irix".equals(string) ? 128 : ("SunOS".equals(string) ? 256 : ("Digital UNIX".equals(string) ? 512 : ("OS/2".equals(string) ? 2048 : ("OpenVMS".equals(string) ? 16384 : (string.equals("Mac OS X") ? 4096 : (string.startsWith("Darwin") ? 4096 : (string.toLowerCase(Locale.US).startsWith("freebsd") ? 131072 : 65536)))))))))))))))));
        }
        return operatingSystem;
    }

    public static boolean isWindows() {
        return (Utilities.getOperatingSystem() & 0xA007) != 0;
    }

    public static boolean isUnix() {
        return (Utilities.getOperatingSystem() & 0x213F8) != 0;
    }

    public static boolean isLargeFrameIcons() {
        return Utilities.getOperatingSystem() == 8 || Utilities.getOperatingSystem() == 32;
    }

    private static GraphicsConfiguration getCurrentGraphicsConfiguration() {
        Window window;
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component != null && (window = SwingUtilities.getWindowAncestor(component)) != null) {
            return window.getGraphicsConfiguration();
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public static Rectangle getUsableScreenBounds() {
        return Utilities.getUsableScreenBounds(Utilities.getCurrentGraphicsConfiguration());
    }

    public static Rectangle getUsableScreenBounds(GraphicsConfiguration graphicsConfiguration) {
        if (graphicsConfiguration == null) {
            graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        Rectangle rectangle = new Rectangle(graphicsConfiguration.getBounds());
        String string = System.getProperty("netbeans.screen.insets");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
            if (stringTokenizer.countTokens() == 4) {
                try {
                    rectangle.y = Integer.parseInt(stringTokenizer.nextToken());
                    rectangle.x = Integer.parseInt(stringTokenizer.nextToken());
                    rectangle.height -= rectangle.y + Integer.parseInt(stringTokenizer.nextToken());
                    rectangle.width -= rectangle.x + Integer.parseInt(stringTokenizer.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    Logger.getAnonymousLogger().log(Level.WARNING, null, numberFormatException);
                }
            }
            return rectangle;
        }
        string = System.getProperty("netbeans.taskbar.height");
        if (string != null) {
            rectangle.height -= Integer.getInteger(string, 0).intValue();
            return rectangle;
        }
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Insets insets = toolkit.getScreenInsets(graphicsConfiguration);
            rectangle.y += insets.top;
            rectangle.x += insets.left;
            rectangle.height -= insets.top + insets.bottom;
            rectangle.width -= insets.left + insets.right;
        }
        catch (Exception exception) {
            Logger.getAnonymousLogger().log(Level.WARNING, null, exception);
        }
        return rectangle;
    }

    private static synchronized HashMap[] initNameAndValues() {
        Object[] objectArray;
        if (namesAndValues != null && (objectArray = (HashMap[])namesAndValues.get()) != null) {
            return objectArray;
        }
        try {
            objectArray = KeyEvent.class.getDeclaredFields();
        }
        catch (SecurityException securityException) {
            objectArray = new Field[]{};
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(objectArray.length * 4 / 3 + 5, 0.75f);
        HashMap<Integer, String> hashMap2 = new HashMap<Integer, String>(objectArray.length * 4 / 3 + 5, 0.75f);
        for (int i = 0; i < objectArray.length; ++i) {
            String string;
            if (!Modifier.isStatic(((Field)objectArray[i]).getModifiers()) || !(string = ((Field)objectArray[i]).getName()).startsWith("VK_")) continue;
            string = string.substring(3);
            try {
                int n = ((Field)objectArray[i]).getInt(null);
                Integer n2 = new Integer(n);
                hashMap.put(string, n2);
                hashMap2.put(n2, string);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (hashMap.get("CONTEXT_MENU") == null) {
            Integer n = new Integer(524);
            hashMap.put("CONTEXT_MENU", n);
            hashMap2.put(n, "CONTEXT_MENU");
            n = new Integer(525);
            hashMap.put("WINDOWS", n);
            hashMap2.put(n, "WINDOWS");
        }
        HashMap[] hashMapArray = new HashMap[]{hashMap, hashMap2};
        namesAndValues = new SoftReference<HashMap[]>(hashMapArray);
        return hashMapArray;
    }

    public static String keyToString(KeyStroke keyStroke) {
        HashMap[] hashMapArray;
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (Utilities.addModifiers(stringBuffer, keyStroke.getModifiers())) {
            stringBuffer.append('-');
        }
        if ((string = (String)(hashMapArray = Utilities.initNameAndValues())[1].get(new Integer(keyStroke.getKeyCode()))) == null) {
            stringBuffer.append(keyStroke.getKeyChar());
        } else {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static KeyStroke stringToKey(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.toUpperCase(Locale.ENGLISH), "-", true);
        int n = 0;
        HashMap hashMap = Utilities.initNameAndValues()[0];
        int n2 = -1;
        try {
            String string2;
            while (true) {
                if ((string2 = stringTokenizer.nextToken()).equals("-")) {
                    if (n2 == -1) continue;
                    n |= n2;
                    n2 = -1;
                    continue;
                }
                if (!stringTokenizer.hasMoreElements()) break;
                n2 = Utilities.readModifiers(string2);
            }
            Integer n3 = (Integer)hashMap.get(string2);
            boolean bl = (n & 0x8000) != 0;
            boolean bl2 = ((n &= 0xFFFF7FFF) & 0x10000) != 0;
            n &= 0xFFFEFFFF;
            if (n3 != null) {
                if (bl && (Utilities.getOperatingSystem() & 0x1000) != 0 && !Utilities.usableKeyOnMac(n3, n |= Utilities.getMenuShortCutKeyMask())) {
                    n &= ~Utilities.getMenuShortCutKeyMask();
                    n |= 2;
                }
                if (bl2) {
                    n = Utilities.getOperatingSystem() == 4096 ? (n |= 2) : (n |= 8);
                }
                return KeyStroke.getKeyStroke(n3, n);
            }
            return null;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    private static int getMenuShortCutKeyMask() {
        if (GraphicsEnvironment.isHeadless()) {
            return (Utilities.getOperatingSystem() & 0x1000) != 0 ? 4 : 2;
        }
        return Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    }

    private static boolean usableKeyOnMac(int n, int n2) {
        boolean bl;
        if (n == 81) {
            return false;
        }
        boolean bl2 = (n2 & 4) != 0 || (n2 & 0x80) != 0;
        boolean bl3 = (n2 & 8) != 0 || (n2 & 0x200) != 0;
        boolean bl4 = bl = bl2 && (n2 & 0xFFFFFEFB) == 0;
        if (bl) {
            return n != 72 && n != 32 && n != 9;
        }
        return n != 68 || !bl2 || !bl3;
    }

    public static KeyStroke[] stringToKeys(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.toUpperCase(Locale.ENGLISH), " ");
        ArrayList<KeyStroke> arrayList = new ArrayList<KeyStroke>();
        while (stringTokenizer.hasMoreElements()) {
            string = stringTokenizer.nextToken();
            KeyStroke keyStroke = Utilities.stringToKey(string);
            if (keyStroke == null) {
                return null;
            }
            arrayList.add(keyStroke);
        }
        return arrayList.toArray(new KeyStroke[arrayList.size()]);
    }

    private static boolean addModifiers(StringBuffer stringBuffer, int n) {
        boolean bl = false;
        if ((n & 2) != 0) {
            stringBuffer.append("C");
            bl = true;
        }
        if ((n & 8) != 0) {
            stringBuffer.append("A");
            bl = true;
        }
        if ((n & 1) != 0) {
            stringBuffer.append("S");
            bl = true;
        }
        if ((n & 4) != 0) {
            stringBuffer.append("M");
            bl = true;
        }
        if ((n & 0x8000) != 0) {
            stringBuffer.append("D");
            bl = true;
        }
        if ((n & 0x10000) != 0) {
            stringBuffer.append("O");
            bl = true;
        }
        return bl;
    }

    private static int readModifiers(String string) throws NoSuchElementException {
        int n = 0;
        block8: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case 'C': {
                    n |= 2;
                    continue block8;
                }
                case 'A': {
                    n |= 8;
                    continue block8;
                }
                case 'M': {
                    n |= 4;
                    continue block8;
                }
                case 'S': {
                    n |= 1;
                    continue block8;
                }
                case 'D': {
                    n |= 0x8000;
                    continue block8;
                }
                case 'O': {
                    n |= 0x10000;
                    continue block8;
                }
                default: {
                    throw new NoSuchElementException(string);
                }
            }
        }
        return n;
    }

    public static Object toPrimitiveArray(Object[] objectArray) {
        if (objectArray instanceof Integer[]) {
            int[] nArray = new int[objectArray.length];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                nArray[i] = objectArray[i] == null ? 0 : (Integer)objectArray[i];
            }
            return nArray;
        }
        if (objectArray instanceof Boolean[]) {
            boolean[] blArray = new boolean[objectArray.length];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                blArray[i] = objectArray[i] != null && (Boolean)objectArray[i] != false;
            }
            return blArray;
        }
        if (objectArray instanceof Byte[]) {
            byte[] byArray = new byte[objectArray.length];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                byArray[i] = objectArray[i] == null ? (byte)0 : (Byte)objectArray[i];
            }
            return byArray;
        }
        if (objectArray instanceof Character[]) {
            char[] cArray = new char[objectArray.length];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                cArray[i] = objectArray[i] == null ? (char)'\u0000' : ((Character)objectArray[i]).charValue();
            }
            return cArray;
        }
        if (objectArray instanceof Double[]) {
            double[] dArray = new double[objectArray.length];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                dArray[i] = objectArray[i] == null ? 0.0 : (Double)objectArray[i];
            }
            return dArray;
        }
        if (objectArray instanceof Float[]) {
            float[] fArray = new float[objectArray.length];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                fArray[i] = objectArray[i] == null ? 0.0f : ((Float)objectArray[i]).floatValue();
            }
            return fArray;
        }
        if (objectArray instanceof Long[]) {
            long[] lArray = new long[objectArray.length];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                lArray[i] = objectArray[i] == null ? 0L : (Long)objectArray[i];
            }
            return lArray;
        }
        if (objectArray instanceof Short[]) {
            short[] sArray = new short[objectArray.length];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                sArray[i] = objectArray[i] == null ? (short)0 : (Short)objectArray[i];
            }
            return sArray;
        }
        throw new IllegalArgumentException();
    }

    public static Object[] toObjectArray(Object object) {
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        if (object instanceof int[]) {
            int n = ((int[])object).length;
            Object[] objectArray = new Integer[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = new Integer(((int[])object)[i]);
            }
            return objectArray;
        }
        if (object instanceof boolean[]) {
            int n = ((boolean[])object).length;
            Object[] objectArray = new Boolean[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = ((boolean[])object)[i] ? Boolean.TRUE : Boolean.FALSE;
            }
            return objectArray;
        }
        if (object instanceof byte[]) {
            int n = ((byte[])object).length;
            Object[] objectArray = new Byte[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = new Byte(((byte[])object)[i]);
            }
            return objectArray;
        }
        if (object instanceof char[]) {
            int n = ((char[])object).length;
            Object[] objectArray = new Character[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = new Character(((char[])object)[i]);
            }
            return objectArray;
        }
        if (object instanceof double[]) {
            int n = ((double[])object).length;
            Object[] objectArray = new Double[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = new Double(((double[])object)[i]);
            }
            return objectArray;
        }
        if (object instanceof float[]) {
            int n = ((float[])object).length;
            Object[] objectArray = new Float[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = new Float(((float[])object)[i]);
            }
            return objectArray;
        }
        if (object instanceof long[]) {
            int n = ((long[])object).length;
            Object[] objectArray = new Long[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = new Long(((long[])object)[i]);
            }
            return objectArray;
        }
        if (object instanceof short[]) {
            int n = ((short[])object).length;
            Object[] objectArray = new Short[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = new Short(((short[])object)[i]);
            }
            return objectArray;
        }
        throw new IllegalArgumentException();
    }

    public static String[] wrapStringToArray(String string, int n, BreakIterator breakIterator, boolean bl) {
        int n2;
        int n3;
        String[] stringArray;
        block14: {
            if (string.length() == 0) {
                return new String[]{string};
            }
            if (bl) {
                string = Utilities.trimString(string);
                string = string.replace('\n', ' ');
                stringArray = new String[]{string};
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                n3 = stringTokenizer.countTokens();
                stringArray = new String[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    stringArray[n2] = stringTokenizer.nextToken();
                }
            }
            if (n < 1) {
                n = 1;
            }
            if (string.length() <= n) {
                return stringArray;
            }
            boolean bl2 = true;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                boolean bl3 = bl2 = bl2 && stringArray[n3].length() < n;
                if (bl2) {
                    continue;
                }
                break block14;
            }
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        n3 = 0;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2].length() < n) {
                arrayList.add(stringArray[n2]);
                continue;
            }
            breakIterator.setText(stringArray[n2]);
            int n4 = breakIterator.next();
            int n5 = 0;
            while (true) {
                if (n4 - n3 < n && n4 != -1) {
                    n5 = n4;
                    n4 = breakIterator.next();
                    continue;
                }
                if (n4 == -1) {
                    n4 = n5 = stringArray[n2].length();
                }
                if (n5 == 0) {
                    n5 = n4;
                }
                arrayList.add(stringArray[n2].substring(n3, n5));
                n3 = n5;
                n5 = 0;
                if (n3 >= stringArray[n2].length()) break;
            }
            n3 = 0;
        }
        String[] stringArray2 = new String[arrayList.size()];
        return arrayList.toArray(stringArray2);
    }

    private static String trimString(String string) {
        char c;
        int n = 0;
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        while (((c = string.charAt(n++)) == '\n' || c == '\r') && n < n2) {
        }
        --n;
        if ((n = (string = string.substring(n)).length() - 1) < 0) {
            return string;
        }
        while (((c = string.charAt(n--)) == '\n' || c == '\r') && n >= 0) {
        }
        return string.substring(0, n + 2);
    }
}

