/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.util;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class PaintUtils {
    public static final GradientPaint BLUE_EXPERIENCE = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(168, 204, 241), new Point2D.Double(0.0, 1.0), new Color(44, 61, 146));
    public static final GradientPaint MAC_OSX_SELECTED = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(81, 141, 236), new Point2D.Double(0.0, 1.0), new Color(36, 96, 192));
    public static final GradientPaint MAC_OSX = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(167, 210, 250), new Point2D.Double(0.0, 1.0), new Color(99, 147, 206));
    public static final GradientPaint AERITH = new GradientPaint(new Point2D.Double(0.0, 0.0), Color.WHITE, new Point2D.Double(0.0, 1.0), new Color(64, 110, 161));
    public static final GradientPaint GRAY = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(226, 226, 226), new Point2D.Double(0.0, 1.0), new Color(250, 248, 248));
    public static final GradientPaint RED_XP = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(236, 81, 81), new Point2D.Double(0.0, 1.0), new Color(192, 36, 36));
    public static final GradientPaint NIGHT_GRAY = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(102, 111, 127), new Point2D.Double(0.0, 1.0), new Color(38, 45, 61));
    public static final GradientPaint NIGHT_GRAY_LIGHT = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(129, 138, 155), new Point2D.Double(0.0, 1.0), new Color(58, 66, 82));

    public static Rectangle getTextBounds(Graphics graphics, JLabel jLabel) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(jLabel.getText(), graphics);
        Rectangle rectangle = rectangle2D.getBounds();
        int n = 0;
        switch (jLabel.getHorizontalAlignment()) {
            case 4: 
            case 11: {
                n = jLabel.getBounds().width - rectangle.width;
                break;
            }
            case 0: {
                n = (jLabel.getBounds().width - rectangle.width) / 2;
                break;
            }
            default: {
                n = 0;
            }
        }
        int n2 = 0;
        switch (jLabel.getVerticalAlignment()) {
            case 1: {
                n2 = 0;
                break;
            }
            case 0: {
                n2 = (jLabel.getBounds().height - rectangle.height) / 2;
                break;
            }
            case 3: {
                n2 = jLabel.getBounds().height - rectangle.height;
            }
        }
        return new Rectangle(n, n2, rectangle.width, rectangle.height);
    }

    public static void paintGradient(Graphics graphics, JComponent jComponent, Color color, Color color2) {
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, 0.0f, jComponent.getHeight(), color2, true);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        graphics2D.setPaint(paint);
    }

    public static Paint resizeGradient(Paint paint, int n, int n2) {
        if (paint == null) {
            return paint;
        }
        if (paint instanceof GradientPaint) {
            GradientPaint gradientPaint = (GradientPaint)paint;
            Point2D[] point2DArray = new Point2D[]{gradientPaint.getPoint1(), gradientPaint.getPoint2()};
            point2DArray = PaintUtils.adjustPoints(point2DArray, n, n2);
            return new GradientPaint(point2DArray[0], gradientPaint.getColor1(), point2DArray[1], gradientPaint.getColor2(), gradientPaint.isCyclic());
        }
        if ("java.awt.LinearGradientPaint".equals(paint.getClass().getName()) || "org.apache.batik.ext.awt.LinearGradientPaint".equals(paint.getClass().getName())) {
            return PaintUtils.resizeLinearGradient(paint, n, n2);
        }
        return paint;
    }

    private static Paint resizeLinearGradient(Paint paint, int n, int n2) {
        try {
            Point2D[] point2DArray = new Point2D[]{(Point2D)PaintUtils.invokeMethod(paint, "getStartPoint"), (Point2D)PaintUtils.invokeMethod(paint, "getEndPoint")};
            point2DArray = PaintUtils.adjustPoints(point2DArray, n, n2);
            float[] fArray = (float[])PaintUtils.invokeMethod(paint, "getFractions");
            Color[] colorArray = (Color[])PaintUtils.invokeMethod(paint, "getColors");
            Constructor<?> constructor = paint.getClass().getDeclaredConstructor(Point2D.class, Point2D.class, new float[0].getClass(), new Color[0].getClass());
            return (Paint)constructor.newInstance(point2DArray[0], point2DArray[1], fArray, colorArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return paint;
        }
    }

    private static Object invokeMethod(Object object, String string) throws NoSuchMethodException, InvocationTargetException, IllegalArgumentException, SecurityException, IllegalAccessException {
        Method method = object.getClass().getMethod(string, new Class[0]);
        return method.invoke(object, new Object[0]);
    }

    private static Point2D[] adjustPoints(Point2D[] point2DArray, int n, int n2) {
        Point2D point2D = point2DArray[0];
        Point2D point2D2 = point2DArray[1];
        double d = PaintUtils.calcAngle(point2D, point2D2);
        double d2 = Math.toDegrees(d);
        double d3 = 1.0;
        if (Math.abs(d) < Math.toRadians(d3) || Math.abs(d) > Math.toRadians(360.0 - d3)) {
            point2D = new Point2D.Float(0.0f, 0.0f);
            point2D2 = new Point2D.Float(n, 0.0f);
        }
        if (PaintUtils.isNear(d2, 45.0, d3)) {
            point2D = new Point2D.Float(0.0f, 0.0f);
            point2D2 = new Point2D.Float(n, n2);
        }
        if (PaintUtils.isNear(d2, 90.0, d3)) {
            point2D = new Point2D.Float(0.0f, 0.0f);
            point2D2 = new Point2D.Float(0.0f, n2);
        }
        if (PaintUtils.isNear(d2, 135.0, d3)) {
            point2D = new Point2D.Float(n, 0.0f);
            point2D2 = new Point2D.Float(0.0f, n2);
        }
        if (PaintUtils.isNear(d2, 180.0, d3)) {
            point2D = new Point2D.Float(n, 0.0f);
            point2D2 = new Point2D.Float(0.0f, 0.0f);
        }
        if (PaintUtils.isNear(d2, 225.0, d3)) {
            point2D = new Point2D.Float(n, n2);
            point2D2 = new Point2D.Float(0.0f, 0.0f);
        }
        if (PaintUtils.isNear(d2, 270.0, d3)) {
            point2D = new Point2D.Float(0.0f, n2);
            point2D2 = new Point2D.Float(0.0f, 0.0f);
        }
        if (PaintUtils.isNear(d2, 315.0, d3)) {
            point2D = new Point2D.Float(0.0f, n2);
            point2D2 = new Point2D.Float(n, 0.0f);
        }
        return new Point2D[]{point2D, point2D2};
    }

    private static boolean isNear(double d, double d2, double d3) {
        return Math.abs(d2 - Math.abs(d)) < d3;
    }

    private static double calcAngle(Point2D point2D, Point2D point2D2) {
        double d = point2D2.getX() - point2D.getX();
        double d2 = point2D2.getY() - point2D.getY();
        double d3 = Math.atan(d2 / d);
        if (d < 0.0) {
            d3 += Math.PI;
        }
        if (d3 < 0.0) {
            d3 += Math.PI * 2;
        }
        if (d3 > Math.PI * 2) {
            d3 -= Math.PI * 2;
        }
        return d3;
    }
}

