/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.treetable;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

public class TreeTableCellEditor
extends DefaultCellEditor {
    private final JTree tree;

    public TreeTableCellEditor(JTree jTree) {
        super(new TreeTableTextField());
        if (jTree == null) {
            throw new IllegalArgumentException("null tree");
        }
        this.tree = jTree;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        this.initEditorOffset(jTable, n, n2, bl);
        return component;
    }

    protected void initEditorOffset(JTable jTable, int n, int n2, boolean bl) {
        JLabel jLabel;
        Icon icon;
        if (this.tree == null) {
            return;
        }
        Rectangle rectangle = this.tree.getRowBounds(n);
        int n3 = rectangle.x;
        Object object = this.tree.getPathForRow(n).getLastPathComponent();
        boolean bl2 = this.tree.getModel().isLeaf(object);
        boolean bl3 = this.tree.isExpanded(n);
        TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
        Component component = treeCellRenderer.getTreeCellRendererComponent(this.tree, object, bl, bl3, bl2, n, false);
        if (component instanceof JLabel && jTable.getComponentOrientation().isLeftToRight() && (icon = (jLabel = (JLabel)component).getIcon()) != null) {
            n3 += icon.getIconWidth() + jLabel.getIconTextGap();
        }
        ((TreeTableTextField)this.getComponent()).init(n3, n2, rectangle.width, jTable);
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    static class TreeTableTextField
    extends JTextField {
        private int offset;
        private int column;
        private int width;
        private JTable table;

        TreeTableTextField() {
        }

        void init(int n, int n2, int n3, JTable jTable) {
            this.offset = n;
            this.column = n2;
            this.width = n3;
            this.table = jTable;
            this.setComponentOrientation(jTable.getComponentOrientation());
        }

        public void reshape(int n, int n2, int n3, int n4) {
            if (this.table.getComponentOrientation().isLeftToRight()) {
                int n5 = this.offset - this.getInsets().left;
                super.reshape(n + n5, n2, n3 - n5, n4);
            } else {
                int n6 = this.offset + this.getInsets().left;
                int n7 = this.getColumnPositionBidi();
                n3 = this.table.getColumnModel().getColumn(this.getBidiTreeColumn()).getWidth();
                n3 -= n3 - n6 - this.width;
                super.reshape(n7, n2, n3, n4);
            }
        }

        private int getBidiTreeColumn() {
            return this.table.getColumnCount() - this.column - 1;
        }

        private int getColumnPositionBidi() {
            int n = 0;
            int n2 = this.getBidiTreeColumn();
            for (int i = 0; i < n2; ++i) {
                n += this.table.getColumnModel().getColumn(i).getWidth();
            }
            return n;
        }
    }
}

