/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.treetable;

import java.io.File;
import java.util.Arrays;
import java.util.Date;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemModel
extends AbstractTreeTableModel {
    private static final Long DIRECTORY = 0L;

    public FileSystemModel() {
        this(new File(File.separator));
    }

    public FileSystemModel(File file) {
        super(file);
    }

    private boolean isValidFileNode(Object object) {
        boolean bl = false;
        if (object instanceof File) {
            for (File file = (File)object; !bl && file != null; file = file.getParentFile()) {
                bl = file.equals(this.root);
            }
        }
        return bl;
    }

    @Override
    public File getChild(Object object, int n) {
        if (!this.isValidFileNode(object)) {
            throw new IllegalArgumentException("parent is not a file governed by this model");
        }
        File file = (File)object;
        String[] stringArray = file.list();
        if (stringArray != null) {
            return new File(file, stringArray[n]);
        }
        return null;
    }

    @Override
    public int getChildCount(Object object) {
        String[] stringArray;
        if (object instanceof File && (stringArray = ((File)object).list()) != null) {
            return stringArray.length;
        }
        return 0;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Long.class;
            }
            case 2: {
                return Boolean.class;
            }
            case 3: {
                return Date.class;
            }
        }
        return super.getColumnClass(n);
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Size";
            }
            case 2: {
                return "Directory";
            }
            case 3: {
                return "Modification Date";
            }
        }
        return super.getColumnName(n);
    }

    @Override
    public Object getValueAt(Object object, int n) {
        if (object instanceof File) {
            File file = (File)object;
            switch (n) {
                case 0: {
                    return file.getName();
                }
                case 1: {
                    return this.isLeaf(object) ? file.length() : DIRECTORY.longValue();
                }
                case 2: {
                    return file.isDirectory();
                }
                case 3: {
                    return new Date(file.lastModified());
                }
            }
        }
        return null;
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        if (object instanceof File && object2 instanceof File) {
            File file = (File)object;
            Object[] objectArray = file.listFiles();
            Arrays.sort(objectArray);
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                if (!((File)objectArray[i]).equals(object2)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public File getRoot() {
        return (File)this.root;
    }

    public void setRoot(File file) {
        this.root = file;
        this.modelSupport.fireNewRoot();
    }

    @Override
    public boolean isLeaf(Object object) {
        if (object instanceof File) {
            return ((File)object).list() == null;
        }
        return true;
    }
}

