/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import org.jdesktop.swingx.table.NumberEditorNumberFormat;

public class NumberEditorExt
extends DefaultCellEditor {
    private static Class[] argTypes = new Class[]{String.class};
    Constructor constructor;

    public NumberEditorExt() {
        this((NumberFormat)null);
    }

    public NumberEditorExt(NumberFormat numberFormat) {
        super(NumberEditorExt.createFormattedTextField(numberFormat));
        JFormattedTextField jFormattedTextField = (JFormattedTextField)this.getComponent();
        jFormattedTextField.setName("Table.editor");
        jFormattedTextField.setHorizontalAlignment(4);
        jFormattedTextField.removeActionListener(this.delegate);
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            public void setValue(Object object) {
                ((JFormattedTextField)NumberEditorExt.this.getComponent()).setValue(object);
            }

            public Object getCellEditorValue() {
                JFormattedTextField jFormattedTextField = (JFormattedTextField)NumberEditorExt.this.getComponent();
                try {
                    jFormattedTextField.commitEdit();
                    return jFormattedTextField.getValue();
                }
                catch (ParseException parseException) {
                    return null;
                }
            }
        };
        jFormattedTextField.addActionListener(this.delegate);
    }

    public boolean stopCellEditing() {
        if (!((JFormattedTextField)this.editorComponent).isEditValid()) {
            return false;
        }
        return super.stopCellEditing();
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
        try {
            Class<?> clazz = jTable.getColumnClass(n2);
            if (!Number.class.isAssignableFrom(clazz)) {
                throw new IllegalStateException("NumberEditor can only handle subclasses of java.lang.Number");
            }
            this.constructor = clazz.getConstructor(argTypes);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Number subclass must have a constructor which takes a string", exception);
        }
        return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
    }

    public Object getCellEditorValue() {
        Number number = (Number)super.getCellEditorValue();
        if (number == null) {
            return null;
        }
        try {
            return this.constructor.newInstance(number.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException("NumberEditor not propertly configured", illegalArgumentException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("NumberEditor not propertly configured", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("NumberEditor not propertly configured", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException("NumberEditor not propertly configured", invocationTargetException);
        }
    }

    private static JFormattedTextField createFormattedTextField(NumberFormat numberFormat) {
        JFormattedTextField jFormattedTextField = new JFormattedTextField(new NumberEditorNumberFormat(numberFormat));
        for (InputMap inputMap = jFormattedTextField.getInputMap(); inputMap != null; inputMap = inputMap.getParent()) {
            inputMap.remove(KeyStroke.getKeyStroke("pressed ESCAPE"));
        }
        jFormattedTextField.setInputVerifier(new InputVerifier(){

            public boolean verify(JComponent jComponent) {
                JFormattedTextField jFormattedTextField = (JFormattedTextField)jComponent;
                return jFormattedTextField.isEditValid();
            }
        });
        jFormattedTextField.addPropertyChangeListener("editValid", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getNewValue() == Boolean.TRUE) {
                    ((JFormattedTextField)propertyChangeEvent.getSource()).setBorder(new LineBorder(Color.black));
                } else {
                    ((JFormattedTextField)propertyChangeEvent.getSource()).setBorder(new LineBorder(Color.red));
                }
            }
        });
        return jFormattedTextField;
    }
}

