/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.treetable.AbstractMutableTreeTableNode;

public class DatePickerCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TreeCellEditor {
    protected JXDatePicker datePicker;
    protected DateFormat dateFormat;
    protected int clickCountToStart = 2;
    private ActionListener pickerActionListener;
    protected boolean ignoreAction;
    private static Logger logger = Logger.getLogger(DatePickerCellEditor.class.getName());

    public DatePickerCellEditor() {
        this(null);
    }

    public DatePickerCellEditor(DateFormat dateFormat) {
        this.dateFormat = dateFormat != null ? dateFormat : DateFormat.getDateInstance();
        this.datePicker = new JXDatePicker();
        this.datePicker.getEditor().setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        this.datePicker.setFont(UIManager.getDefaults().getFont("TextField.font"));
        if (dateFormat != null) {
            this.datePicker.setFormats(dateFormat);
        }
        this.datePicker.addActionListener(this.getPickerActionListener());
    }

    public Date getCellEditorValue() {
        return this.datePicker.getDate();
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= this.getClickCountToStart();
        }
        return super.isCellEditable(eventObject);
    }

    public boolean stopCellEditing() {
        this.ignoreAction = true;
        boolean bl = this.commitChange();
        this.ignoreAction = false;
        if (bl) {
            return super.stopCellEditing();
        }
        return false;
    }

    public void setClickCountToStart(int n) {
        this.clickCountToStart = n;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.ignoreAction = true;
        this.datePicker.setDate(this.getValueAsDate(object));
        this.ignoreAction = false;
        return this.datePicker;
    }

    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        this.ignoreAction = true;
        this.datePicker.setDate(this.getValueAsDate(object));
        this.ignoreAction = false;
        return this.datePicker;
    }

    protected Date getValueAsDate(Object object) {
        if (this.isEmpty(object)) {
            return null;
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Long) {
            return new Date((Long)object);
        }
        if (object instanceof String) {
            try {
                return this.dateFormat.parse((String)object);
            }
            catch (ParseException parseException) {
                this.handleParseException(parseException);
            }
        }
        if (object instanceof DefaultMutableTreeNode) {
            return this.getValueAsDate(((DefaultMutableTreeNode)object).getUserObject());
        }
        if (object instanceof AbstractMutableTreeTableNode) {
            return this.getValueAsDate(((AbstractMutableTreeTableNode)object).getUserObject());
        }
        return null;
    }

    protected void handleParseException(ParseException parseException) {
        logger.log(Level.SEVERE, parseException.getMessage(), parseException.getMessage());
    }

    protected boolean isEmpty(Object object) {
        return object == null || object instanceof String && ((String)object).length() == 0;
    }

    protected boolean commitChange() {
        try {
            this.datePicker.commitEdit();
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public DateFormat[] getFormats() {
        return this.datePicker.getFormats();
    }

    public void setFormats(DateFormat ... dateFormatArray) {
        this.datePicker.setFormats(dateFormatArray);
    }

    protected ActionListener getPickerActionListener() {
        if (this.pickerActionListener == null) {
            this.pickerActionListener = this.createPickerActionListener();
        }
        return this.pickerActionListener;
    }

    protected ActionListener createPickerActionListener() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DatePickerCellEditor.this.ignoreAction) {
                    return;
                }
                this.terminateEdit(actionEvent);
            }

            private void terminateEdit(ActionEvent actionEvent) {
                if (actionEvent != null && "datePickerCommit".equals(actionEvent.getActionCommand())) {
                    DatePickerCellEditor.this.stopCellEditing();
                } else {
                    DatePickerCellEditor.this.cancelCellEditing();
                }
            }
        };
        return actionListener;
    }
}

